/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.statement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.cli.interpreter.logging.Log;
import org.infinispan.cli.interpreter.result.EmptyResult;
import org.infinispan.cli.interpreter.result.Result;
import org.infinispan.cli.interpreter.result.StatementException;
import org.infinispan.cli.interpreter.session.Session;
import org.infinispan.cli.interpreter.statement.Option;
import org.infinispan.cli.interpreter.statement.Statement;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.upgrade.RollingUpgradeManager;
import org.infinispan.util.logging.LogFactory;

public class UpgradeStatement
implements Statement {
    public static final Log log = (Log)LogFactory.getLog(UpgradeStatement.class, Log.class);
    final String cacheName;
    private final List<Option> options;

    public UpgradeStatement(List<Option> options, String cacheName) {
        this.options = options;
        this.cacheName = cacheName;
    }

    @Override
    public Result execute(Session session) throws StatementException {
        boolean all = false;
        UpgradeMode mode = UpgradeMode.NONE;
        String migratorName = null;
        for (Option option : this.options) {
            if ("all".equals(option.getName())) {
                all = true;
                continue;
            }
            if ("dumpkeys".equals(option.getName())) {
                mode = UpgradeMode.DUMPKEYS;
                continue;
            }
            if ("synchronize".equals(option.getName())) {
                mode = UpgradeMode.SYNCHRONIZE;
                migratorName = option.getParameter();
                if (migratorName != null) continue;
                throw log.missingMigrator();
            }
            if ("disconnectsource".equals(option.getName())) {
                mode = UpgradeMode.DISCONNECTSOURCE;
                migratorName = option.getParameter();
                if (migratorName != null) continue;
                throw log.missingMigrator();
            }
            throw new StatementException("Unknown option " + option.getName());
        }
        switch (mode) {
            case DUMPKEYS: {
                for (Cache cache : all ? this.getAllCaches(session) : Collections.singletonList(session.getCache(this.cacheName))) {
                    RollingUpgradeManager upgradeManager = (RollingUpgradeManager)cache.getAdvancedCache().getComponentRegistry().getComponent(RollingUpgradeManager.class);
                    upgradeManager.recordKnownGlobalKeyset();
                }
                break;
            }
            case SYNCHRONIZE: {
                for (Cache cache : all ? this.getAllCaches(session) : Collections.singletonList(session.getCache(this.cacheName))) {
                    RollingUpgradeManager upgradeManager = (RollingUpgradeManager)cache.getAdvancedCache().getComponentRegistry().getComponent(RollingUpgradeManager.class);
                    try {
                        upgradeManager.synchronizeData(migratorName);
                    }
                    catch (Exception e) {
                        throw new StatementException(e.getMessage());
                    }
                }
                break;
            }
            case DISCONNECTSOURCE: {
                for (Cache cache : all ? this.getAllCaches(session) : Collections.singletonList(session.getCache(this.cacheName))) {
                    RollingUpgradeManager upgradeManager = (RollingUpgradeManager)cache.getAdvancedCache().getComponentRegistry().getComponent(RollingUpgradeManager.class);
                    try {
                        upgradeManager.disconnectSource(migratorName);
                    }
                    catch (Exception e) {
                        throw new StatementException(e.getMessage());
                    }
                }
                break;
            }
            case NONE: {
                throw log.missingUpgradeAction();
            }
        }
        return EmptyResult.RESULT;
    }

    private List<Cache<?, ?>> getAllCaches(Session session) {
        ArrayList caches = new ArrayList();
        EmbeddedCacheManager container = session.getCacheManager();
        for (String cacheName : container.getCacheNames()) {
            if (!container.isRunning(cacheName)) continue;
            caches.add(session.getCache(cacheName));
        }
        caches.add(container.getCache());
        return caches;
    }

    private static enum UpgradeMode {
        NONE,
        DUMPKEYS,
        SYNCHRONIZE,
        DISCONNECTSOURCE;

    }
}

