/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.statement;

import java.util.List;
import org.infinispan.Cache;
import org.infinispan.cli.interpreter.logging.Log;
import org.infinispan.cli.interpreter.result.EmptyResult;
import org.infinispan.cli.interpreter.result.Result;
import org.infinispan.cli.interpreter.result.StatementException;
import org.infinispan.cli.interpreter.result.StringResult;
import org.infinispan.cli.interpreter.session.Session;
import org.infinispan.cli.interpreter.statement.Option;
import org.infinispan.cli.interpreter.statement.SiteData;
import org.infinispan.cli.interpreter.statement.Statement;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.XSiteAdminOperations;

public class SiteStatement
implements Statement {
    private static final Log log = (Log)LogFactory.getLog(SiteStatement.class, Log.class);
    private final SiteData siteData;
    private final List<Option> options;

    public SiteStatement(List<Option> options, SiteData siteData) {
        this.options = options;
        this.siteData = siteData;
    }

    @Override
    public Result execute(Session session) throws StatementException {
        Cache cache = session.getCache(this.siteData.getCacheName());
        String siteName = this.siteData.getSiteName();
        XSiteAdminOperations xsiteAdmin = (XSiteAdminOperations)cache.getAdvancedCache().getComponentRegistry().getComponent(XSiteAdminOperations.class);
        for (Option opt : this.options) {
            switch (opt.toEnum(Options.class)) {
                case STATUS: {
                    String status = siteName == null ? xsiteAdmin.status() : xsiteAdmin.siteStatus(siteName);
                    return new StringResult(status);
                }
                case ONLINE: {
                    if (siteName != null) {
                        return new StringResult(xsiteAdmin.bringSiteOnline(siteName));
                    }
                    throw log.siteNameNotSpecified();
                }
                case OFFLINE: {
                    if (siteName != null) {
                        return new StringResult(xsiteAdmin.takeSiteOffline(siteName));
                    }
                    throw log.siteNameNotSpecified();
                }
            }
        }
        return EmptyResult.RESULT;
    }

    static enum Options {
        OFFLINE,
        ONLINE,
        STATUS;

    }
}

