/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.statement;

import java.util.List;
import org.infinispan.Cache;
import org.infinispan.cli.interpreter.logging.Log;
import org.infinispan.cli.interpreter.result.Result;
import org.infinispan.cli.interpreter.result.StatementException;
import org.infinispan.cli.interpreter.result.StringResult;
import org.infinispan.cli.interpreter.session.Session;
import org.infinispan.cli.interpreter.statement.KeyData;
import org.infinispan.cli.interpreter.statement.Statement;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.util.logging.LogFactory;

public class LocateStatement
implements Statement {
    private static final Log log = (Log)LogFactory.getLog(LocateStatement.class, Log.class);
    final KeyData keyData;

    public LocateStatement(KeyData key) {
        this.keyData = key;
    }

    @Override
    public Result execute(Session session) throws StatementException {
        Cache cache = session.getCache(this.keyData.getCacheName());
        DistributionManager distributionManager = cache.getAdvancedCache().getDistributionManager();
        if (distributionManager != null) {
            List addresses = distributionManager.locate(this.keyData.getKey());
            return new StringResult(addresses.toString());
        }
        throw log.cacheNotDistributed();
    }
}

