/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.statement;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.cli.interpreter.codec.Codec;
import org.infinispan.cli.interpreter.logging.Log;
import org.infinispan.cli.interpreter.result.EmptyResult;
import org.infinispan.cli.interpreter.result.Result;
import org.infinispan.cli.interpreter.result.StatementException;
import org.infinispan.cli.interpreter.session.Session;
import org.infinispan.cli.interpreter.statement.ExpirationData;
import org.infinispan.cli.interpreter.statement.KeyData;
import org.infinispan.cli.interpreter.statement.Option;
import org.infinispan.cli.interpreter.statement.Statement;
import org.infinispan.util.logging.LogFactory;

public class ReplaceStatement
implements Statement {
    private static final Log log = (Log)LogFactory.getLog(ReplaceStatement.class, Log.class);
    final KeyData keyData;
    final Object oldValue;
    final Object newValue;
    final Long expires;
    final Long maxIdle;
    private final List<Option> options;

    public ReplaceStatement(List<Option> options, KeyData key, Object newValue, ExpirationData exp) {
        this(options, key, null, newValue, exp);
    }

    public ReplaceStatement(List<Option> options, KeyData key, Object oldValue, Object newValue, ExpirationData exp) {
        this.options = options;
        this.keyData = key;
        this.oldValue = oldValue;
        this.newValue = newValue;
        if (exp != null) {
            this.expires = exp.expires;
            this.maxIdle = exp.maxIdle;
        } else {
            this.expires = null;
            this.maxIdle = null;
        }
    }

    @Override
    public Result execute(Session session) throws StatementException {
        Cache cache = session.getCache(this.keyData.getCacheName());
        Codec codec = session.getCodec();
        if (this.options.size() > 0) {
            for (Option option : this.options) {
                switch (option.toEnum(Options.class)) {
                    case CODEC: {
                        if (option.getParameter() == null) {
                            throw log.missingOptionParameter(option.getName());
                        }
                        codec = session.getCodec(option.getParameter());
                    }
                }
            }
        }
        Object encodedKey = codec.encodeKey(this.keyData.getKey());
        Object encodedOldValue = codec.encodeValue(this.oldValue);
        Object encodedNewValue = codec.encodeValue(this.newValue);
        if (this.expires == null) {
            if (this.oldValue != null) {
                cache.replace(encodedKey, encodedOldValue, encodedNewValue);
            } else {
                cache.replace(encodedKey, encodedNewValue);
            }
        } else if (this.maxIdle == null) {
            if (this.oldValue != null) {
                cache.replace(encodedKey, encodedOldValue, encodedNewValue, this.expires.longValue(), TimeUnit.MILLISECONDS);
            } else {
                cache.replace(encodedKey, encodedNewValue, this.expires.longValue(), TimeUnit.MILLISECONDS);
            }
        } else if (this.oldValue != null) {
            cache.replace(encodedKey, encodedOldValue, encodedNewValue, this.expires.longValue(), TimeUnit.MILLISECONDS, this.maxIdle.longValue(), TimeUnit.MILLISECONDS);
        } else {
            cache.replace(encodedKey, encodedNewValue, this.expires.longValue(), TimeUnit.MILLISECONDS, this.maxIdle.longValue(), TimeUnit.MILLISECONDS);
        }
        return EmptyResult.RESULT;
    }

    private static enum Options {
        CODEC;

    }
}

