// $ANTLR 3.4 org/infinispan/cli/interpreter/IspnQL.g 2013-07-08 18:00:30

/*
 * JBoss, Home of Professional Open Source
 * Copyright 2012 Red Hat Inc. and/or its affiliates and other contributors
 * as indicated by the @author tags. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.infinispan.cli.interpreter;

import java.io.IOException;
import java.util.Map;
import java.util.HashMap;
import java.util.Collections;
import java.util.List;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectMapper.DefaultTyping;

import org.infinispan.cli.interpreter.session.*;
import org.infinispan.cli.interpreter.statement.*;
import static org.infinispan.cli.interpreter.utils.ParserSupport.*;



import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

import org.antlr.runtime.tree.*;


@SuppressWarnings({"all", "warnings", "unchecked"})
public class IspnQLParser extends Parser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "ABORT", "AlphaChar", "AlphaNumChar", "BEGIN", "CACHE", "CLEAR", "COMMIT", "CREATE", "CharacterEscapeSequence", "Comment", "DOUBLELITERAL", "DecimalDigit", "DoubleQuotedStringCharacter", "DoubleSuffix", "ENCODING", "END", "EOL", "EVICT", "EXPIRES", "EscapeCharacter", "EscapeSequence", "Exponent", "FALSE", "FLOATLITERAL", "FloatSuffix", "GET", "HexDigit", "HexEscapeSequence", "HexPrefix", "INFO", "INTLITERAL", "IntegerNumber", "LIKE", "LOCATE", "LONGLITERAL", "LineComment", "LongSuffix", "MAXIDLE", "NULL", "NonEscapeCharacter", "NonIntegerNumber", "PING", "PUT", "REMOVE", "REPLACE", "ROLLBACK", "SITE", "START", "STATS", "STRINGLITERAL", "SingleEscapeCharacter", "SingleQuotedStringCharacter", "TIMELITERAL", "TRUE", "TimeSuffix", "UPGRADE", "UUIDLITERAL", "UnicodeEscapeSequence", "UnquotedStringCharacter", "UnquotedStringStart", "VERSION", "WhiteSpace", "','", "'--'", "'.'", "':'", "';'", "'='", "'['", "']'", "'{'", "'}'"
    };

    public static final int EOF=-1;
    public static final int T__66=66;
    public static final int T__67=67;
    public static final int T__68=68;
    public static final int T__69=69;
    public static final int T__70=70;
    public static final int T__71=71;
    public static final int T__72=72;
    public static final int T__73=73;
    public static final int T__74=74;
    public static final int T__75=75;
    public static final int ABORT=4;
    public static final int AlphaChar=5;
    public static final int AlphaNumChar=6;
    public static final int BEGIN=7;
    public static final int CACHE=8;
    public static final int CLEAR=9;
    public static final int COMMIT=10;
    public static final int CREATE=11;
    public static final int CharacterEscapeSequence=12;
    public static final int Comment=13;
    public static final int DOUBLELITERAL=14;
    public static final int DecimalDigit=15;
    public static final int DoubleQuotedStringCharacter=16;
    public static final int DoubleSuffix=17;
    public static final int ENCODING=18;
    public static final int END=19;
    public static final int EOL=20;
    public static final int EVICT=21;
    public static final int EXPIRES=22;
    public static final int EscapeCharacter=23;
    public static final int EscapeSequence=24;
    public static final int Exponent=25;
    public static final int FALSE=26;
    public static final int FLOATLITERAL=27;
    public static final int FloatSuffix=28;
    public static final int GET=29;
    public static final int HexDigit=30;
    public static final int HexEscapeSequence=31;
    public static final int HexPrefix=32;
    public static final int INFO=33;
    public static final int INTLITERAL=34;
    public static final int IntegerNumber=35;
    public static final int LIKE=36;
    public static final int LOCATE=37;
    public static final int LONGLITERAL=38;
    public static final int LineComment=39;
    public static final int LongSuffix=40;
    public static final int MAXIDLE=41;
    public static final int NULL=42;
    public static final int NonEscapeCharacter=43;
    public static final int NonIntegerNumber=44;
    public static final int PING=45;
    public static final int PUT=46;
    public static final int REMOVE=47;
    public static final int REPLACE=48;
    public static final int ROLLBACK=49;
    public static final int SITE=50;
    public static final int START=51;
    public static final int STATS=52;
    public static final int STRINGLITERAL=53;
    public static final int SingleEscapeCharacter=54;
    public static final int SingleQuotedStringCharacter=55;
    public static final int TIMELITERAL=56;
    public static final int TRUE=57;
    public static final int TimeSuffix=58;
    public static final int UPGRADE=59;
    public static final int UUIDLITERAL=60;
    public static final int UnicodeEscapeSequence=61;
    public static final int UnquotedStringCharacter=62;
    public static final int UnquotedStringStart=63;
    public static final int VERSION=64;
    public static final int WhiteSpace=65;

    // delegates
    public Parser[] getDelegates() {
        return new Parser[] {};
    }

    // delegators


    public IspnQLParser(TokenStream input) {
        this(input, new RecognizerSharedState());
    }
    public IspnQLParser(TokenStream input, RecognizerSharedState state) {
        super(input, state);
    }

protected TreeAdaptor adaptor = new CommonTreeAdaptor();

public void setTreeAdaptor(TreeAdaptor adaptor) {
    this.adaptor = adaptor;
}
public TreeAdaptor getTreeAdaptor() {
    return adaptor;
}
    public String[] getTokenNames() { return IspnQLParser.tokenNames; }
    public String getGrammarFileName() { return "org/infinispan/cli/interpreter/IspnQL.g"; }


       private List<String> parserErrors = new ArrayList<String>();
       protected List<Statement> statements = new ArrayList<Statement>();
       private ObjectMapper jsonMapper = new ObjectMapper().enableDefaultTyping(DefaultTyping.NON_FINAL, JsonTypeInfo.As.WRAPPER_OBJECT);

       public void displayRecognitionError(String[] tokenNames, RecognitionException e) {
         parserErrors.add(getErrorHeader(e)+" "+getErrorMessage(e, tokenNames));
       }

       public List<String> getParserErrors() {
         return parserErrors;
       }


    public static class statements_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "statements"
    // org/infinispan/cli/interpreter/IspnQL.g:106:1: statements : ( statement ( EOL )* )* EOF ;
    public final IspnQLParser.statements_return statements() throws RecognitionException {
        IspnQLParser.statements_return retval = new IspnQLParser.statements_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token EOL2=null;
        Token EOF3=null;
        IspnQLParser.statement_return statement1 =null;


        Object EOL2_tree=null;
        Object EOF3_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:107:4: ( ( statement ( EOL )* )* EOF )
            // org/infinispan/cli/interpreter/IspnQL.g:107:6: ( statement ( EOL )* )* EOF
            {
            // org/infinispan/cli/interpreter/IspnQL.g:107:6: ( statement ( EOL )* )*
            loop2:
            do {
                int alt2=2;
                switch ( input.LA(1) ) {
                case ABORT:
                case BEGIN:
                case CACHE:
                case CLEAR:
                case COMMIT:
                case CREATE:
                case ENCODING:
                case END:
                case EVICT:
                case GET:
                case INFO:
                case LOCATE:
                case PING:
                case PUT:
                case REMOVE:
                case REPLACE:
                case ROLLBACK:
                case SITE:
                case START:
                case STATS:
                case UPGRADE:
                case VERSION:
                    {
                    alt2=1;
                    }
                    break;

                }

                switch (alt2) {
            	case 1 :
            	    // org/infinispan/cli/interpreter/IspnQL.g:107:7: statement ( EOL )*
            	    {
            	    pushFollow(FOLLOW_statement_in_statements72);
            	    statement1=statement();

            	    state._fsp--;

            	    adaptor.addChild(root_0, statement1.getTree());

            	     statements.add((statement1!=null?statement1.stmt:null)); 

            	    // org/infinispan/cli/interpreter/IspnQL.g:107:54: ( EOL )*
            	    loop1:
            	    do {
            	        int alt1=2;
            	        switch ( input.LA(1) ) {
            	        case EOL:
            	            {
            	            alt1=1;
            	            }
            	            break;

            	        }

            	        switch (alt1) {
            	    	case 1 :
            	    	    // org/infinispan/cli/interpreter/IspnQL.g:107:54: EOL
            	    	    {
            	    	    EOL2=(Token)match(input,EOL,FOLLOW_EOL_in_statements76); 
            	    	    EOL2_tree = 
            	    	    (Object)adaptor.create(EOL2)
            	    	    ;
            	    	    adaptor.addChild(root_0, EOL2_tree);


            	    	    }
            	    	    break;

            	    	default :
            	    	    break loop1;
            	        }
            	    } while (true);


            	    }
            	    break;

            	default :
            	    break loop2;
                }
            } while (true);


            EOF3=(Token)match(input,EOF,FOLLOW_EOF_in_statements81); 
            EOF3_tree = 
            (Object)adaptor.create(EOF3)
            ;
            adaptor.addChild(root_0, EOF3_tree);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "statements"


    public static class statement_return extends ParserRuleReturnScope {
        public Statement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "statement"
    // org/infinispan/cli/interpreter/IspnQL.g:110:1: statement returns [Statement stmt] : ( abortBatchStatement | beginTransactionStatement | cacheStatement | clearStatement | commitTransactionStatement | createStatement | encodingStatement | endBatchStatement | evictStatement | getStatement | infoStatement | locateStatement | pingStatement | putStatement | removeStatement | replaceStatement | rollbackTransactionStatement | siteStatement | startBatchStatement | statsStatement | upgradeStatement | versionStatement );
    public final IspnQLParser.statement_return statement() throws RecognitionException {
        IspnQLParser.statement_return retval = new IspnQLParser.statement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        IspnQLParser.abortBatchStatement_return abortBatchStatement4 =null;

        IspnQLParser.beginTransactionStatement_return beginTransactionStatement5 =null;

        IspnQLParser.cacheStatement_return cacheStatement6 =null;

        IspnQLParser.clearStatement_return clearStatement7 =null;

        IspnQLParser.commitTransactionStatement_return commitTransactionStatement8 =null;

        IspnQLParser.createStatement_return createStatement9 =null;

        IspnQLParser.encodingStatement_return encodingStatement10 =null;

        IspnQLParser.endBatchStatement_return endBatchStatement11 =null;

        IspnQLParser.evictStatement_return evictStatement12 =null;

        IspnQLParser.getStatement_return getStatement13 =null;

        IspnQLParser.infoStatement_return infoStatement14 =null;

        IspnQLParser.locateStatement_return locateStatement15 =null;

        IspnQLParser.pingStatement_return pingStatement16 =null;

        IspnQLParser.putStatement_return putStatement17 =null;

        IspnQLParser.removeStatement_return removeStatement18 =null;

        IspnQLParser.replaceStatement_return replaceStatement19 =null;

        IspnQLParser.rollbackTransactionStatement_return rollbackTransactionStatement20 =null;

        IspnQLParser.siteStatement_return siteStatement21 =null;

        IspnQLParser.startBatchStatement_return startBatchStatement22 =null;

        IspnQLParser.statsStatement_return statsStatement23 =null;

        IspnQLParser.upgradeStatement_return upgradeStatement24 =null;

        IspnQLParser.versionStatement_return versionStatement25 =null;



        try {
            // org/infinispan/cli/interpreter/IspnQL.g:111:4: ( abortBatchStatement | beginTransactionStatement | cacheStatement | clearStatement | commitTransactionStatement | createStatement | encodingStatement | endBatchStatement | evictStatement | getStatement | infoStatement | locateStatement | pingStatement | putStatement | removeStatement | replaceStatement | rollbackTransactionStatement | siteStatement | startBatchStatement | statsStatement | upgradeStatement | versionStatement )
            int alt3=22;
            switch ( input.LA(1) ) {
            case ABORT:
                {
                alt3=1;
                }
                break;
            case BEGIN:
                {
                alt3=2;
                }
                break;
            case CACHE:
                {
                alt3=3;
                }
                break;
            case CLEAR:
                {
                alt3=4;
                }
                break;
            case COMMIT:
                {
                alt3=5;
                }
                break;
            case CREATE:
                {
                alt3=6;
                }
                break;
            case ENCODING:
                {
                alt3=7;
                }
                break;
            case END:
                {
                alt3=8;
                }
                break;
            case EVICT:
                {
                alt3=9;
                }
                break;
            case GET:
                {
                alt3=10;
                }
                break;
            case INFO:
                {
                alt3=11;
                }
                break;
            case LOCATE:
                {
                alt3=12;
                }
                break;
            case PING:
                {
                alt3=13;
                }
                break;
            case PUT:
                {
                alt3=14;
                }
                break;
            case REMOVE:
                {
                alt3=15;
                }
                break;
            case REPLACE:
                {
                alt3=16;
                }
                break;
            case ROLLBACK:
                {
                alt3=17;
                }
                break;
            case SITE:
                {
                alt3=18;
                }
                break;
            case START:
                {
                alt3=19;
                }
                break;
            case STATS:
                {
                alt3=20;
                }
                break;
            case UPGRADE:
                {
                alt3=21;
                }
                break;
            case VERSION:
                {
                alt3=22;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 3, 0, input);

                throw nvae;

            }

            switch (alt3) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:111:6: abortBatchStatement
                    {
                    pushFollow(FOLLOW_abortBatchStatement_in_statement100);
                    abortBatchStatement4=abortBatchStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, abortBatchStatement4.getTree());

                     retval.stmt = (abortBatchStatement4!=null?abortBatchStatement4.stmt:null); 

                    }
                    break;
                case 2 :
                    // org/infinispan/cli/interpreter/IspnQL.g:112:6: beginTransactionStatement
                    {
                    pushFollow(FOLLOW_beginTransactionStatement_in_statement109);
                    beginTransactionStatement5=beginTransactionStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, beginTransactionStatement5.getTree());

                     retval.stmt = (beginTransactionStatement5!=null?beginTransactionStatement5.stmt:null); 

                    }
                    break;
                case 3 :
                    // org/infinispan/cli/interpreter/IspnQL.g:113:6: cacheStatement
                    {
                    pushFollow(FOLLOW_cacheStatement_in_statement118);
                    cacheStatement6=cacheStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, cacheStatement6.getTree());

                     retval.stmt = (cacheStatement6!=null?cacheStatement6.stmt:null); 

                    }
                    break;
                case 4 :
                    // org/infinispan/cli/interpreter/IspnQL.g:114:6: clearStatement
                    {
                    pushFollow(FOLLOW_clearStatement_in_statement127);
                    clearStatement7=clearStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, clearStatement7.getTree());

                     retval.stmt = (clearStatement7!=null?clearStatement7.stmt:null); 

                    }
                    break;
                case 5 :
                    // org/infinispan/cli/interpreter/IspnQL.g:115:6: commitTransactionStatement
                    {
                    pushFollow(FOLLOW_commitTransactionStatement_in_statement136);
                    commitTransactionStatement8=commitTransactionStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, commitTransactionStatement8.getTree());

                     retval.stmt = (commitTransactionStatement8!=null?commitTransactionStatement8.stmt:null); 

                    }
                    break;
                case 6 :
                    // org/infinispan/cli/interpreter/IspnQL.g:116:6: createStatement
                    {
                    pushFollow(FOLLOW_createStatement_in_statement145);
                    createStatement9=createStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, createStatement9.getTree());

                     retval.stmt = (createStatement9!=null?createStatement9.stmt:null); 

                    }
                    break;
                case 7 :
                    // org/infinispan/cli/interpreter/IspnQL.g:117:6: encodingStatement
                    {
                    pushFollow(FOLLOW_encodingStatement_in_statement154);
                    encodingStatement10=encodingStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, encodingStatement10.getTree());

                     retval.stmt = (encodingStatement10!=null?encodingStatement10.stmt:null); 

                    }
                    break;
                case 8 :
                    // org/infinispan/cli/interpreter/IspnQL.g:118:6: endBatchStatement
                    {
                    pushFollow(FOLLOW_endBatchStatement_in_statement163);
                    endBatchStatement11=endBatchStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, endBatchStatement11.getTree());

                     retval.stmt = (endBatchStatement11!=null?endBatchStatement11.stmt:null); 

                    }
                    break;
                case 9 :
                    // org/infinispan/cli/interpreter/IspnQL.g:119:6: evictStatement
                    {
                    pushFollow(FOLLOW_evictStatement_in_statement172);
                    evictStatement12=evictStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, evictStatement12.getTree());

                     retval.stmt = (evictStatement12!=null?evictStatement12.stmt:null); 

                    }
                    break;
                case 10 :
                    // org/infinispan/cli/interpreter/IspnQL.g:120:6: getStatement
                    {
                    pushFollow(FOLLOW_getStatement_in_statement181);
                    getStatement13=getStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, getStatement13.getTree());

                     retval.stmt = (getStatement13!=null?getStatement13.stmt:null); 

                    }
                    break;
                case 11 :
                    // org/infinispan/cli/interpreter/IspnQL.g:121:6: infoStatement
                    {
                    pushFollow(FOLLOW_infoStatement_in_statement190);
                    infoStatement14=infoStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, infoStatement14.getTree());

                     retval.stmt = (infoStatement14!=null?infoStatement14.stmt:null); 

                    }
                    break;
                case 12 :
                    // org/infinispan/cli/interpreter/IspnQL.g:122:6: locateStatement
                    {
                    pushFollow(FOLLOW_locateStatement_in_statement199);
                    locateStatement15=locateStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, locateStatement15.getTree());

                     retval.stmt = (locateStatement15!=null?locateStatement15.stmt:null); 

                    }
                    break;
                case 13 :
                    // org/infinispan/cli/interpreter/IspnQL.g:123:6: pingStatement
                    {
                    pushFollow(FOLLOW_pingStatement_in_statement208);
                    pingStatement16=pingStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, pingStatement16.getTree());

                     retval.stmt = (pingStatement16!=null?pingStatement16.stmt:null); 

                    }
                    break;
                case 14 :
                    // org/infinispan/cli/interpreter/IspnQL.g:124:6: putStatement
                    {
                    pushFollow(FOLLOW_putStatement_in_statement217);
                    putStatement17=putStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, putStatement17.getTree());

                     retval.stmt = (putStatement17!=null?putStatement17.stmt:null); 

                    }
                    break;
                case 15 :
                    // org/infinispan/cli/interpreter/IspnQL.g:125:6: removeStatement
                    {
                    pushFollow(FOLLOW_removeStatement_in_statement226);
                    removeStatement18=removeStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, removeStatement18.getTree());

                     retval.stmt = (removeStatement18!=null?removeStatement18.stmt:null); 

                    }
                    break;
                case 16 :
                    // org/infinispan/cli/interpreter/IspnQL.g:126:6: replaceStatement
                    {
                    pushFollow(FOLLOW_replaceStatement_in_statement235);
                    replaceStatement19=replaceStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, replaceStatement19.getTree());

                     retval.stmt = (replaceStatement19!=null?replaceStatement19.stmt:null); 

                    }
                    break;
                case 17 :
                    // org/infinispan/cli/interpreter/IspnQL.g:127:6: rollbackTransactionStatement
                    {
                    pushFollow(FOLLOW_rollbackTransactionStatement_in_statement244);
                    rollbackTransactionStatement20=rollbackTransactionStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, rollbackTransactionStatement20.getTree());

                     retval.stmt = (rollbackTransactionStatement20!=null?rollbackTransactionStatement20.stmt:null); 

                    }
                    break;
                case 18 :
                    // org/infinispan/cli/interpreter/IspnQL.g:128:6: siteStatement
                    {
                    pushFollow(FOLLOW_siteStatement_in_statement253);
                    siteStatement21=siteStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, siteStatement21.getTree());

                     retval.stmt = (siteStatement21!=null?siteStatement21.stmt:null); 

                    }
                    break;
                case 19 :
                    // org/infinispan/cli/interpreter/IspnQL.g:129:6: startBatchStatement
                    {
                    pushFollow(FOLLOW_startBatchStatement_in_statement262);
                    startBatchStatement22=startBatchStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, startBatchStatement22.getTree());

                     retval.stmt = (startBatchStatement22!=null?startBatchStatement22.stmt:null); 

                    }
                    break;
                case 20 :
                    // org/infinispan/cli/interpreter/IspnQL.g:130:6: statsStatement
                    {
                    pushFollow(FOLLOW_statsStatement_in_statement271);
                    statsStatement23=statsStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, statsStatement23.getTree());

                     retval.stmt = (statsStatement23!=null?statsStatement23.stmt:null); 

                    }
                    break;
                case 21 :
                    // org/infinispan/cli/interpreter/IspnQL.g:131:6: upgradeStatement
                    {
                    pushFollow(FOLLOW_upgradeStatement_in_statement280);
                    upgradeStatement24=upgradeStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, upgradeStatement24.getTree());

                     retval.stmt = (upgradeStatement24!=null?upgradeStatement24.stmt:null); 

                    }
                    break;
                case 22 :
                    // org/infinispan/cli/interpreter/IspnQL.g:132:6: versionStatement
                    {
                    pushFollow(FOLLOW_versionStatement_in_statement289);
                    versionStatement25=versionStatement();

                    state._fsp--;

                    adaptor.addChild(root_0, versionStatement25.getTree());

                     retval.stmt = (versionStatement25!=null?versionStatement25.stmt:null); 

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "statement"


    public static class abortBatchStatement_return extends ParserRuleReturnScope {
        public EndBatchStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "abortBatchStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:136:1: abortBatchStatement returns [EndBatchStatement stmt] : ABORT (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.abortBatchStatement_return abortBatchStatement() throws RecognitionException {
        IspnQLParser.abortBatchStatement_return retval = new IspnQLParser.abortBatchStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token ABORT26=null;
        Token set27=null;

        Object cacheName_tree=null;
        Object ABORT26_tree=null;
        Object set27_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:137:4: ( ABORT (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:137:6: ABORT (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            ABORT26=(Token)match(input,ABORT,FOLLOW_ABORT_in_abortBatchStatement311); 
            ABORT26_tree = 
            (Object)adaptor.create(ABORT26)
            ;
            adaptor.addChild(root_0, ABORT26_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:137:12: (cacheName= STRINGLITERAL )?
            int alt4=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt4=1;
                    }
                    break;
            }

            switch (alt4) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:137:13: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_abortBatchStatement318); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set27=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==70 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new EndBatchStatement(unquote((cacheName!=null?cacheName.getText():null)), false); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "abortBatchStatement"


    public static class beginTransactionStatement_return extends ParserRuleReturnScope {
        public BeginTransactionStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "beginTransactionStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:140:1: beginTransactionStatement returns [BeginTransactionStatement stmt] : BEGIN (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.beginTransactionStatement_return beginTransactionStatement() throws RecognitionException {
        IspnQLParser.beginTransactionStatement_return retval = new IspnQLParser.beginTransactionStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token BEGIN28=null;
        Token set29=null;

        Object cacheName_tree=null;
        Object BEGIN28_tree=null;
        Object set29_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:141:4: ( BEGIN (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:141:6: BEGIN (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            BEGIN28=(Token)match(input,BEGIN,FOLLOW_BEGIN_in_beginTransactionStatement350); 
            BEGIN28_tree = 
            (Object)adaptor.create(BEGIN28)
            ;
            adaptor.addChild(root_0, BEGIN28_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:141:12: (cacheName= STRINGLITERAL )?
            int alt5=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt5=1;
                    }
                    break;
            }

            switch (alt5) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:141:13: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_beginTransactionStatement357); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set29=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==70 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new BeginTransactionStatement(unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "beginTransactionStatement"


    public static class cacheStatement_return extends ParserRuleReturnScope {
        public CacheStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "cacheStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:144:1: cacheStatement returns [CacheStatement stmt] : CACHE (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.cacheStatement_return cacheStatement() throws RecognitionException {
        IspnQLParser.cacheStatement_return retval = new IspnQLParser.cacheStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token CACHE30=null;
        Token set31=null;

        Object cacheName_tree=null;
        Object CACHE30_tree=null;
        Object set31_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:145:4: ( CACHE (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:145:6: CACHE (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            CACHE30=(Token)match(input,CACHE,FOLLOW_CACHE_in_cacheStatement389); 
            CACHE30_tree = 
            (Object)adaptor.create(CACHE30)
            ;
            adaptor.addChild(root_0, CACHE30_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:145:12: (cacheName= STRINGLITERAL )?
            int alt6=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt6=1;
                    }
                    break;
            }

            switch (alt6) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:145:13: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_cacheStatement396); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set31=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==70 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new CacheStatement(unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "cacheStatement"


    public static class clearStatement_return extends ParserRuleReturnScope {
        public ClearStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "clearStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:148:1: clearStatement returns [ClearStatement stmt] : CLEAR (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.clearStatement_return clearStatement() throws RecognitionException {
        IspnQLParser.clearStatement_return retval = new IspnQLParser.clearStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token CLEAR32=null;
        Token set33=null;

        Object cacheName_tree=null;
        Object CLEAR32_tree=null;
        Object set33_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:149:4: ( CLEAR (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:149:6: CLEAR (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            CLEAR32=(Token)match(input,CLEAR,FOLLOW_CLEAR_in_clearStatement428); 
            CLEAR32_tree = 
            (Object)adaptor.create(CLEAR32)
            ;
            adaptor.addChild(root_0, CLEAR32_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:149:12: (cacheName= STRINGLITERAL )?
            int alt7=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt7=1;
                    }
                    break;
            }

            switch (alt7) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:149:13: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_clearStatement435); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set33=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==70 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new ClearStatement(unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "clearStatement"


    public static class commitTransactionStatement_return extends ParserRuleReturnScope {
        public CommitTransactionStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "commitTransactionStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:152:1: commitTransactionStatement returns [CommitTransactionStatement stmt] : COMMIT (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.commitTransactionStatement_return commitTransactionStatement() throws RecognitionException {
        IspnQLParser.commitTransactionStatement_return retval = new IspnQLParser.commitTransactionStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token COMMIT34=null;
        Token set35=null;

        Object cacheName_tree=null;
        Object COMMIT34_tree=null;
        Object set35_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:153:4: ( COMMIT (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:153:6: COMMIT (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            COMMIT34=(Token)match(input,COMMIT,FOLLOW_COMMIT_in_commitTransactionStatement467); 
            COMMIT34_tree = 
            (Object)adaptor.create(COMMIT34)
            ;
            adaptor.addChild(root_0, COMMIT34_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:153:13: (cacheName= STRINGLITERAL )?
            int alt8=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt8=1;
                    }
                    break;
            }

            switch (alt8) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:153:14: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_commitTransactionStatement474); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set35=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==70 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new CommitTransactionStatement(unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "commitTransactionStatement"


    public static class createStatement_return extends ParserRuleReturnScope {
        public CreateStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "createStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:156:1: createStatement returns [CreateStatement stmt] : CREATE cacheName= STRINGLITERAL ( LIKE baseCacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.createStatement_return createStatement() throws RecognitionException {
        IspnQLParser.createStatement_return retval = new IspnQLParser.createStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token baseCacheName=null;
        Token CREATE36=null;
        Token LIKE37=null;
        Token set38=null;

        Object cacheName_tree=null;
        Object baseCacheName_tree=null;
        Object CREATE36_tree=null;
        Object LIKE37_tree=null;
        Object set38_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:157:4: ( CREATE cacheName= STRINGLITERAL ( LIKE baseCacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:157:6: CREATE cacheName= STRINGLITERAL ( LIKE baseCacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            CREATE36=(Token)match(input,CREATE,FOLLOW_CREATE_in_createStatement506); 
            CREATE36_tree = 
            (Object)adaptor.create(CREATE36)
            ;
            adaptor.addChild(root_0, CREATE36_tree);


            cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_createStatement512); 
            cacheName_tree = 
            (Object)adaptor.create(cacheName)
            ;
            adaptor.addChild(root_0, cacheName_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:157:39: ( LIKE baseCacheName= STRINGLITERAL )?
            int alt9=2;
            switch ( input.LA(1) ) {
                case LIKE:
                    {
                    alt9=1;
                    }
                    break;
            }

            switch (alt9) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:157:40: LIKE baseCacheName= STRINGLITERAL
                    {
                    LIKE37=(Token)match(input,LIKE,FOLLOW_LIKE_in_createStatement515); 
                    LIKE37_tree = 
                    (Object)adaptor.create(LIKE37)
                    ;
                    adaptor.addChild(root_0, LIKE37_tree);


                    baseCacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_createStatement521); 
                    baseCacheName_tree = 
                    (Object)adaptor.create(baseCacheName)
                    ;
                    adaptor.addChild(root_0, baseCacheName_tree);


                    }
                    break;

            }


            set38=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==70 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new CreateStatement(unquote((cacheName!=null?cacheName.getText():null)), unquote((baseCacheName!=null?baseCacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "createStatement"


    public static class encodingStatement_return extends ParserRuleReturnScope {
        public EncodingStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "encodingStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:160:1: encodingStatement returns [EncodingStatement stmt] : ENCODING opts= statementOptions (codecName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.encodingStatement_return encodingStatement() throws RecognitionException {
        IspnQLParser.encodingStatement_return retval = new IspnQLParser.encodingStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token codecName=null;
        Token ENCODING39=null;
        Token set40=null;
        IspnQLParser.statementOptions_return opts =null;


        Object codecName_tree=null;
        Object ENCODING39_tree=null;
        Object set40_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:161:4: ( ENCODING opts= statementOptions (codecName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:161:6: ENCODING opts= statementOptions (codecName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            ENCODING39=(Token)match(input,ENCODING,FOLLOW_ENCODING_in_encodingStatement553); 
            ENCODING39_tree = 
            (Object)adaptor.create(ENCODING39)
            ;
            adaptor.addChild(root_0, ENCODING39_tree);


            pushFollow(FOLLOW_statementOptions_in_encodingStatement559);
            opts=statementOptions();

            state._fsp--;

            adaptor.addChild(root_0, opts.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:161:39: (codecName= STRINGLITERAL )?
            int alt10=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt10=1;
                    }
                    break;
            }

            switch (alt10) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:161:40: codecName= STRINGLITERAL
                    {
                    codecName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_encodingStatement566); 
                    codecName_tree = 
                    (Object)adaptor.create(codecName)
                    ;
                    adaptor.addChild(root_0, codecName_tree);


                    }
                    break;

            }


            set40=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==70 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new EncodingStatement((opts!=null?opts.options:null), unquote((codecName!=null?codecName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "encodingStatement"


    public static class endBatchStatement_return extends ParserRuleReturnScope {
        public EndBatchStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "endBatchStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:164:1: endBatchStatement returns [EndBatchStatement stmt] : END (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.endBatchStatement_return endBatchStatement() throws RecognitionException {
        IspnQLParser.endBatchStatement_return retval = new IspnQLParser.endBatchStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token END41=null;
        Token set42=null;

        Object cacheName_tree=null;
        Object END41_tree=null;
        Object set42_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:165:4: ( END (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:165:6: END (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            END41=(Token)match(input,END,FOLLOW_END_in_endBatchStatement598); 
            END41_tree = 
            (Object)adaptor.create(END41)
            ;
            adaptor.addChild(root_0, END41_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:165:10: (cacheName= STRINGLITERAL )?
            int alt11=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt11=1;
                    }
                    break;
            }

            switch (alt11) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:165:11: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_endBatchStatement605); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set42=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==70 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new EndBatchStatement(unquote((cacheName!=null?cacheName.getText():null)), true); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "endBatchStatement"


    public static class evictStatement_return extends ParserRuleReturnScope {
        public EvictStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "evictStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:168:1: evictStatement returns [EvictStatement stmt] : EVICT key= keyIdentifier ( EOL | ';' ) !;
    public final IspnQLParser.evictStatement_return evictStatement() throws RecognitionException {
        IspnQLParser.evictStatement_return retval = new IspnQLParser.evictStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token EVICT43=null;
        Token set44=null;
        IspnQLParser.keyIdentifier_return key =null;


        Object EVICT43_tree=null;
        Object set44_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:169:4: ( EVICT key= keyIdentifier ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:169:6: EVICT key= keyIdentifier ( EOL | ';' ) !
            {
            EVICT43=(Token)match(input,EVICT,FOLLOW_EVICT_in_evictStatement637); 
            EVICT43_tree = 
            (Object)adaptor.create(EVICT43)
            ;
            adaptor.addChild(root_0, EVICT43_tree);


            pushFollow(FOLLOW_keyIdentifier_in_evictStatement643);
            key=keyIdentifier();

            state._fsp--;

            adaptor.addChild(root_0, key.getTree());

            set44=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==70 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new EvictStatement((key!=null?key.key:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "evictStatement"


    public static class getStatement_return extends ParserRuleReturnScope {
        public GetStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "getStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:172:1: getStatement returns [GetStatement stmt] : GET opts= statementOptions key= keyIdentifier ( EOL | ';' ) !;
    public final IspnQLParser.getStatement_return getStatement() throws RecognitionException {
        IspnQLParser.getStatement_return retval = new IspnQLParser.getStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token GET45=null;
        Token set46=null;
        IspnQLParser.statementOptions_return opts =null;

        IspnQLParser.keyIdentifier_return key =null;


        Object GET45_tree=null;
        Object set46_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:173:4: ( GET opts= statementOptions key= keyIdentifier ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:173:6: GET opts= statementOptions key= keyIdentifier ( EOL | ';' ) !
            {
            GET45=(Token)match(input,GET,FOLLOW_GET_in_getStatement673); 
            GET45_tree = 
            (Object)adaptor.create(GET45)
            ;
            adaptor.addChild(root_0, GET45_tree);


            pushFollow(FOLLOW_statementOptions_in_getStatement679);
            opts=statementOptions();

            state._fsp--;

            adaptor.addChild(root_0, opts.getTree());

            pushFollow(FOLLOW_keyIdentifier_in_getStatement685);
            key=keyIdentifier();

            state._fsp--;

            adaptor.addChild(root_0, key.getTree());

            set46=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==70 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new GetStatement((opts!=null?opts.options:null), (key!=null?key.key:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "getStatement"


    public static class infoStatement_return extends ParserRuleReturnScope {
        public InfoStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "infoStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:176:1: infoStatement returns [InfoStatement stmt] : INFO (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.infoStatement_return infoStatement() throws RecognitionException {
        IspnQLParser.infoStatement_return retval = new IspnQLParser.infoStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token INFO47=null;
        Token set48=null;

        Object cacheName_tree=null;
        Object INFO47_tree=null;
        Object set48_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:177:4: ( INFO (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:177:6: INFO (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            INFO47=(Token)match(input,INFO,FOLLOW_INFO_in_infoStatement715); 
            INFO47_tree = 
            (Object)adaptor.create(INFO47)
            ;
            adaptor.addChild(root_0, INFO47_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:177:11: (cacheName= STRINGLITERAL )?
            int alt12=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt12=1;
                    }
                    break;
            }

            switch (alt12) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:177:12: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_infoStatement722); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set48=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==70 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new InfoStatement(unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "infoStatement"


    public static class locateStatement_return extends ParserRuleReturnScope {
        public LocateStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "locateStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:180:1: locateStatement returns [LocateStatement stmt] : LOCATE opts= statementOptions key= keyIdentifier ( EOL | ';' ) !;
    public final IspnQLParser.locateStatement_return locateStatement() throws RecognitionException {
        IspnQLParser.locateStatement_return retval = new IspnQLParser.locateStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token LOCATE49=null;
        Token set50=null;
        IspnQLParser.statementOptions_return opts =null;

        IspnQLParser.keyIdentifier_return key =null;


        Object LOCATE49_tree=null;
        Object set50_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:181:4: ( LOCATE opts= statementOptions key= keyIdentifier ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:181:6: LOCATE opts= statementOptions key= keyIdentifier ( EOL | ';' ) !
            {
            LOCATE49=(Token)match(input,LOCATE,FOLLOW_LOCATE_in_locateStatement754); 
            LOCATE49_tree = 
            (Object)adaptor.create(LOCATE49)
            ;
            adaptor.addChild(root_0, LOCATE49_tree);


            pushFollow(FOLLOW_statementOptions_in_locateStatement760);
            opts=statementOptions();

            state._fsp--;

            adaptor.addChild(root_0, opts.getTree());

            pushFollow(FOLLOW_keyIdentifier_in_locateStatement766);
            key=keyIdentifier();

            state._fsp--;

            adaptor.addChild(root_0, key.getTree());

            set50=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==70 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new LocateStatement((opts!=null?opts.options:null), (key!=null?key.key:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "locateStatement"


    public static class pingStatement_return extends ParserRuleReturnScope {
        public PingStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "pingStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:184:1: pingStatement returns [PingStatement stmt] : PING ( EOL | ';' ) !;
    public final IspnQLParser.pingStatement_return pingStatement() throws RecognitionException {
        IspnQLParser.pingStatement_return retval = new IspnQLParser.pingStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token PING51=null;
        Token set52=null;

        Object PING51_tree=null;
        Object set52_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:185:4: ( PING ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:185:6: PING ( EOL | ';' ) !
            {
            PING51=(Token)match(input,PING,FOLLOW_PING_in_pingStatement796); 
            PING51_tree = 
            (Object)adaptor.create(PING51)
            ;
            adaptor.addChild(root_0, PING51_tree);


            set52=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==70 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new PingStatement(); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "pingStatement"


    public static class putStatement_return extends ParserRuleReturnScope {
        public PutStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "putStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:188:1: putStatement returns [PutStatement stmt] : PUT opts= statementOptions key= keyIdentifier value= literal (exp= expirationClause )? ( EOL | ';' ) !;
    public final IspnQLParser.putStatement_return putStatement() throws RecognitionException {
        IspnQLParser.putStatement_return retval = new IspnQLParser.putStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token PUT53=null;
        Token set54=null;
        IspnQLParser.statementOptions_return opts =null;

        IspnQLParser.keyIdentifier_return key =null;

        IspnQLParser.literal_return value =null;

        IspnQLParser.expirationClause_return exp =null;


        Object PUT53_tree=null;
        Object set54_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:189:4: ( PUT opts= statementOptions key= keyIdentifier value= literal (exp= expirationClause )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:189:6: PUT opts= statementOptions key= keyIdentifier value= literal (exp= expirationClause )? ( EOL | ';' ) !
            {
            PUT53=(Token)match(input,PUT,FOLLOW_PUT_in_putStatement826); 
            PUT53_tree = 
            (Object)adaptor.create(PUT53)
            ;
            adaptor.addChild(root_0, PUT53_tree);


            pushFollow(FOLLOW_statementOptions_in_putStatement832);
            opts=statementOptions();

            state._fsp--;

            adaptor.addChild(root_0, opts.getTree());

            pushFollow(FOLLOW_keyIdentifier_in_putStatement838);
            key=keyIdentifier();

            state._fsp--;

            adaptor.addChild(root_0, key.getTree());

            pushFollow(FOLLOW_literal_in_putStatement844);
            value=literal();

            state._fsp--;

            adaptor.addChild(root_0, value.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:189:70: (exp= expirationClause )?
            int alt13=2;
            switch ( input.LA(1) ) {
                case EXPIRES:
                    {
                    alt13=1;
                    }
                    break;
            }

            switch (alt13) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:189:71: exp= expirationClause
                    {
                    pushFollow(FOLLOW_expirationClause_in_putStatement851);
                    exp=expirationClause();

                    state._fsp--;

                    adaptor.addChild(root_0, exp.getTree());

                    }
                    break;

            }


            set54=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==70 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new PutStatement((opts!=null?opts.options:null), (key!=null?key.key:null), (value!=null?value.o:null), (exp!=null?exp.exp:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "putStatement"


    public static class removeStatement_return extends ParserRuleReturnScope {
        public RemoveStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "removeStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:192:1: removeStatement returns [RemoveStatement stmt] : REMOVE key= keyIdentifier (value= literal )? ( EOL | ';' ) !;
    public final IspnQLParser.removeStatement_return removeStatement() throws RecognitionException {
        IspnQLParser.removeStatement_return retval = new IspnQLParser.removeStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token REMOVE55=null;
        Token set56=null;
        IspnQLParser.keyIdentifier_return key =null;

        IspnQLParser.literal_return value =null;


        Object REMOVE55_tree=null;
        Object set56_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:193:4: ( REMOVE key= keyIdentifier (value= literal )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:193:6: REMOVE key= keyIdentifier (value= literal )? ( EOL | ';' ) !
            {
            REMOVE55=(Token)match(input,REMOVE,FOLLOW_REMOVE_in_removeStatement883); 
            REMOVE55_tree = 
            (Object)adaptor.create(REMOVE55)
            ;
            adaptor.addChild(root_0, REMOVE55_tree);


            pushFollow(FOLLOW_keyIdentifier_in_removeStatement889);
            key=keyIdentifier();

            state._fsp--;

            adaptor.addChild(root_0, key.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:193:33: (value= literal )?
            int alt14=2;
            switch ( input.LA(1) ) {
                case DOUBLELITERAL:
                case FALSE:
                case FLOATLITERAL:
                case INTLITERAL:
                case LONGLITERAL:
                case NULL:
                case STRINGLITERAL:
                case TRUE:
                case UUIDLITERAL:
                case 74:
                    {
                    alt14=1;
                    }
                    break;
            }

            switch (alt14) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:193:34: value= literal
                    {
                    pushFollow(FOLLOW_literal_in_removeStatement896);
                    value=literal();

                    state._fsp--;

                    adaptor.addChild(root_0, value.getTree());

                    }
                    break;

            }


            set56=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==70 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new RemoveStatement((key!=null?key.key:null), (value!=null?value.o:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "removeStatement"


    public static class replaceStatement_return extends ParserRuleReturnScope {
        public ReplaceStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "replaceStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:196:1: replaceStatement returns [ReplaceStatement stmt] : REPLACE opts= statementOptions key= keyIdentifier value1= literal (value2= literal )? (exp= expirationClause )? ( EOL | ';' ) !;
    public final IspnQLParser.replaceStatement_return replaceStatement() throws RecognitionException {
        IspnQLParser.replaceStatement_return retval = new IspnQLParser.replaceStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token REPLACE57=null;
        Token set58=null;
        IspnQLParser.statementOptions_return opts =null;

        IspnQLParser.keyIdentifier_return key =null;

        IspnQLParser.literal_return value1 =null;

        IspnQLParser.literal_return value2 =null;

        IspnQLParser.expirationClause_return exp =null;


        Object REPLACE57_tree=null;
        Object set58_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:197:4: ( REPLACE opts= statementOptions key= keyIdentifier value1= literal (value2= literal )? (exp= expirationClause )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:197:6: REPLACE opts= statementOptions key= keyIdentifier value1= literal (value2= literal )? (exp= expirationClause )? ( EOL | ';' ) !
            {
            REPLACE57=(Token)match(input,REPLACE,FOLLOW_REPLACE_in_replaceStatement928); 
            REPLACE57_tree = 
            (Object)adaptor.create(REPLACE57)
            ;
            adaptor.addChild(root_0, REPLACE57_tree);


            pushFollow(FOLLOW_statementOptions_in_replaceStatement934);
            opts=statementOptions();

            state._fsp--;

            adaptor.addChild(root_0, opts.getTree());

            pushFollow(FOLLOW_keyIdentifier_in_replaceStatement940);
            key=keyIdentifier();

            state._fsp--;

            adaptor.addChild(root_0, key.getTree());

            pushFollow(FOLLOW_literal_in_replaceStatement946);
            value1=literal();

            state._fsp--;

            adaptor.addChild(root_0, value1.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:197:75: (value2= literal )?
            int alt15=2;
            switch ( input.LA(1) ) {
                case DOUBLELITERAL:
                case FALSE:
                case FLOATLITERAL:
                case INTLITERAL:
                case LONGLITERAL:
                case NULL:
                case STRINGLITERAL:
                case TRUE:
                case UUIDLITERAL:
                case 74:
                    {
                    alt15=1;
                    }
                    break;
            }

            switch (alt15) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:197:76: value2= literal
                    {
                    pushFollow(FOLLOW_literal_in_replaceStatement953);
                    value2=literal();

                    state._fsp--;

                    adaptor.addChild(root_0, value2.getTree());

                    }
                    break;

            }


            // org/infinispan/cli/interpreter/IspnQL.g:197:95: (exp= expirationClause )?
            int alt16=2;
            switch ( input.LA(1) ) {
                case EXPIRES:
                    {
                    alt16=1;
                    }
                    break;
            }

            switch (alt16) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:197:96: exp= expirationClause
                    {
                    pushFollow(FOLLOW_expirationClause_in_replaceStatement962);
                    exp=expirationClause();

                    state._fsp--;

                    adaptor.addChild(root_0, exp.getTree());

                    }
                    break;

            }


            set58=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==70 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             if ((value2!=null?value2.o:null)==null) retval.stmt = new ReplaceStatement((opts!=null?opts.options:null), (key!=null?key.key:null), (value1!=null?value1.o:null), (exp!=null?exp.exp:null)); else retval.stmt = new ReplaceStatement((opts!=null?opts.options:null), (key!=null?key.key:null), (value1!=null?value1.o:null), (value2!=null?value2.o:null), (exp!=null?exp.exp:null));

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "replaceStatement"


    public static class rollbackTransactionStatement_return extends ParserRuleReturnScope {
        public RollbackTransactionStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "rollbackTransactionStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:200:1: rollbackTransactionStatement returns [RollbackTransactionStatement stmt] : ROLLBACK (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.rollbackTransactionStatement_return rollbackTransactionStatement() throws RecognitionException {
        IspnQLParser.rollbackTransactionStatement_return retval = new IspnQLParser.rollbackTransactionStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token ROLLBACK59=null;
        Token set60=null;

        Object cacheName_tree=null;
        Object ROLLBACK59_tree=null;
        Object set60_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:201:4: ( ROLLBACK (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:201:6: ROLLBACK (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            ROLLBACK59=(Token)match(input,ROLLBACK,FOLLOW_ROLLBACK_in_rollbackTransactionStatement994); 
            ROLLBACK59_tree = 
            (Object)adaptor.create(ROLLBACK59)
            ;
            adaptor.addChild(root_0, ROLLBACK59_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:201:15: (cacheName= STRINGLITERAL )?
            int alt17=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt17=1;
                    }
                    break;
            }

            switch (alt17) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:201:16: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_rollbackTransactionStatement1001); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set60=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==70 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new RollbackTransactionStatement(unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "rollbackTransactionStatement"


    public static class siteStatement_return extends ParserRuleReturnScope {
        public SiteStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "siteStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:204:1: siteStatement returns [SiteStatement stmt] : SITE opts= statementOptions (site= siteIdentifier )? ( EOL | ';' ) !;
    public final IspnQLParser.siteStatement_return siteStatement() throws RecognitionException {
        IspnQLParser.siteStatement_return retval = new IspnQLParser.siteStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token SITE61=null;
        Token set62=null;
        IspnQLParser.statementOptions_return opts =null;

        IspnQLParser.siteIdentifier_return site =null;


        Object SITE61_tree=null;
        Object set62_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:205:4: ( SITE opts= statementOptions (site= siteIdentifier )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:205:6: SITE opts= statementOptions (site= siteIdentifier )? ( EOL | ';' ) !
            {
            SITE61=(Token)match(input,SITE,FOLLOW_SITE_in_siteStatement1036); 
            SITE61_tree = 
            (Object)adaptor.create(SITE61)
            ;
            adaptor.addChild(root_0, SITE61_tree);


            pushFollow(FOLLOW_statementOptions_in_siteStatement1042);
            opts=statementOptions();

            state._fsp--;

            adaptor.addChild(root_0, opts.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:205:35: (site= siteIdentifier )?
            int alt18=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt18=1;
                    }
                    break;
            }

            switch (alt18) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:205:36: site= siteIdentifier
                    {
                    pushFollow(FOLLOW_siteIdentifier_in_siteStatement1049);
                    site=siteIdentifier();

                    state._fsp--;

                    adaptor.addChild(root_0, site.getTree());

                    }
                    break;

            }


            set62=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==70 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new SiteStatement((opts!=null?opts.options:null), (site!=null?site.site:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "siteStatement"


    public static class startBatchStatement_return extends ParserRuleReturnScope {
        public StartBatchStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "startBatchStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:208:1: startBatchStatement returns [StartBatchStatement stmt] : START (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.startBatchStatement_return startBatchStatement() throws RecognitionException {
        IspnQLParser.startBatchStatement_return retval = new IspnQLParser.startBatchStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token START63=null;
        Token set64=null;

        Object cacheName_tree=null;
        Object START63_tree=null;
        Object set64_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:209:4: ( START (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:209:6: START (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            START63=(Token)match(input,START,FOLLOW_START_in_startBatchStatement1081); 
            START63_tree = 
            (Object)adaptor.create(START63)
            ;
            adaptor.addChild(root_0, START63_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:209:12: (cacheName= STRINGLITERAL )?
            int alt19=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt19=1;
                    }
                    break;
            }

            switch (alt19) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:209:13: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_startBatchStatement1088); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set64=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==70 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new StartBatchStatement(unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "startBatchStatement"


    public static class statsStatement_return extends ParserRuleReturnScope {
        public StatsStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "statsStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:212:1: statsStatement returns [StatsStatement stmt] : STATS opts= statementOptions (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.statsStatement_return statsStatement() throws RecognitionException {
        IspnQLParser.statsStatement_return retval = new IspnQLParser.statsStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token STATS65=null;
        Token set66=null;
        IspnQLParser.statementOptions_return opts =null;


        Object cacheName_tree=null;
        Object STATS65_tree=null;
        Object set66_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:213:4: ( STATS opts= statementOptions (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:213:6: STATS opts= statementOptions (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            STATS65=(Token)match(input,STATS,FOLLOW_STATS_in_statsStatement1120); 
            STATS65_tree = 
            (Object)adaptor.create(STATS65)
            ;
            adaptor.addChild(root_0, STATS65_tree);


            pushFollow(FOLLOW_statementOptions_in_statsStatement1126);
            opts=statementOptions();

            state._fsp--;

            adaptor.addChild(root_0, opts.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:213:36: (cacheName= STRINGLITERAL )?
            int alt20=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt20=1;
                    }
                    break;
            }

            switch (alt20) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:213:37: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_statsStatement1133); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set66=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==70 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new StatsStatement((opts!=null?opts.options:null), unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "statsStatement"


    public static class upgradeStatement_return extends ParserRuleReturnScope {
        public UpgradeStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "upgradeStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:216:1: upgradeStatement returns [UpgradeStatement stmt] : UPGRADE opts= statementOptions (cacheName= STRINGLITERAL )? ( EOL | ';' ) !;
    public final IspnQLParser.upgradeStatement_return upgradeStatement() throws RecognitionException {
        IspnQLParser.upgradeStatement_return retval = new IspnQLParser.upgradeStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token UPGRADE67=null;
        Token set68=null;
        IspnQLParser.statementOptions_return opts =null;


        Object cacheName_tree=null;
        Object UPGRADE67_tree=null;
        Object set68_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:217:4: ( UPGRADE opts= statementOptions (cacheName= STRINGLITERAL )? ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:217:6: UPGRADE opts= statementOptions (cacheName= STRINGLITERAL )? ( EOL | ';' ) !
            {
            UPGRADE67=(Token)match(input,UPGRADE,FOLLOW_UPGRADE_in_upgradeStatement1165); 
            UPGRADE67_tree = 
            (Object)adaptor.create(UPGRADE67)
            ;
            adaptor.addChild(root_0, UPGRADE67_tree);


            pushFollow(FOLLOW_statementOptions_in_upgradeStatement1171);
            opts=statementOptions();

            state._fsp--;

            adaptor.addChild(root_0, opts.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:217:38: (cacheName= STRINGLITERAL )?
            int alt21=2;
            switch ( input.LA(1) ) {
                case STRINGLITERAL:
                    {
                    alt21=1;
                    }
                    break;
            }

            switch (alt21) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:217:39: cacheName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_upgradeStatement1178); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    }
                    break;

            }


            set68=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==70 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new UpgradeStatement((opts!=null?opts.options:null), unquote((cacheName!=null?cacheName.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "upgradeStatement"


    public static class versionStatement_return extends ParserRuleReturnScope {
        public VersionStatement stmt;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "versionStatement"
    // org/infinispan/cli/interpreter/IspnQL.g:220:1: versionStatement returns [VersionStatement stmt] : VERSION ( EOL | ';' ) !;
    public final IspnQLParser.versionStatement_return versionStatement() throws RecognitionException {
        IspnQLParser.versionStatement_return retval = new IspnQLParser.versionStatement_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token VERSION69=null;
        Token set70=null;

        Object VERSION69_tree=null;
        Object set70_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:221:4: ( VERSION ( EOL | ';' ) !)
            // org/infinispan/cli/interpreter/IspnQL.g:221:6: VERSION ( EOL | ';' ) !
            {
            VERSION69=(Token)match(input,VERSION,FOLLOW_VERSION_in_versionStatement1210); 
            VERSION69_tree = 
            (Object)adaptor.create(VERSION69)
            ;
            adaptor.addChild(root_0, VERSION69_tree);


            set70=(Token)input.LT(1);

            if ( input.LA(1)==EOL||input.LA(1)==70 ) {
                input.consume();
                state.errorRecovery=false;
            }
            else {
                MismatchedSetException mse = new MismatchedSetException(null,input);
                throw mse;
            }


             retval.stmt = new VersionStatement(); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "versionStatement"


    public static class expirationClause_return extends ParserRuleReturnScope {
        public ExpirationData exp;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "expirationClause"
    // org/infinispan/cli/interpreter/IspnQL.g:224:1: expirationClause returns [ExpirationData exp] : EXPIRES expires= timeLiteral ( MAXIDLE idle= timeLiteral )? ;
    public final IspnQLParser.expirationClause_return expirationClause() throws RecognitionException {
        IspnQLParser.expirationClause_return retval = new IspnQLParser.expirationClause_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token EXPIRES71=null;
        Token MAXIDLE72=null;
        IspnQLParser.timeLiteral_return expires =null;

        IspnQLParser.timeLiteral_return idle =null;


        Object EXPIRES71_tree=null;
        Object MAXIDLE72_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:225:4: ( EXPIRES expires= timeLiteral ( MAXIDLE idle= timeLiteral )? )
            // org/infinispan/cli/interpreter/IspnQL.g:225:6: EXPIRES expires= timeLiteral ( MAXIDLE idle= timeLiteral )?
            {
            EXPIRES71=(Token)match(input,EXPIRES,FOLLOW_EXPIRES_in_expirationClause1240); 
            EXPIRES71_tree = 
            (Object)adaptor.create(EXPIRES71)
            ;
            adaptor.addChild(root_0, EXPIRES71_tree);


            pushFollow(FOLLOW_timeLiteral_in_expirationClause1246);
            expires=timeLiteral();

            state._fsp--;

            adaptor.addChild(root_0, expires.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:225:36: ( MAXIDLE idle= timeLiteral )?
            int alt22=2;
            switch ( input.LA(1) ) {
                case MAXIDLE:
                    {
                    alt22=1;
                    }
                    break;
            }

            switch (alt22) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:225:37: MAXIDLE idle= timeLiteral
                    {
                    MAXIDLE72=(Token)match(input,MAXIDLE,FOLLOW_MAXIDLE_in_expirationClause1249); 
                    MAXIDLE72_tree = 
                    (Object)adaptor.create(MAXIDLE72)
                    ;
                    adaptor.addChild(root_0, MAXIDLE72_tree);


                    pushFollow(FOLLOW_timeLiteral_in_expirationClause1255);
                    idle=timeLiteral();

                    state._fsp--;

                    adaptor.addChild(root_0, idle.getTree());

                    }
                    break;

            }


             retval.exp = new ExpirationData((expires!=null?expires.l:null), (idle!=null?idle.l:null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "expirationClause"


    public static class keyIdentifier_return extends ParserRuleReturnScope {
        public KeyData key;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "keyIdentifier"
    // org/infinispan/cli/interpreter/IspnQL.g:228:1: keyIdentifier returns [KeyData key] : ( STRINGLITERAL '.' literal | literal );
    public final IspnQLParser.keyIdentifier_return keyIdentifier() throws RecognitionException {
        IspnQLParser.keyIdentifier_return retval = new IspnQLParser.keyIdentifier_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token STRINGLITERAL73=null;
        Token char_literal74=null;
        IspnQLParser.literal_return literal75 =null;

        IspnQLParser.literal_return literal76 =null;


        Object STRINGLITERAL73_tree=null;
        Object char_literal74_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:229:4: ( STRINGLITERAL '.' literal | literal )
            int alt23=2;
            switch ( input.LA(1) ) {
            case STRINGLITERAL:
                {
                switch ( input.LA(2) ) {
                case 68:
                    {
                    alt23=1;
                    }
                    break;
                case DOUBLELITERAL:
                case EOL:
                case FALSE:
                case FLOATLITERAL:
                case INTLITERAL:
                case LONGLITERAL:
                case NULL:
                case STRINGLITERAL:
                case TRUE:
                case UUIDLITERAL:
                case 70:
                case 74:
                    {
                    alt23=2;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 23, 1, input);

                    throw nvae;

                }

                }
                break;
            case DOUBLELITERAL:
            case FALSE:
            case FLOATLITERAL:
            case INTLITERAL:
            case LONGLITERAL:
            case NULL:
            case TRUE:
            case UUIDLITERAL:
            case 74:
                {
                alt23=2;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 23, 0, input);

                throw nvae;

            }

            switch (alt23) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:229:6: STRINGLITERAL '.' literal
                    {
                    STRINGLITERAL73=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_keyIdentifier1278); 
                    STRINGLITERAL73_tree = 
                    (Object)adaptor.create(STRINGLITERAL73)
                    ;
                    adaptor.addChild(root_0, STRINGLITERAL73_tree);


                    char_literal74=(Token)match(input,68,FOLLOW_68_in_keyIdentifier1280); 
                    char_literal74_tree = 
                    (Object)adaptor.create(char_literal74)
                    ;
                    adaptor.addChild(root_0, char_literal74_tree);


                    pushFollow(FOLLOW_literal_in_keyIdentifier1282);
                    literal75=literal();

                    state._fsp--;

                    adaptor.addChild(root_0, literal75.getTree());

                     retval.key = new KeyData(unquote((STRINGLITERAL73!=null?STRINGLITERAL73.getText():null)), (literal75!=null?literal75.o:null)); 

                    }
                    break;
                case 2 :
                    // org/infinispan/cli/interpreter/IspnQL.g:230:6: literal
                    {
                    pushFollow(FOLLOW_literal_in_keyIdentifier1291);
                    literal76=literal();

                    state._fsp--;

                    adaptor.addChild(root_0, literal76.getTree());

                     retval.key = new KeyData((literal76!=null?literal76.o:null)); 

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "keyIdentifier"


    public static class siteIdentifier_return extends ParserRuleReturnScope {
        public SiteData site;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "siteIdentifier"
    // org/infinispan/cli/interpreter/IspnQL.g:233:1: siteIdentifier returns [SiteData site] : (cacheName= STRINGLITERAL '.' siteName= STRINGLITERAL |siteName= STRINGLITERAL );
    public final IspnQLParser.siteIdentifier_return siteIdentifier() throws RecognitionException {
        IspnQLParser.siteIdentifier_return retval = new IspnQLParser.siteIdentifier_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token cacheName=null;
        Token siteName=null;
        Token char_literal77=null;

        Object cacheName_tree=null;
        Object siteName_tree=null;
        Object char_literal77_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:234:4: (cacheName= STRINGLITERAL '.' siteName= STRINGLITERAL |siteName= STRINGLITERAL )
            int alt24=2;
            switch ( input.LA(1) ) {
            case STRINGLITERAL:
                {
                switch ( input.LA(2) ) {
                case 68:
                    {
                    alt24=1;
                    }
                    break;
                case EOL:
                case 70:
                    {
                    alt24=2;
                    }
                    break;
                default:
                    NoViableAltException nvae =
                        new NoViableAltException("", 24, 1, input);

                    throw nvae;

                }

                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 24, 0, input);

                throw nvae;

            }

            switch (alt24) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:234:6: cacheName= STRINGLITERAL '.' siteName= STRINGLITERAL
                    {
                    cacheName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_siteIdentifier1316); 
                    cacheName_tree = 
                    (Object)adaptor.create(cacheName)
                    ;
                    adaptor.addChild(root_0, cacheName_tree);


                    char_literal77=(Token)match(input,68,FOLLOW_68_in_siteIdentifier1318); 
                    char_literal77_tree = 
                    (Object)adaptor.create(char_literal77)
                    ;
                    adaptor.addChild(root_0, char_literal77_tree);


                    siteName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_siteIdentifier1324); 
                    siteName_tree = 
                    (Object)adaptor.create(siteName)
                    ;
                    adaptor.addChild(root_0, siteName_tree);


                     retval.site = new SiteData(unquote((cacheName!=null?cacheName.getText():null)), (siteName!=null?siteName.getText():null)); 

                    }
                    break;
                case 2 :
                    // org/infinispan/cli/interpreter/IspnQL.g:235:6: siteName= STRINGLITERAL
                    {
                    siteName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_siteIdentifier1337); 
                    siteName_tree = 
                    (Object)adaptor.create(siteName)
                    ;
                    adaptor.addChild(root_0, siteName_tree);


                     retval.site = new SiteData((siteName!=null?siteName.getText():null)); 

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "siteIdentifier"


    public static class statementOptions_return extends ParserRuleReturnScope {
        public List<Option> options;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "statementOptions"
    // org/infinispan/cli/interpreter/IspnQL.g:238:1: statementOptions returns [List<Option> options] : ( statementOption )* ;
    public final IspnQLParser.statementOptions_return statementOptions() throws RecognitionException {
        IspnQLParser.statementOptions_return retval = new IspnQLParser.statementOptions_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        IspnQLParser.statementOption_return statementOption78 =null;




           retval.options = new ArrayList<Option>();

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:242:4: ( ( statementOption )* )
            // org/infinispan/cli/interpreter/IspnQL.g:242:6: ( statementOption )*
            {
            // org/infinispan/cli/interpreter/IspnQL.g:242:6: ( statementOption )*
            loop25:
            do {
                int alt25=2;
                switch ( input.LA(1) ) {
                case 67:
                    {
                    alt25=1;
                    }
                    break;

                }

                switch (alt25) {
            	case 1 :
            	    // org/infinispan/cli/interpreter/IspnQL.g:242:8: statementOption
            	    {
            	    pushFollow(FOLLOW_statementOption_in_statementOptions1365);
            	    statementOption78=statementOption();

            	    state._fsp--;

            	    adaptor.addChild(root_0, statementOption78.getTree());

            	     retval.options.add((statementOption78!=null?statementOption78.option:null)); 

            	    }
            	    break;

            	default :
            	    break loop25;
                }
            } while (true);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "statementOptions"


    public static class statementOption_return extends ParserRuleReturnScope {
        public Option option;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "statementOption"
    // org/infinispan/cli/interpreter/IspnQL.g:245:1: statementOption returns [Option option] : '--' optionName= STRINGLITERAL ( '=' optionParameter= STRINGLITERAL )? ;
    public final IspnQLParser.statementOption_return statementOption() throws RecognitionException {
        IspnQLParser.statementOption_return retval = new IspnQLParser.statementOption_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token optionName=null;
        Token optionParameter=null;
        Token string_literal79=null;
        Token char_literal80=null;

        Object optionName_tree=null;
        Object optionParameter_tree=null;
        Object string_literal79_tree=null;
        Object char_literal80_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:246:4: ( '--' optionName= STRINGLITERAL ( '=' optionParameter= STRINGLITERAL )? )
            // org/infinispan/cli/interpreter/IspnQL.g:246:6: '--' optionName= STRINGLITERAL ( '=' optionParameter= STRINGLITERAL )?
            {
            string_literal79=(Token)match(input,67,FOLLOW_67_in_statementOption1389); 
            string_literal79_tree = 
            (Object)adaptor.create(string_literal79)
            ;
            adaptor.addChild(root_0, string_literal79_tree);


            optionName=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_statementOption1395); 
            optionName_tree = 
            (Object)adaptor.create(optionName)
            ;
            adaptor.addChild(root_0, optionName_tree);


            // org/infinispan/cli/interpreter/IspnQL.g:246:38: ( '=' optionParameter= STRINGLITERAL )?
            int alt26=2;
            switch ( input.LA(1) ) {
                case 71:
                    {
                    alt26=1;
                    }
                    break;
            }

            switch (alt26) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:246:39: '=' optionParameter= STRINGLITERAL
                    {
                    char_literal80=(Token)match(input,71,FOLLOW_71_in_statementOption1398); 
                    char_literal80_tree = 
                    (Object)adaptor.create(char_literal80)
                    ;
                    adaptor.addChild(root_0, char_literal80_tree);


                    optionParameter=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_statementOption1404); 
                    optionParameter_tree = 
                    (Object)adaptor.create(optionParameter)
                    ;
                    adaptor.addChild(root_0, optionParameter_tree);


                    }
                    break;

            }


             retval.option = new Option(unquote((optionName!=null?optionName.getText():null)), unquote((optionParameter!=null?optionParameter.getText():null))); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "statementOption"


    public static class literal_return extends ParserRuleReturnScope {
        public Object o;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "literal"
    // org/infinispan/cli/interpreter/IspnQL.g:249:1: literal returns [Object o] : ( INTLITERAL | LONGLITERAL | FLOATLITERAL | DOUBLELITERAL | NULL | STRINGLITERAL | UUIDLITERAL |b= ( TRUE | FALSE ) | jsonLiteral );
    public final IspnQLParser.literal_return literal() throws RecognitionException {
        IspnQLParser.literal_return retval = new IspnQLParser.literal_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token b=null;
        Token INTLITERAL81=null;
        Token LONGLITERAL82=null;
        Token FLOATLITERAL83=null;
        Token DOUBLELITERAL84=null;
        Token NULL85=null;
        Token STRINGLITERAL86=null;
        Token UUIDLITERAL87=null;
        IspnQLParser.jsonLiteral_return jsonLiteral88 =null;


        Object b_tree=null;
        Object INTLITERAL81_tree=null;
        Object LONGLITERAL82_tree=null;
        Object FLOATLITERAL83_tree=null;
        Object DOUBLELITERAL84_tree=null;
        Object NULL85_tree=null;
        Object STRINGLITERAL86_tree=null;
        Object UUIDLITERAL87_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:250:4: ( INTLITERAL | LONGLITERAL | FLOATLITERAL | DOUBLELITERAL | NULL | STRINGLITERAL | UUIDLITERAL |b= ( TRUE | FALSE ) | jsonLiteral )
            int alt27=9;
            switch ( input.LA(1) ) {
            case INTLITERAL:
                {
                alt27=1;
                }
                break;
            case LONGLITERAL:
                {
                alt27=2;
                }
                break;
            case FLOATLITERAL:
                {
                alt27=3;
                }
                break;
            case DOUBLELITERAL:
                {
                alt27=4;
                }
                break;
            case NULL:
                {
                alt27=5;
                }
                break;
            case STRINGLITERAL:
                {
                alt27=6;
                }
                break;
            case UUIDLITERAL:
                {
                alt27=7;
                }
                break;
            case FALSE:
            case TRUE:
                {
                alt27=8;
                }
                break;
            case 74:
                {
                alt27=9;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 27, 0, input);

                throw nvae;

            }

            switch (alt27) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:250:6: INTLITERAL
                    {
                    INTLITERAL81=(Token)match(input,INTLITERAL,FOLLOW_INTLITERAL_in_literal1427); 
                    INTLITERAL81_tree = 
                    (Object)adaptor.create(INTLITERAL81)
                    ;
                    adaptor.addChild(root_0, INTLITERAL81_tree);


                     retval.o = Integer.valueOf((INTLITERAL81!=null?INTLITERAL81.getText():null)); 

                    }
                    break;
                case 2 :
                    // org/infinispan/cli/interpreter/IspnQL.g:251:6: LONGLITERAL
                    {
                    LONGLITERAL82=(Token)match(input,LONGLITERAL,FOLLOW_LONGLITERAL_in_literal1436); 
                    LONGLITERAL82_tree = 
                    (Object)adaptor.create(LONGLITERAL82)
                    ;
                    adaptor.addChild(root_0, LONGLITERAL82_tree);


                     retval.o = Long.valueOf((LONGLITERAL82!=null?LONGLITERAL82.getText():null)); 

                    }
                    break;
                case 3 :
                    // org/infinispan/cli/interpreter/IspnQL.g:252:6: FLOATLITERAL
                    {
                    FLOATLITERAL83=(Token)match(input,FLOATLITERAL,FOLLOW_FLOATLITERAL_in_literal1445); 
                    FLOATLITERAL83_tree = 
                    (Object)adaptor.create(FLOATLITERAL83)
                    ;
                    adaptor.addChild(root_0, FLOATLITERAL83_tree);


                     retval.o = Float.valueOf((FLOATLITERAL83!=null?FLOATLITERAL83.getText():null)); 

                    }
                    break;
                case 4 :
                    // org/infinispan/cli/interpreter/IspnQL.g:253:6: DOUBLELITERAL
                    {
                    DOUBLELITERAL84=(Token)match(input,DOUBLELITERAL,FOLLOW_DOUBLELITERAL_in_literal1454); 
                    DOUBLELITERAL84_tree = 
                    (Object)adaptor.create(DOUBLELITERAL84)
                    ;
                    adaptor.addChild(root_0, DOUBLELITERAL84_tree);


                     retval.o = Double.valueOf((DOUBLELITERAL84!=null?DOUBLELITERAL84.getText():null)); 

                    }
                    break;
                case 5 :
                    // org/infinispan/cli/interpreter/IspnQL.g:254:6: NULL
                    {
                    NULL85=(Token)match(input,NULL,FOLLOW_NULL_in_literal1463); 
                    NULL85_tree = 
                    (Object)adaptor.create(NULL85)
                    ;
                    adaptor.addChild(root_0, NULL85_tree);


                     retval.o = null; 

                    }
                    break;
                case 6 :
                    // org/infinispan/cli/interpreter/IspnQL.g:255:6: STRINGLITERAL
                    {
                    STRINGLITERAL86=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_literal1472); 
                    STRINGLITERAL86_tree = 
                    (Object)adaptor.create(STRINGLITERAL86)
                    ;
                    adaptor.addChild(root_0, STRINGLITERAL86_tree);


                     retval.o = unquote((STRINGLITERAL86!=null?STRINGLITERAL86.getText():null)); 

                    }
                    break;
                case 7 :
                    // org/infinispan/cli/interpreter/IspnQL.g:256:6: UUIDLITERAL
                    {
                    UUIDLITERAL87=(Token)match(input,UUIDLITERAL,FOLLOW_UUIDLITERAL_in_literal1481); 
                    UUIDLITERAL87_tree = 
                    (Object)adaptor.create(UUIDLITERAL87)
                    ;
                    adaptor.addChild(root_0, UUIDLITERAL87_tree);


                     retval.o = UUID.fromString((UUIDLITERAL87!=null?UUIDLITERAL87.getText():null)); 

                    }
                    break;
                case 8 :
                    // org/infinispan/cli/interpreter/IspnQL.g:257:6: b= ( TRUE | FALSE )
                    {
                    b=(Token)input.LT(1);

                    if ( input.LA(1)==FALSE||input.LA(1)==TRUE ) {
                        input.consume();
                        adaptor.addChild(root_0, 
                        (Object)adaptor.create(b)
                        );
                        state.errorRecovery=false;
                    }
                    else {
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        throw mse;
                    }


                     retval.o = Boolean.valueOf((b!=null?b.getText():null)); 

                    }
                    break;
                case 9 :
                    // org/infinispan/cli/interpreter/IspnQL.g:258:6: jsonLiteral
                    {
                    pushFollow(FOLLOW_jsonLiteral_in_literal1511);
                    jsonLiteral88=jsonLiteral();

                    state._fsp--;

                    adaptor.addChild(root_0, jsonLiteral88.getTree());


                           retval.o = jsonMapper.readValue((jsonLiteral88!=null?input.toString(jsonLiteral88.start,jsonLiteral88.stop):null), Object.class);
                       

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (JsonProcessingException jpe) {
             throw new RecognitionException(input); 
        }
        catch (IOException ioe) {
        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "literal"


    public static class timeLiteral_return extends ParserRuleReturnScope {
        public Long l;
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "timeLiteral"
    // org/infinispan/cli/interpreter/IspnQL.g:265:1: timeLiteral returns [Long l] : TIMELITERAL ;
    public final IspnQLParser.timeLiteral_return timeLiteral() throws RecognitionException {
        IspnQLParser.timeLiteral_return retval = new IspnQLParser.timeLiteral_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token TIMELITERAL89=null;

        Object TIMELITERAL89_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:266:4: ( TIMELITERAL )
            // org/infinispan/cli/interpreter/IspnQL.g:266:6: TIMELITERAL
            {
            TIMELITERAL89=(Token)match(input,TIMELITERAL,FOLLOW_TIMELITERAL_in_timeLiteral1548); 
            TIMELITERAL89_tree = 
            (Object)adaptor.create(TIMELITERAL89)
            ;
            adaptor.addChild(root_0, TIMELITERAL89_tree);


             retval.l = millis((TIMELITERAL89!=null?TIMELITERAL89.getText():null)); 

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "timeLiteral"


    public static class jsonLiteral_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "jsonLiteral"
    // org/infinispan/cli/interpreter/IspnQL.g:269:1: jsonLiteral : '{' jsonPair ( ',' jsonPair )* '}' ;
    public final IspnQLParser.jsonLiteral_return jsonLiteral() throws RecognitionException {
        IspnQLParser.jsonLiteral_return retval = new IspnQLParser.jsonLiteral_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token char_literal90=null;
        Token char_literal92=null;
        Token char_literal94=null;
        IspnQLParser.jsonPair_return jsonPair91 =null;

        IspnQLParser.jsonPair_return jsonPair93 =null;


        Object char_literal90_tree=null;
        Object char_literal92_tree=null;
        Object char_literal94_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:270:4: ( '{' jsonPair ( ',' jsonPair )* '}' )
            // org/infinispan/cli/interpreter/IspnQL.g:270:6: '{' jsonPair ( ',' jsonPair )* '}'
            {
            char_literal90=(Token)match(input,74,FOLLOW_74_in_jsonLiteral1565); 
            char_literal90_tree = 
            (Object)adaptor.create(char_literal90)
            ;
            adaptor.addChild(root_0, char_literal90_tree);


            pushFollow(FOLLOW_jsonPair_in_jsonLiteral1567);
            jsonPair91=jsonPair();

            state._fsp--;

            adaptor.addChild(root_0, jsonPair91.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:270:19: ( ',' jsonPair )*
            loop28:
            do {
                int alt28=2;
                switch ( input.LA(1) ) {
                case 66:
                    {
                    alt28=1;
                    }
                    break;

                }

                switch (alt28) {
            	case 1 :
            	    // org/infinispan/cli/interpreter/IspnQL.g:270:20: ',' jsonPair
            	    {
            	    char_literal92=(Token)match(input,66,FOLLOW_66_in_jsonLiteral1570); 
            	    char_literal92_tree = 
            	    (Object)adaptor.create(char_literal92)
            	    ;
            	    adaptor.addChild(root_0, char_literal92_tree);


            	    pushFollow(FOLLOW_jsonPair_in_jsonLiteral1572);
            	    jsonPair93=jsonPair();

            	    state._fsp--;

            	    adaptor.addChild(root_0, jsonPair93.getTree());

            	    }
            	    break;

            	default :
            	    break loop28;
                }
            } while (true);


            char_literal94=(Token)match(input,75,FOLLOW_75_in_jsonLiteral1576); 
            char_literal94_tree = 
            (Object)adaptor.create(char_literal94)
            ;
            adaptor.addChild(root_0, char_literal94_tree);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "jsonLiteral"


    public static class jsonPair_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "jsonPair"
    // org/infinispan/cli/interpreter/IspnQL.g:273:1: jsonPair : jsonString ':' jsonValue ;
    public final IspnQLParser.jsonPair_return jsonPair() throws RecognitionException {
        IspnQLParser.jsonPair_return retval = new IspnQLParser.jsonPair_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token char_literal96=null;
        IspnQLParser.jsonString_return jsonString95 =null;

        IspnQLParser.jsonValue_return jsonValue97 =null;


        Object char_literal96_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:274:4: ( jsonString ':' jsonValue )
            // org/infinispan/cli/interpreter/IspnQL.g:274:6: jsonString ':' jsonValue
            {
            pushFollow(FOLLOW_jsonString_in_jsonPair1591);
            jsonString95=jsonString();

            state._fsp--;

            adaptor.addChild(root_0, jsonString95.getTree());

            char_literal96=(Token)match(input,69,FOLLOW_69_in_jsonPair1593); 
            char_literal96_tree = 
            (Object)adaptor.create(char_literal96)
            ;
            adaptor.addChild(root_0, char_literal96_tree);


            pushFollow(FOLLOW_jsonValue_in_jsonPair1595);
            jsonValue97=jsonValue();

            state._fsp--;

            adaptor.addChild(root_0, jsonValue97.getTree());

            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "jsonPair"


    public static class jsonString_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "jsonString"
    // org/infinispan/cli/interpreter/IspnQL.g:277:1: jsonString : STRINGLITERAL ;
    public final IspnQLParser.jsonString_return jsonString() throws RecognitionException {
        IspnQLParser.jsonString_return retval = new IspnQLParser.jsonString_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token STRINGLITERAL98=null;

        Object STRINGLITERAL98_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:278:4: ( STRINGLITERAL )
            // org/infinispan/cli/interpreter/IspnQL.g:278:6: STRINGLITERAL
            {
            STRINGLITERAL98=(Token)match(input,STRINGLITERAL,FOLLOW_STRINGLITERAL_in_jsonString1610); 
            STRINGLITERAL98_tree = 
            (Object)adaptor.create(STRINGLITERAL98)
            ;
            adaptor.addChild(root_0, STRINGLITERAL98_tree);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "jsonString"


    public static class jsonValue_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "jsonValue"
    // org/infinispan/cli/interpreter/IspnQL.g:281:1: jsonValue : ( jsonLiteral | jsonArray | INTLITERAL | DOUBLELITERAL | TRUE | FALSE | NULL | jsonString );
    public final IspnQLParser.jsonValue_return jsonValue() throws RecognitionException {
        IspnQLParser.jsonValue_return retval = new IspnQLParser.jsonValue_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token INTLITERAL101=null;
        Token DOUBLELITERAL102=null;
        Token TRUE103=null;
        Token FALSE104=null;
        Token NULL105=null;
        IspnQLParser.jsonLiteral_return jsonLiteral99 =null;

        IspnQLParser.jsonArray_return jsonArray100 =null;

        IspnQLParser.jsonString_return jsonString106 =null;


        Object INTLITERAL101_tree=null;
        Object DOUBLELITERAL102_tree=null;
        Object TRUE103_tree=null;
        Object FALSE104_tree=null;
        Object NULL105_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:282:4: ( jsonLiteral | jsonArray | INTLITERAL | DOUBLELITERAL | TRUE | FALSE | NULL | jsonString )
            int alt29=8;
            switch ( input.LA(1) ) {
            case 74:
                {
                alt29=1;
                }
                break;
            case 72:
                {
                alt29=2;
                }
                break;
            case INTLITERAL:
                {
                alt29=3;
                }
                break;
            case DOUBLELITERAL:
                {
                alt29=4;
                }
                break;
            case TRUE:
                {
                alt29=5;
                }
                break;
            case FALSE:
                {
                alt29=6;
                }
                break;
            case NULL:
                {
                alt29=7;
                }
                break;
            case STRINGLITERAL:
                {
                alt29=8;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 29, 0, input);

                throw nvae;

            }

            switch (alt29) {
                case 1 :
                    // org/infinispan/cli/interpreter/IspnQL.g:282:6: jsonLiteral
                    {
                    pushFollow(FOLLOW_jsonLiteral_in_jsonValue1625);
                    jsonLiteral99=jsonLiteral();

                    state._fsp--;

                    adaptor.addChild(root_0, jsonLiteral99.getTree());

                    }
                    break;
                case 2 :
                    // org/infinispan/cli/interpreter/IspnQL.g:283:6: jsonArray
                    {
                    pushFollow(FOLLOW_jsonArray_in_jsonValue1632);
                    jsonArray100=jsonArray();

                    state._fsp--;

                    adaptor.addChild(root_0, jsonArray100.getTree());

                    }
                    break;
                case 3 :
                    // org/infinispan/cli/interpreter/IspnQL.g:284:6: INTLITERAL
                    {
                    INTLITERAL101=(Token)match(input,INTLITERAL,FOLLOW_INTLITERAL_in_jsonValue1639); 
                    INTLITERAL101_tree = 
                    (Object)adaptor.create(INTLITERAL101)
                    ;
                    adaptor.addChild(root_0, INTLITERAL101_tree);


                    }
                    break;
                case 4 :
                    // org/infinispan/cli/interpreter/IspnQL.g:285:6: DOUBLELITERAL
                    {
                    DOUBLELITERAL102=(Token)match(input,DOUBLELITERAL,FOLLOW_DOUBLELITERAL_in_jsonValue1646); 
                    DOUBLELITERAL102_tree = 
                    (Object)adaptor.create(DOUBLELITERAL102)
                    ;
                    adaptor.addChild(root_0, DOUBLELITERAL102_tree);


                    }
                    break;
                case 5 :
                    // org/infinispan/cli/interpreter/IspnQL.g:286:6: TRUE
                    {
                    TRUE103=(Token)match(input,TRUE,FOLLOW_TRUE_in_jsonValue1653); 
                    TRUE103_tree = 
                    (Object)adaptor.create(TRUE103)
                    ;
                    adaptor.addChild(root_0, TRUE103_tree);


                    }
                    break;
                case 6 :
                    // org/infinispan/cli/interpreter/IspnQL.g:286:13: FALSE
                    {
                    FALSE104=(Token)match(input,FALSE,FOLLOW_FALSE_in_jsonValue1657); 
                    FALSE104_tree = 
                    (Object)adaptor.create(FALSE104)
                    ;
                    adaptor.addChild(root_0, FALSE104_tree);


                    }
                    break;
                case 7 :
                    // org/infinispan/cli/interpreter/IspnQL.g:287:6: NULL
                    {
                    NULL105=(Token)match(input,NULL,FOLLOW_NULL_in_jsonValue1664); 
                    NULL105_tree = 
                    (Object)adaptor.create(NULL105)
                    ;
                    adaptor.addChild(root_0, NULL105_tree);


                    }
                    break;
                case 8 :
                    // org/infinispan/cli/interpreter/IspnQL.g:288:6: jsonString
                    {
                    pushFollow(FOLLOW_jsonString_in_jsonValue1671);
                    jsonString106=jsonString();

                    state._fsp--;

                    adaptor.addChild(root_0, jsonString106.getTree());

                    }
                    break;

            }
            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "jsonValue"


    public static class jsonArray_return extends ParserRuleReturnScope {
        Object tree;
        public Object getTree() { return tree; }
    };


    // $ANTLR start "jsonArray"
    // org/infinispan/cli/interpreter/IspnQL.g:291:1: jsonArray : '[' jsonValue ( ',' jsonValue )* ']' ;
    public final IspnQLParser.jsonArray_return jsonArray() throws RecognitionException {
        IspnQLParser.jsonArray_return retval = new IspnQLParser.jsonArray_return();
        retval.start = input.LT(1);


        Object root_0 = null;

        Token char_literal107=null;
        Token char_literal109=null;
        Token char_literal111=null;
        IspnQLParser.jsonValue_return jsonValue108 =null;

        IspnQLParser.jsonValue_return jsonValue110 =null;


        Object char_literal107_tree=null;
        Object char_literal109_tree=null;
        Object char_literal111_tree=null;

        try {
            // org/infinispan/cli/interpreter/IspnQL.g:292:4: ( '[' jsonValue ( ',' jsonValue )* ']' )
            // org/infinispan/cli/interpreter/IspnQL.g:292:6: '[' jsonValue ( ',' jsonValue )* ']'
            {
            char_literal107=(Token)match(input,72,FOLLOW_72_in_jsonArray1686); 
            char_literal107_tree = 
            (Object)adaptor.create(char_literal107)
            ;
            adaptor.addChild(root_0, char_literal107_tree);


            pushFollow(FOLLOW_jsonValue_in_jsonArray1688);
            jsonValue108=jsonValue();

            state._fsp--;

            adaptor.addChild(root_0, jsonValue108.getTree());

            // org/infinispan/cli/interpreter/IspnQL.g:292:20: ( ',' jsonValue )*
            loop30:
            do {
                int alt30=2;
                switch ( input.LA(1) ) {
                case 66:
                    {
                    alt30=1;
                    }
                    break;

                }

                switch (alt30) {
            	case 1 :
            	    // org/infinispan/cli/interpreter/IspnQL.g:292:21: ',' jsonValue
            	    {
            	    char_literal109=(Token)match(input,66,FOLLOW_66_in_jsonArray1691); 
            	    char_literal109_tree = 
            	    (Object)adaptor.create(char_literal109)
            	    ;
            	    adaptor.addChild(root_0, char_literal109_tree);


            	    pushFollow(FOLLOW_jsonValue_in_jsonArray1693);
            	    jsonValue110=jsonValue();

            	    state._fsp--;

            	    adaptor.addChild(root_0, jsonValue110.getTree());

            	    }
            	    break;

            	default :
            	    break loop30;
                }
            } while (true);


            char_literal111=(Token)match(input,73,FOLLOW_73_in_jsonArray1697); 
            char_literal111_tree = 
            (Object)adaptor.create(char_literal111)
            ;
            adaptor.addChild(root_0, char_literal111_tree);


            }

            retval.stop = input.LT(-1);


            retval.tree = (Object)adaptor.rulePostProcessing(root_0);
            adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
    	retval.tree = (Object)adaptor.errorNode(input, retval.start, input.LT(-1), re);

        }

        finally {
        	// do for sure before leaving
        }
        return retval;
    }
    // $ANTLR end "jsonArray"

    // Delegated rules


 

    public static final BitSet FOLLOW_statement_in_statements72 = new BitSet(new long[]{0x081FE022203C0F90L,0x0000000000000001L});
    public static final BitSet FOLLOW_EOL_in_statements76 = new BitSet(new long[]{0x081FE022203C0F90L,0x0000000000000001L});
    public static final BitSet FOLLOW_EOF_in_statements81 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_abortBatchStatement_in_statement100 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_beginTransactionStatement_in_statement109 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_cacheStatement_in_statement118 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_clearStatement_in_statement127 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_commitTransactionStatement_in_statement136 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_createStatement_in_statement145 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_encodingStatement_in_statement154 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_endBatchStatement_in_statement163 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_evictStatement_in_statement172 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_getStatement_in_statement181 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_infoStatement_in_statement190 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_locateStatement_in_statement199 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_pingStatement_in_statement208 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_putStatement_in_statement217 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_removeStatement_in_statement226 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_replaceStatement_in_statement235 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rollbackTransactionStatement_in_statement244 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_siteStatement_in_statement253 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_startBatchStatement_in_statement262 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_statsStatement_in_statement271 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_upgradeStatement_in_statement280 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_versionStatement_in_statement289 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ABORT_in_abortBatchStatement311 = new BitSet(new long[]{0x0020000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_abortBatchStatement318 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_set_in_abortBatchStatement322 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_BEGIN_in_beginTransactionStatement350 = new BitSet(new long[]{0x0020000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_beginTransactionStatement357 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_set_in_beginTransactionStatement361 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CACHE_in_cacheStatement389 = new BitSet(new long[]{0x0020000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_cacheStatement396 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_set_in_cacheStatement400 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CLEAR_in_clearStatement428 = new BitSet(new long[]{0x0020000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_clearStatement435 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_set_in_clearStatement439 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_COMMIT_in_commitTransactionStatement467 = new BitSet(new long[]{0x0020000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_commitTransactionStatement474 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_set_in_commitTransactionStatement478 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_CREATE_in_createStatement506 = new BitSet(new long[]{0x0020000000000000L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_createStatement512 = new BitSet(new long[]{0x0000001000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_LIKE_in_createStatement515 = new BitSet(new long[]{0x0020000000000000L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_createStatement521 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_set_in_createStatement525 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ENCODING_in_encodingStatement553 = new BitSet(new long[]{0x0020000000100000L,0x0000000000000048L});
    public static final BitSet FOLLOW_statementOptions_in_encodingStatement559 = new BitSet(new long[]{0x0020000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_encodingStatement566 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_set_in_encodingStatement570 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_END_in_endBatchStatement598 = new BitSet(new long[]{0x0020000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_endBatchStatement605 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_set_in_endBatchStatement609 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_EVICT_in_evictStatement637 = new BitSet(new long[]{0x122004440C004000L,0x0000000000000400L});
    public static final BitSet FOLLOW_keyIdentifier_in_evictStatement643 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_set_in_evictStatement645 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_GET_in_getStatement673 = new BitSet(new long[]{0x122004440C004000L,0x0000000000000408L});
    public static final BitSet FOLLOW_statementOptions_in_getStatement679 = new BitSet(new long[]{0x122004440C004000L,0x0000000000000400L});
    public static final BitSet FOLLOW_keyIdentifier_in_getStatement685 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_set_in_getStatement687 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INFO_in_infoStatement715 = new BitSet(new long[]{0x0020000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_infoStatement722 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_set_in_infoStatement726 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LOCATE_in_locateStatement754 = new BitSet(new long[]{0x122004440C004000L,0x0000000000000408L});
    public static final BitSet FOLLOW_statementOptions_in_locateStatement760 = new BitSet(new long[]{0x122004440C004000L,0x0000000000000400L});
    public static final BitSet FOLLOW_keyIdentifier_in_locateStatement766 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_set_in_locateStatement768 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_PING_in_pingStatement796 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_set_in_pingStatement798 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_PUT_in_putStatement826 = new BitSet(new long[]{0x122004440C004000L,0x0000000000000408L});
    public static final BitSet FOLLOW_statementOptions_in_putStatement832 = new BitSet(new long[]{0x122004440C004000L,0x0000000000000400L});
    public static final BitSet FOLLOW_keyIdentifier_in_putStatement838 = new BitSet(new long[]{0x122004440C004000L,0x0000000000000400L});
    public static final BitSet FOLLOW_literal_in_putStatement844 = new BitSet(new long[]{0x0000000000500000L,0x0000000000000040L});
    public static final BitSet FOLLOW_expirationClause_in_putStatement851 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_set_in_putStatement855 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_REMOVE_in_removeStatement883 = new BitSet(new long[]{0x122004440C004000L,0x0000000000000400L});
    public static final BitSet FOLLOW_keyIdentifier_in_removeStatement889 = new BitSet(new long[]{0x122004440C104000L,0x0000000000000440L});
    public static final BitSet FOLLOW_literal_in_removeStatement896 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_set_in_removeStatement900 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_REPLACE_in_replaceStatement928 = new BitSet(new long[]{0x122004440C004000L,0x0000000000000408L});
    public static final BitSet FOLLOW_statementOptions_in_replaceStatement934 = new BitSet(new long[]{0x122004440C004000L,0x0000000000000400L});
    public static final BitSet FOLLOW_keyIdentifier_in_replaceStatement940 = new BitSet(new long[]{0x122004440C004000L,0x0000000000000400L});
    public static final BitSet FOLLOW_literal_in_replaceStatement946 = new BitSet(new long[]{0x122004440C504000L,0x0000000000000440L});
    public static final BitSet FOLLOW_literal_in_replaceStatement953 = new BitSet(new long[]{0x0000000000500000L,0x0000000000000040L});
    public static final BitSet FOLLOW_expirationClause_in_replaceStatement962 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_set_in_replaceStatement966 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ROLLBACK_in_rollbackTransactionStatement994 = new BitSet(new long[]{0x0020000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_rollbackTransactionStatement1001 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_set_in_rollbackTransactionStatement1005 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_SITE_in_siteStatement1036 = new BitSet(new long[]{0x0020000000100000L,0x0000000000000048L});
    public static final BitSet FOLLOW_statementOptions_in_siteStatement1042 = new BitSet(new long[]{0x0020000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_siteIdentifier_in_siteStatement1049 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_set_in_siteStatement1053 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_START_in_startBatchStatement1081 = new BitSet(new long[]{0x0020000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_startBatchStatement1088 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_set_in_startBatchStatement1092 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STATS_in_statsStatement1120 = new BitSet(new long[]{0x0020000000100000L,0x0000000000000048L});
    public static final BitSet FOLLOW_statementOptions_in_statsStatement1126 = new BitSet(new long[]{0x0020000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_statsStatement1133 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_set_in_statsStatement1137 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_UPGRADE_in_upgradeStatement1165 = new BitSet(new long[]{0x0020000000100000L,0x0000000000000048L});
    public static final BitSet FOLLOW_statementOptions_in_upgradeStatement1171 = new BitSet(new long[]{0x0020000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_upgradeStatement1178 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_set_in_upgradeStatement1182 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_VERSION_in_versionStatement1210 = new BitSet(new long[]{0x0000000000100000L,0x0000000000000040L});
    public static final BitSet FOLLOW_set_in_versionStatement1212 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_EXPIRES_in_expirationClause1240 = new BitSet(new long[]{0x0100000000000000L});
    public static final BitSet FOLLOW_timeLiteral_in_expirationClause1246 = new BitSet(new long[]{0x0000020000000002L});
    public static final BitSet FOLLOW_MAXIDLE_in_expirationClause1249 = new BitSet(new long[]{0x0100000000000000L});
    public static final BitSet FOLLOW_timeLiteral_in_expirationClause1255 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_keyIdentifier1278 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
    public static final BitSet FOLLOW_68_in_keyIdentifier1280 = new BitSet(new long[]{0x122004440C004000L,0x0000000000000400L});
    public static final BitSet FOLLOW_literal_in_keyIdentifier1282 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_literal_in_keyIdentifier1291 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_siteIdentifier1316 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
    public static final BitSet FOLLOW_68_in_siteIdentifier1318 = new BitSet(new long[]{0x0020000000000000L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_siteIdentifier1324 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_siteIdentifier1337 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_statementOption_in_statementOptions1365 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000008L});
    public static final BitSet FOLLOW_67_in_statementOption1389 = new BitSet(new long[]{0x0020000000000000L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_statementOption1395 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000080L});
    public static final BitSet FOLLOW_71_in_statementOption1398 = new BitSet(new long[]{0x0020000000000000L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_statementOption1404 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INTLITERAL_in_literal1427 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_LONGLITERAL_in_literal1436 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FLOATLITERAL_in_literal1445 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DOUBLELITERAL_in_literal1454 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NULL_in_literal1463 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_literal1472 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_UUIDLITERAL_in_literal1481 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_set_in_literal1494 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_jsonLiteral_in_literal1511 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_TIMELITERAL_in_timeLiteral1548 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_74_in_jsonLiteral1565 = new BitSet(new long[]{0x0020000000000000L});
    public static final BitSet FOLLOW_jsonPair_in_jsonLiteral1567 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000804L});
    public static final BitSet FOLLOW_66_in_jsonLiteral1570 = new BitSet(new long[]{0x0020000000000000L});
    public static final BitSet FOLLOW_jsonPair_in_jsonLiteral1572 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000804L});
    public static final BitSet FOLLOW_75_in_jsonLiteral1576 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_jsonString_in_jsonPair1591 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000020L});
    public static final BitSet FOLLOW_69_in_jsonPair1593 = new BitSet(new long[]{0x0220040404004000L,0x0000000000000500L});
    public static final BitSet FOLLOW_jsonValue_in_jsonPair1595 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_STRINGLITERAL_in_jsonString1610 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_jsonLiteral_in_jsonValue1625 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_jsonArray_in_jsonValue1632 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_INTLITERAL_in_jsonValue1639 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_DOUBLELITERAL_in_jsonValue1646 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_TRUE_in_jsonValue1653 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_FALSE_in_jsonValue1657 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_NULL_in_jsonValue1664 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_jsonString_in_jsonValue1671 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_72_in_jsonArray1686 = new BitSet(new long[]{0x0220040404004000L,0x0000000000000500L});
    public static final BitSet FOLLOW_jsonValue_in_jsonArray1688 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000204L});
    public static final BitSet FOLLOW_66_in_jsonArray1691 = new BitSet(new long[]{0x0220040404004000L,0x0000000000000500L});
    public static final BitSet FOLLOW_jsonValue_in_jsonArray1693 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000204L});
    public static final BitSet FOLLOW_73_in_jsonArray1697 = new BitSet(new long[]{0x0000000000000002L});

}