/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.codec;

import org.infinispan.cli.interpreter.codec.Codec;
import org.infinispan.cli.interpreter.codec.CodecException;
import org.infinispan.cli.interpreter.logging.Log;
import org.infinispan.marshall.Marshaller;
import org.infinispan.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.server.core.CacheValue;
import org.infinispan.util.ByteArrayKey;
import org.infinispan.util.logging.LogFactory;

public class HotRodCodec
implements Codec {
    public static final Log log = (Log)LogFactory.getLog(HotRodCodec.class, Log.class);
    Marshaller marshaller = new GenericJBossMarshaller();

    @Override
    public String getName() {
        return "hotrod";
    }

    @Override
    public Object encodeKey(Object key) throws CodecException {
        if (key != null) {
            try {
                return new ByteArrayKey(this.marshaller.objectToByteBuffer(key));
            }
            catch (Exception e) {
                throw log.keyEncodingFailed(e, this.getName());
            }
        }
        return null;
    }

    @Override
    public Object encodeValue(Object value) throws CodecException {
        if (value != null) {
            try {
                return new CacheValue(this.marshaller.objectToByteBuffer(value), 1L);
            }
            catch (Exception e) {
                throw log.valueEncodingFailed(e, this.getName());
            }
        }
        return null;
    }

    @Override
    public Object decodeKey(Object key) throws CodecException {
        if (key != null) {
            try {
                ByteArrayKey byteKey = (ByteArrayKey)key;
                return this.marshaller.objectFromByteBuffer(byteKey.getData());
            }
            catch (Exception e) {
                throw log.keyDecodingFailed(e, this.getName());
            }
        }
        return null;
    }

    @Override
    public Object decodeValue(Object value) throws CodecException {
        if (value != null) {
            try {
                CacheValue cv = (CacheValue)value;
                return this.marshaller.objectFromByteBuffer(cv.data());
            }
            catch (Exception e) {
                throw log.valueDecodingFailed(e, this.getName());
            }
        }
        return null;
    }
}

