/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.infinispan.cli.interpreter.IspnCliQLLexer;
import org.infinispan.cli.interpreter.IspnCliQLParser;
import org.infinispan.cli.interpreter.ParseException;
import org.infinispan.cli.interpreter.codec.CodecRegistry;
import org.infinispan.cli.interpreter.logging.Log;
import org.infinispan.cli.interpreter.result.EmptyResult;
import org.infinispan.cli.interpreter.result.Result;
import org.infinispan.cli.interpreter.result.ResultKeys;
import org.infinispan.cli.interpreter.session.Session;
import org.infinispan.cli.interpreter.session.SessionImpl;
import org.infinispan.cli.interpreter.statement.Statement;
import org.infinispan.commons.util.SysPropertyActions;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
@MBean(objectName="Interpreter", description="Interpreter component which executes CLI operations")
public class Interpreter {
    private static final Log log = (Log)LogFactory.getLog(Interpreter.class, Log.class);
    private static final long DEFAULT_SESSION_REAPER_WAKEUP_INTERVAL = 60000L;
    private static final long DEFAULT_SESSION_TIMEOUT = 60000L;
    private EmbeddedCacheManager cacheManager;
    private ScheduledExecutorService executor;
    private long sessionReaperWakeupInterval = 60000L;
    private long sessionTimeout = 60000L;
    private CodecRegistry codecRegistry;
    private TimeService timeService;
    private final Map<String, Session> sessions = new ConcurrentHashMap<String, Session>();
    private ScheduledFuture<?> sessionReaperTask;

    @Inject
    public void initialize(EmbeddedCacheManager cacheManager, TimeService timeService) {
        this.cacheManager = cacheManager;
        this.codecRegistry = new CodecRegistry(cacheManager.getCacheManagerConfiguration().classLoader());
        this.timeService = timeService;
    }

    @Start
    public void start() {
        this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "Interpreter");
            }
        });
        this.sessionReaperTask = this.executor.scheduleWithFixedDelay(new ScheduledTask(), this.sessionReaperWakeupInterval, this.sessionReaperWakeupInterval, TimeUnit.MILLISECONDS);
    }

    @Stop
    public void stop() {
        if (this.sessionReaperTask != null) {
            this.sessionReaperTask.cancel(true);
        }
        this.executor.shutdownNow();
    }

    @ManagedOperation(description="Creates a new interpreter session")
    public String createSessionId(String cacheName) {
        String sessionId = UUID.randomUUID().toString();
        SessionImpl session = new SessionImpl(this.codecRegistry, this.cacheManager, sessionId, this.timeService);
        this.sessions.put(sessionId, session);
        if (cacheName != null) {
            session.setCurrentCache(cacheName);
        }
        return sessionId;
    }

    public long getSessionReaperWakeupInterval() {
        return this.sessionReaperWakeupInterval;
    }

    public void setSessionReaperWakeupInterval(long sessionReaperWakeupInterval) {
        this.sessionReaperWakeupInterval = sessionReaperWakeupInterval;
    }

    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    void expireSessions() {
        long timeBoundary = this.timeService.time() - this.sessionTimeout * 1000000L;
        Iterator<Session> i = this.sessions.values().iterator();
        while (i.hasNext()) {
            Session session = i.next();
            if (session.getTimestamp() >= timeBoundary) continue;
            i.remove();
            if (!log.isDebugEnabled()) continue;
            log.debugf("Removed expired interpreter session %s", session.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation(description="Parses and executes IspnCliQL statements")
    public Map<String, String> execute(String sessionId, String s) throws Exception {
        HashMap<String, String> response;
        ClassLoader oldCL;
        block8: {
            Session session = null;
            oldCL = SysPropertyActions.setThreadContextClassLoader((ClassLoader)this.cacheManager.getCacheManagerConfiguration().classLoader());
            response = new HashMap<String, String>();
            try {
                session = this.validateSession(sessionId);
                ANTLRStringStream stream = new ANTLRStringStream(s);
                IspnCliQLLexer lexer = new IspnCliQLLexer((CharStream)stream);
                CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
                IspnCliQLParser parser = new IspnCliQLParser((TokenStream)tokens);
                parser.statements();
                if (parser.hasParserErrors()) {
                    throw new ParseException(parser.getParserErrors());
                }
                StringBuilder output = new StringBuilder();
                for (Statement stmt : parser.statements) {
                    Result result = stmt.execute(session);
                    if (result == EmptyResult.RESULT) continue;
                    output.append(result.getResult());
                }
                if (output.length() > 0) {
                    response.put(ResultKeys.OUTPUT.toString(), output.toString());
                }
                if (session == null) break block8;
                session.reset();
                response.put(ResultKeys.CACHE.toString(), session.getCurrentCacheName());
            }
            catch (Throwable t) {
                block9: {
                    try {
                        log.interpreterError(t);
                        response.put(ResultKeys.ERROR.toString(), t.getMessage());
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        t.printStackTrace(pw);
                        response.put(ResultKeys.STACKTRACE.toString(), sw.toString());
                        if (session == null) break block9;
                        session.reset();
                        response.put(ResultKeys.CACHE.toString(), session.getCurrentCacheName());
                    }
                    catch (Throwable throwable) {
                        if (session != null) {
                            session.reset();
                            response.put(ResultKeys.CACHE.toString(), session.getCurrentCacheName());
                        }
                        SysPropertyActions.setThreadContextClassLoader((ClassLoader)oldCL);
                        throw throwable;
                    }
                }
                SysPropertyActions.setThreadContextClassLoader((ClassLoader)oldCL);
            }
        }
        SysPropertyActions.setThreadContextClassLoader((ClassLoader)oldCL);
        return response;
    }

    private Session validateSession(String sessionId) {
        if (sessionId == null) {
            SessionImpl session = new SessionImpl(this.codecRegistry, this.cacheManager, null, this.timeService);
            session.setCurrentCache("___defaultcache");
            return session;
        }
        if (!this.sessions.containsKey(sessionId)) {
            throw log.invalidSession(sessionId);
        }
        return this.sessions.get(sessionId);
    }

    @ManagedAttribute(description="Retrieves a list of caches for the cache manager")
    public String[] getCacheNames() {
        HashSet<String> cacheNames = new HashSet<String>(this.cacheManager.getCacheNames());
        cacheNames.add("___defaultcache");
        return cacheNames.toArray(new String[0]);
    }

    class ScheduledTask
    implements Runnable {
        ScheduledTask() {
        }

        @Override
        public void run() {
            Interpreter.this.expireSessions();
        }
    }
}

