/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.statement;

import java.util.List;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cli.interpreter.codec.Codec;
import org.infinispan.cli.interpreter.logging.Log;
import org.infinispan.cli.interpreter.result.EmptyResult;
import org.infinispan.cli.interpreter.result.Result;
import org.infinispan.cli.interpreter.result.StatementException;
import org.infinispan.cli.interpreter.session.Session;
import org.infinispan.cli.interpreter.statement.ExpirationData;
import org.infinispan.cli.interpreter.statement.KeyData;
import org.infinispan.cli.interpreter.statement.Option;
import org.infinispan.cli.interpreter.statement.Statement;
import org.infinispan.metadata.Metadata;
import org.infinispan.util.logging.LogFactory;

public class PutStatement
implements Statement {
    private static final Log log = (Log)LogFactory.getLog(PutStatement.class, Log.class);
    final KeyData keyData;
    final Object value;
    final Long expires;
    final Long maxIdle;
    private final List<Option> options;

    public PutStatement(List<Option> options, KeyData key, Object value, ExpirationData exp) {
        this.options = options;
        this.keyData = key;
        this.value = value;
        if (exp != null) {
            this.expires = exp.expires;
            this.maxIdle = exp.maxIdle;
        } else {
            this.expires = null;
            this.maxIdle = null;
        }
    }

    @Override
    public Result execute(Session session) throws StatementException {
        AdvancedCache cache = session.getCache(this.keyData.getCacheName()).getAdvancedCache();
        Codec codec = session.getCodec();
        boolean overwrite = true;
        if (this.options.size() > 0) {
            for (Option option : this.options) {
                switch (option.toEnum(Options.class)) {
                    case CODEC: {
                        if (option.getParameter() == null) {
                            throw log.missingOptionParameter(option.getName());
                        }
                        codec = session.getCodec(option.getParameter());
                        break;
                    }
                    case IFABSENT: {
                        overwrite = false;
                    }
                }
            }
        }
        Object encodedKey = codec.encodeKey(this.keyData.getKey());
        Object encodedValue = codec.encodeValue(this.value);
        Metadata metadata = codec.encodeMetadata((Cache<?, ?>)cache, this.expires, this.maxIdle);
        if (overwrite) {
            cache.put(encodedKey, encodedValue, metadata);
        } else {
            cache.putIfAbsent(encodedKey, encodedValue, metadata);
        }
        return EmptyResult.RESULT;
    }

    private static enum Options {
        CODEC,
        IFABSENT;

    }
}

