/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;

final class SecurityActions {
    SecurityActions() {
    }

    static String getProperty(String name, String defaultValue) {
        if (System.getSecurityManager() == null) {
            return SysProps.NON_PRIVILEGED.getProperty(name, defaultValue);
        }
        return SysProps.PRIVILEGED.getProperty(name, defaultValue);
    }

    static String getProperty(String name) {
        if (System.getSecurityManager() == null) {
            return SysProps.NON_PRIVILEGED.getProperty(name);
        }
        return SysProps.PRIVILEGED.getProperty(name);
    }

    static String setProperty(String name, String value) {
        if (System.getSecurityManager() == null) {
            return SysProps.NON_PRIVILEGED.setProperty(name, value);
        }
        return SysProps.PRIVILEGED.setProperty(name, value);
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return action.run();
    }

    static void addSecurityProvider(Provider provider) {
        SecurityActions.doPrivileged(() -> {
            if (Security.getProvider(provider.getName()) == null) {
                Security.insertProviderAt(provider, 1);
            }
            return null;
        });
    }

    static interface SysProps {
        public static final SysProps NON_PRIVILEGED = new SysProps(){

            @Override
            public String getProperty(String name, String defaultValue) {
                return System.getProperty(name, defaultValue);
            }

            @Override
            public String getProperty(String name) {
                return System.getProperty(name);
            }

            @Override
            public String setProperty(String name, String value) {
                return System.setProperty(name, value);
            }
        };
        public static final SysProps PRIVILEGED = new SysProps(){

            @Override
            public String getProperty(final String name, final String defaultValue) {
                PrivilegedAction<String> action = new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty(name, defaultValue);
                    }
                };
                return AccessController.doPrivileged(action);
            }

            @Override
            public String getProperty(final String name) {
                PrivilegedAction<String> action = new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty(name);
                    }
                };
                return AccessController.doPrivileged(action);
            }

            @Override
            public String setProperty(final String name, final String value) {
                PrivilegedAction<String> action = new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.setProperty(name, value);
                    }
                };
                return AccessController.doPrivileged(action);
            }
        };

        public String getProperty(String var1, String var2);

        public String getProperty(String var1);

        public String setProperty(String var1, String var2);
    }
}

