/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.netty;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import java.io.File;
import java.util.Collections;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.SslConfiguration;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.util.SslContextFactory;

public class SslHandlerHelper {
    public static SslHandler createSslHandler(Configuration configuration, ByteBufAllocator alloc, String ... alpnProtocols) {
        JdkSslContext nettySslContext;
        SslConfiguration ssl = configuration.security().ssl();
        SSLContext jdkSslContext = ssl.sslContext();
        if (jdkSslContext == null) {
            SslContextBuilder builder = SslContextBuilder.forClient();
            try {
                if (ssl.keyStoreFileName() != null) {
                    builder.keyManager(SslContextFactory.getKeyManagerFactory((String)ssl.keyStoreFileName(), (String)ssl.keyStoreType(), (char[])ssl.keyStorePassword(), (char[])ssl.keyStoreCertificatePassword(), (String)ssl.keyAlias(), (ClassLoader)configuration.classLoader()));
                }
                if (ssl.trustStoreFileName() != null) {
                    builder.trustManager(SslContextFactory.getTrustManagerFactory((String)ssl.trustStoreFileName(), (String)ssl.trustStoreType(), (char[])ssl.trustStorePassword(), (ClassLoader)configuration.classLoader()));
                }
                if (ssl.trustStorePath() != null) {
                    builder.trustManager(new File(ssl.trustStorePath()));
                }
                if (ssl.protocol() != null) {
                    builder.protocols(new String[]{ssl.protocol()});
                }
                if (alpnProtocols != null && alpnProtocols.length > 0) {
                    builder.sslProvider(OpenSsl.isAlpnSupported() ? SslProvider.OPENSSL : SslProvider.JDK);
                    builder.applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.CHOOSE_MY_LAST_PROTOCOL, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, alpnProtocols));
                }
                nettySslContext = builder.build();
            }
            catch (Exception e) {
                throw new CacheConfigurationException(e);
            }
        } else {
            nettySslContext = new JdkSslContext(jdkSslContext, true, ClientAuth.NONE);
        }
        SslHandler sslHandler = nettySslContext.newHandler(alloc, ssl.sniHostName(), -1);
        if (ssl.sniHostName() != null) {
            SSLParameters sslParameters = sslHandler.engine().getSSLParameters();
            sslParameters.setServerNames(Collections.singletonList(new SNIHostName(ssl.sniHostName())));
            sslHandler.engine().setSSLParameters(sslParameters);
        }
        return sslHandler;
    }
}

