/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.client.hotrod.CacheTopologyInfo;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.ProtocolVersion;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.ServerStatistics;
import org.infinispan.client.hotrod.StreamingRemoteCache;
import org.infinispan.client.hotrod.VersionedValue;
import org.infinispan.client.hotrod.configuration.StatisticsConfiguration;
import org.infinispan.client.hotrod.event.impl.ClientListenerNotifier;
import org.infinispan.client.hotrod.exceptions.RemoteCacheManagerNotStartedException;
import org.infinispan.client.hotrod.filter.Filters;
import org.infinispan.client.hotrod.impl.ClientStatistics;
import org.infinispan.client.hotrod.impl.ConfigurationProperties;
import org.infinispan.client.hotrod.impl.RemoteCacheSupport;
import org.infinispan.client.hotrod.impl.ServerStatisticsImpl;
import org.infinispan.client.hotrod.impl.StreamingRemoteCacheImpl;
import org.infinispan.client.hotrod.impl.Util;
import org.infinispan.client.hotrod.impl.VersionedValueImpl;
import org.infinispan.client.hotrod.impl.iteration.RemoteCloseableIterator;
import org.infinispan.client.hotrod.impl.operations.AddClientListenerOperation;
import org.infinispan.client.hotrod.impl.operations.ClearOperation;
import org.infinispan.client.hotrod.impl.operations.ContainsKeyOperation;
import org.infinispan.client.hotrod.impl.operations.ExecuteOperation;
import org.infinispan.client.hotrod.impl.operations.GetAllParallelOperation;
import org.infinispan.client.hotrod.impl.operations.GetOperation;
import org.infinispan.client.hotrod.impl.operations.GetWithMetadataOperation;
import org.infinispan.client.hotrod.impl.operations.GetWithVersionOperation;
import org.infinispan.client.hotrod.impl.operations.OperationsFactory;
import org.infinispan.client.hotrod.impl.operations.PingResponse;
import org.infinispan.client.hotrod.impl.operations.PutAllParallelOperation;
import org.infinispan.client.hotrod.impl.operations.PutIfAbsentOperation;
import org.infinispan.client.hotrod.impl.operations.PutOperation;
import org.infinispan.client.hotrod.impl.operations.RemoveClientListenerOperation;
import org.infinispan.client.hotrod.impl.operations.RemoveIfUnmodifiedOperation;
import org.infinispan.client.hotrod.impl.operations.RemoveOperation;
import org.infinispan.client.hotrod.impl.operations.ReplaceIfUnmodifiedOperation;
import org.infinispan.client.hotrod.impl.operations.ReplaceOperation;
import org.infinispan.client.hotrod.impl.operations.SizeOperation;
import org.infinispan.client.hotrod.impl.operations.StatsOperation;
import org.infinispan.client.hotrod.jmx.RemoteCacheClientStatisticsMXBean;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CloseableIteratorCollection;
import org.infinispan.commons.util.CloseableIteratorSet;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IteratorMapper;
import org.infinispan.commons.util.RemovableCloseableIterator;
import org.infinispan.query.dsl.Query;

public class RemoteCacheImpl<K, V>
extends RemoteCacheSupport<K, V> {
    private static final Log log = LogFactory.getLog(RemoteCacheImpl.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private Marshaller defaultMarshaller;
    private final String name;
    private final RemoteCacheManager remoteCacheManager;
    protected OperationsFactory operationsFactory;
    private int estimateKeySize;
    private int estimateValueSize;
    private int batchSize;
    private volatile boolean isObjectStorage;
    private final DataFormat defaultDataFormat;
    private DataFormat dataFormat;
    protected ClientStatistics clientStatistics;
    private ObjectName mbeanObjectName;

    public RemoteCacheImpl(RemoteCacheManager rcm, String name, TimeService timeService) {
        if (trace) {
            log.tracef("Creating remote cache: %s", name);
        }
        this.name = name;
        this.remoteCacheManager = rcm;
        this.defaultDataFormat = DataFormat.builder().build();
        this.clientStatistics = new ClientStatistics(rcm.getConfiguration().statistics().enabled(), timeService);
    }

    protected RemoteCacheImpl(RemoteCacheManager rcm, String name, ClientStatistics clientStatistics) {
        if (trace) {
            log.tracef("Creating remote cache: %s", name);
        }
        this.name = name;
        this.remoteCacheManager = rcm;
        this.defaultDataFormat = DataFormat.builder().build();
        this.clientStatistics = clientStatistics;
    }

    public void init(Marshaller marshaller, OperationsFactory operationsFactory, int estimateKeySize, int estimateValueSize, int batchSize, ObjectName jmxParent) {
        this.defaultMarshaller = marshaller;
        this.operationsFactory = operationsFactory;
        this.estimateKeySize = estimateKeySize;
        this.estimateValueSize = estimateValueSize;
        this.batchSize = batchSize;
        this.dataFormat = this.defaultDataFormat;
        this.registerMBean(jmxParent);
    }

    public void init(Marshaller marshaller, OperationsFactory operationsFactory, int estimateKeySize, int estimateValueSize, int batchSize) {
        this.defaultMarshaller = marshaller;
        this.operationsFactory = operationsFactory;
        this.estimateKeySize = estimateKeySize;
        this.estimateValueSize = estimateValueSize;
        this.batchSize = batchSize;
        this.dataFormat = this.defaultDataFormat;
    }

    public ClientStatistics getClientStatistics() {
        return this.clientStatistics;
    }

    private void registerMBean(ObjectName jmxParent) {
        StatisticsConfiguration configuration = this.getRemoteCacheManager().getConfiguration().statistics();
        if (configuration.jmxEnabled()) {
            try {
                MBeanServer mbeanServer = configuration.mbeanServerLookup().getMBeanServer();
                String cacheName = this.name.isEmpty() ? "org.infinispan.default" : this.name;
                this.mbeanObjectName = new ObjectName(String.format("%s:type=HotRodClient,name=%s,cache=%s", jmxParent.getDomain(), configuration.jmxName(), cacheName));
                mbeanServer.registerMBean(this.clientStatistics, this.mbeanObjectName);
            }
            catch (Exception e) {
                throw Log.HOTROD.jmxRegistrationFailure(e);
            }
        }
    }

    private void unregisterMBean() {
        if (this.mbeanObjectName != null) {
            try {
                MBeanServer mBeanServer = this.getRemoteCacheManager().getConfiguration().statistics().mbeanServerLookup().getMBeanServer();
                if (mBeanServer.isRegistered(this.mbeanObjectName)) {
                    mBeanServer.unregisterMBean(this.mbeanObjectName);
                } else {
                    Log.HOTROD.debugf("MBean not registered: %s", this.mbeanObjectName);
                }
            }
            catch (Exception e) {
                throw Log.HOTROD.jmxUnregistrationFailure(e);
            }
        }
    }

    public OperationsFactory getOperationsFactory() {
        return this.operationsFactory;
    }

    @Override
    public RemoteCacheManager getRemoteCacheManager() {
        return this.remoteCacheManager;
    }

    @Override
    public boolean removeWithVersion(K key, long version) {
        return Util.await(this.removeWithVersionAsync(key, version));
    }

    @Override
    public CompletableFuture<Boolean> removeWithVersionAsync(K key, long version) {
        this.assertRemoteCacheManagerIsStarted();
        RemoveIfUnmodifiedOperation op = this.operationsFactory.newRemoveIfUnmodifiedOperation(this.keyAsObjectIfNeeded(key), this.keyToBytes(key), version, this.dataFormat);
        return op.execute().thenApply(response -> response.getCode().isUpdated());
    }

    @Override
    public boolean replaceWithVersion(K key, V newValue, long version, int lifespanSeconds, int maxIdleTimeSeconds) {
        return this.replaceWithVersion(key, newValue, version, lifespanSeconds, TimeUnit.SECONDS, maxIdleTimeSeconds, TimeUnit.SECONDS);
    }

    @Override
    public boolean replaceWithVersion(K key, V newValue, long version, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        return Util.await(this.replaceWithVersionAsync(key, newValue, version, lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit));
    }

    @Override
    public CompletableFuture<Boolean> replaceWithVersionAsync(K key, V newValue, long version, int lifespanSeconds, int maxIdleSeconds) {
        return this.replaceWithVersionAsync(key, newValue, version, lifespanSeconds, TimeUnit.SECONDS, maxIdleSeconds, TimeUnit.SECONDS);
    }

    public CompletableFuture<Boolean> replaceWithVersionAsync(K key, V newValue, long version, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        this.assertRemoteCacheManagerIsStarted();
        ReplaceIfUnmodifiedOperation op = this.operationsFactory.newReplaceIfUnmodifiedOperation(this.keyAsObjectIfNeeded(key), this.keyToBytes(key), this.valueToBytes(newValue), lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit, version, this.dataFormat);
        return op.execute().thenApply(response -> response.getCode().isUpdated());
    }

    @Override
    public CloseableIterator<Map.Entry<Object, Object>> retrieveEntries(String filterConverterFactory, Object[] filterConverterParams, Set<Integer> segments, int batchSize) {
        this.assertRemoteCacheManagerIsStarted();
        if (segments != null && segments.isEmpty()) {
            return Closeables.iterator(Collections.emptyIterator());
        }
        byte[][] params = this.marshallParams(filterConverterParams);
        RemoteCloseableIterator<Object> remoteCloseableIterator = new RemoteCloseableIterator<Object>(this.operationsFactory, this.defaultMarshaller, filterConverterFactory, params, segments, batchSize, false, this.dataFormat);
        remoteCloseableIterator.start();
        return remoteCloseableIterator;
    }

    @Override
    public CloseableIterator<Map.Entry<Object, Object>> retrieveEntries(String filterConverterFactory, Set<Integer> segments, int batchSize) {
        return this.retrieveEntries(filterConverterFactory, null, segments, batchSize);
    }

    @Override
    public CloseableIterator<Map.Entry<Object, Object>> retrieveEntries(String filterConverterFactory, int batchSize) {
        return this.retrieveEntries(filterConverterFactory, null, batchSize);
    }

    @Override
    public CloseableIterator<Map.Entry<Object, Object>> retrieveEntriesByQuery(Query filterQuery, Set<Integer> segments, int batchSize) {
        Object[] factoryParams = Filters.makeFactoryParams(filterQuery);
        return this.retrieveEntries("iteration-filter-converter-factory", factoryParams, segments, batchSize);
    }

    @Override
    public CloseableIterator<Map.Entry<Object, MetadataValue<Object>>> retrieveEntriesWithMetadata(Set<Integer> segments, int batchSize) {
        RemoteCloseableIterator<MetadataValue<Object>> remoteCloseableIterator = new RemoteCloseableIterator<MetadataValue<Object>>(this.operationsFactory, this.defaultMarshaller, batchSize, segments, true, this.dataFormat);
        remoteCloseableIterator.start();
        return remoteCloseableIterator;
    }

    @Override
    public VersionedValue<V> getVersioned(K key) {
        this.assertRemoteCacheManagerIsStarted();
        if (ConfigurationProperties.isVersionPre12(this.remoteCacheManager.getConfiguration())) {
            GetWithVersionOperation op = this.operationsFactory.newGetWithVersionOperation(this.keyAsObjectIfNeeded(key), this.keyToBytes(key), this.dataFormat);
            return (VersionedValue)Util.await(op.execute());
        }
        MetadataValue<V> result = this.getWithMetadata(key);
        return result != null ? new VersionedValueImpl(result.getVersion(), result.getValue()) : null;
    }

    @Override
    public CompletableFuture<MetadataValue<V>> getWithMetadataAsync(K key) {
        return this.getWithMetadataAsync(key, this.dataFormat);
    }

    @Override
    public MetadataValue<V> getWithMetadata(K key) {
        return Util.await(this.getWithMetadataAsync(key));
    }

    private CompletableFuture<MetadataValue<V>> getWithMetadataAsync(K key, DataFormat dataFormat) {
        this.assertRemoteCacheManagerIsStarted();
        GetWithMetadataOperation op = this.operationsFactory.newGetWithMetadataOperation(this.keyAsObjectIfNeeded(key), this.keyToBytes(key), dataFormat);
        return op.execute();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Util.await(this.putAllAsync(map, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    @Override
    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.assertRemoteCacheManagerIsStarted();
        if (trace) {
            log.tracef("About to putAll entries (%s) lifespan:%d (%s), maxIdle:%d (%s)", new Object[]{map, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit});
        }
        HashMap<byte[], byte[]> byteMap = new HashMap<byte[], byte[]>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            byteMap.put(this.keyToBytes(entry.getKey()), this.valueToBytes(entry.getValue()));
        }
        PutAllParallelOperation op = this.operationsFactory.newPutAllOperation(byteMap, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit, this.dataFormat);
        return op.execute();
    }

    public int size() {
        long size = Util.await(this.sizeAsync());
        return size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size;
    }

    public CompletableFuture<Long> sizeAsync() {
        this.assertRemoteCacheManagerIsStarted();
        SizeOperation op = this.operationsFactory.newSizeOperation();
        return op.execute().thenApply(Integer::longValue);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public RemoteCacheClientStatisticsMXBean clientStatistics() {
        return this.clientStatistics;
    }

    @Override
    public ServerStatistics serverStatistics() {
        this.assertRemoteCacheManagerIsStarted();
        StatsOperation op = this.operationsFactory.newStatsOperation();
        Map statsMap = (Map)Util.await(op.execute());
        ServerStatisticsImpl stats = new ServerStatisticsImpl();
        for (Map.Entry entry : statsMap.entrySet()) {
            stats.addStats((String)entry.getKey(), (String)entry.getValue());
        }
        return stats;
    }

    @Override
    public V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return Util.await(this.putAsync(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    K keyAsObjectIfNeeded(Object key) {
        return (K)(this.isObjectStorage ? key : null);
    }

    @Override
    public V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return Util.await(this.putIfAbsentAsync(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    @Override
    public V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return Util.await(this.replaceAsync(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    @Override
    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        MetadataValue<V> versionedValue = this.getWithMetadata(key);
        return versionedValue != null && versionedValue.getValue().equals(oldValue) && this.replaceWithVersion(key, value, versionedValue.getVersion(), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.assertRemoteCacheManagerIsStarted();
        if (trace) {
            log.tracef("About to add (K,V): (%s, %s) lifespan:%d, maxIdle:%d", new Object[]{key, value, lifespan, maxIdleTime});
        }
        PutOperation op = this.operationsFactory.newPutKeyValueOperation(this.keyAsObjectIfNeeded(key), this.keyToBytes(key), this.valueToBytes(value), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit, this.dataFormat);
        return op.execute();
    }

    public CompletableFuture<Void> clearAsync() {
        this.assertRemoteCacheManagerIsStarted();
        ClearOperation op = this.operationsFactory.newClearOperation();
        return op.execute();
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return Util.await(this.computeAsync(key, remappingFunction, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit));
    }

    @Override
    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        CompletableFuture<MetadataValue<V>> cf = this.getWithMetadataAsync(key);
        return cf.thenCompose(metadataValue -> {
            long version;
            Object oldValue;
            if (metadataValue != null) {
                oldValue = metadataValue.getValue();
                version = metadataValue.getVersion();
            } else {
                oldValue = null;
                version = -1L;
            }
            Object newValue = remappingFunction.apply((K)key, (V)oldValue);
            CompletionStage<Boolean> doneStage = newValue != null ? (oldValue != null ? this.replaceWithVersionAsync(key, newValue, version, lifespan, lifespanUnit, maxIdle, maxIdleUnit) : this.putIfAbsentAsync(key, newValue, lifespan, lifespanUnit, maxIdle, maxIdleUnit).thenApply(Objects::isNull)) : (oldValue != null ? this.removeWithVersionAsync(key, version) : CompletableFuture.completedFuture(Boolean.TRUE));
            return doneStage.thenCompose(done -> {
                if (done.booleanValue()) {
                    return CompletableFuture.completedFuture(newValue);
                }
                return this.computeAsync(key, remappingFunction, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
            });
        });
    }

    @Override
    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.assertRemoteCacheManagerIsStarted();
        PutIfAbsentOperation op = this.operationsFactory.newPutIfAbsentOperation(this.keyAsObjectIfNeeded(key), this.keyToBytes(key), this.valueToBytes(value), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit, this.dataFormat);
        return op.execute();
    }

    public CompletableFuture<V> removeAsync(Object key) {
        this.assertRemoteCacheManagerIsStarted();
        RemoveOperation removeOperation = this.operationsFactory.newRemoveOperation(this.keyAsObjectIfNeeded(key), this.keyToBytes(key), this.dataFormat);
        return removeOperation.execute();
    }

    @Override
    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.assertRemoteCacheManagerIsStarted();
        ReplaceOperation op = this.operationsFactory.newReplaceOperation(this.keyAsObjectIfNeeded(key), this.keyToBytes(key), this.valueToBytes(value), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit, this.dataFormat);
        return op.execute();
    }

    public boolean containsKey(Object key) {
        this.assertRemoteCacheManagerIsStarted();
        ContainsKeyOperation op = this.operationsFactory.newContainsKeyOperation(this.keyAsObjectIfNeeded(key), this.keyToBytes(key), this.dataFormat);
        return (Boolean)Util.await(op.execute());
    }

    public boolean containsValue(Object value) {
        Objects.requireNonNull(value);
        return this.values().contains(value);
    }

    public V get(Object key) {
        return Util.await(this.getAsync(key));
    }

    @Override
    public Map<K, V> getAll(Set<? extends K> keys) {
        this.assertRemoteCacheManagerIsStarted();
        if (trace) {
            log.tracef("About to getAll entries (%s)", keys);
        }
        HashSet<byte[]> byteKeys = new HashSet<byte[]>(keys.size());
        for (K key : keys) {
            byteKeys.add(this.keyToBytes(key));
        }
        GetAllParallelOperation op = this.operationsFactory.newGetAllOperation(byteKeys, this.dataFormat);
        return (Map)Util.await(op.execute().thenApply(Collections::unmodifiableMap));
    }

    @Override
    public V remove(Object key) {
        return Util.await(this.removeAsync(key));
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.removeEntry(key, value);
    }

    public void clear() {
        Util.await(this.clearAsync());
    }

    public void start() {
        if (log.isDebugEnabled()) {
            log.debugf("Start called, nothing to do here(%s)", this.getName());
        }
    }

    public void stop() {
        this.unregisterMBean();
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return RemoteCacheImpl.class.getPackage().getImplementationVersion();
    }

    @Override
    public String getProtocolVersion() {
        return "HotRod client, protocol version: " + (Object)((Object)ProtocolVersion.DEFAULT_PROTOCOL_VERSION);
    }

    @Override
    public void addClientListener(Object listener) {
        this.assertRemoteCacheManagerIsStarted();
        AddClientListenerOperation op = this.operationsFactory.newAddClientListenerOperation(listener, this.dataFormat);
        Util.await(op.execute());
    }

    @Override
    public void addClientListener(Object listener, Object[] filterFactoryParams, Object[] converterFactoryParams) {
        this.assertRemoteCacheManagerIsStarted();
        byte[][] marshalledFilterParams = this.marshallParams(filterFactoryParams);
        byte[][] marshalledConverterParams = this.marshallParams(converterFactoryParams);
        AddClientListenerOperation op = this.operationsFactory.newAddClientListenerOperation(listener, marshalledFilterParams, marshalledConverterParams, this.dataFormat);
        Util.await(op.execute());
    }

    private byte[][] marshallParams(Object[] params) {
        if (params == null) {
            return org.infinispan.commons.util.Util.EMPTY_BYTE_ARRAY_ARRAY;
        }
        byte[][] marshalledParams = new byte[params.length][];
        for (int i = 0; i < marshalledParams.length; ++i) {
            byte[] bytes = this.keyToBytes(params[i]);
            marshalledParams[i] = bytes;
        }
        return marshalledParams;
    }

    @Override
    public void removeClientListener(Object listener) {
        this.assertRemoteCacheManagerIsStarted();
        RemoveClientListenerOperation op = this.operationsFactory.newRemoveClientListenerOperation(listener);
        Util.await(op.execute());
    }

    @Override
    @Deprecated
    public Set<Object> getListeners() {
        ClientListenerNotifier listenerNotifier = this.operationsFactory.getListenerNotifier();
        return listenerNotifier.getListeners(this.operationsFactory.getCacheName());
    }

    @Override
    public RemoteCache<K, V> withFlags(Flag ... flags) {
        this.operationsFactory.setFlags(flags);
        return this;
    }

    public CompletableFuture<V> getAsync(Object key) {
        this.assertRemoteCacheManagerIsStarted();
        byte[] keyBytes = this.keyToBytes(key);
        GetOperation gco = this.operationsFactory.newGetKeyOperation(this.keyAsObjectIfNeeded(key), keyBytes, this.dataFormat);
        CompletableFuture result = gco.execute();
        if (trace) {
            result.thenAccept(value -> log.tracef("For key(%s) returning %s", key, value));
        }
        return result;
    }

    public PingResponse ping() {
        return (PingResponse)Util.await(this.operationsFactory.newFaultTolerantPingOperation().execute());
    }

    protected byte[] keyToBytes(Object o) {
        return this.dataFormat.keyToBytes(o, this.estimateKeySize, this.estimateValueSize);
    }

    protected byte[] valueToBytes(Object o) {
        return this.dataFormat.valueToBytes(o, this.estimateKeySize, this.estimateValueSize);
    }

    protected void assertRemoteCacheManagerIsStarted() {
        if (!this.remoteCacheManager.isStarted()) {
            String message = "Cannot perform operations on a cache associated with an unstarted RemoteCacheManager. Use RemoteCacheManager.start before using the remote cache.";
            Log.HOTROD.unstartedRemoteCacheManager();
            throw new RemoteCacheManagerNotStartedException(message);
        }
    }

    @Override
    protected void set(K key, V value) {
        this.put(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    @Override
    public CloseableIteratorSet<K> keySet() {
        return this.keySet(null);
    }

    @Override
    public CloseableIteratorSet<K> keySet(IntSet segments) {
        return new KeySet(segments);
    }

    @Override
    public CloseableIteratorSet<Map.Entry<K, V>> entrySet() {
        return this.entrySet(null);
    }

    @Override
    public CloseableIteratorSet<Map.Entry<K, V>> entrySet(IntSet segments) {
        return new EntrySet(segments);
    }

    @Override
    public CloseableIteratorCollection<V> values() {
        return this.values(null);
    }

    @Override
    public CloseableIteratorCollection<V> values(IntSet segments) {
        return new ValuesCollection(segments);
    }

    private boolean removeEntry(Map.Entry<K, V> entry) {
        return this.removeEntry(entry.getKey(), entry.getValue());
    }

    private boolean removeEntry(K key, V value) {
        MetadataValue<V> versionedValue = this.getWithMetadata(key);
        return versionedValue != null && value.equals(versionedValue.getValue()) && this.removeWithVersion(key, versionedValue.getVersion());
    }

    @Override
    public <T> T execute(String taskName, Map<String, ?> params) {
        return this.execute(taskName, params, null);
    }

    @Override
    public <T> T execute(String taskName, Map<String, ?> params, Object key) {
        this.assertRemoteCacheManagerIsStarted();
        HashMap<String, byte[]> marshalledParams = new HashMap<String, byte[]>();
        if (params != null) {
            for (Map.Entry<String, ?> entry : params.entrySet()) {
                marshalledParams.put(entry.getKey(), this.keyToBytes(entry.getValue()));
            }
        }
        Object keyHint = null;
        if (key != null) {
            keyHint = this.isObjectStorage ? key : (Object)this.keyToBytes(key);
        }
        ExecuteOperation op = this.operationsFactory.newExecuteOperation(taskName, marshalledParams, keyHint, this.dataFormat);
        return Util.await(op.execute());
    }

    @Override
    public CacheTopologyInfo getCacheTopologyInfo() {
        return this.operationsFactory.getCacheTopologyInfo();
    }

    @Override
    public StreamingRemoteCache<K> streaming() {
        this.assertRemoteCacheManagerIsStarted();
        return new StreamingRemoteCacheImpl(this);
    }

    @Override
    public <T, U> RemoteCache<T, U> withDataFormat(DataFormat newDataFormat) {
        newDataFormat = Objects.requireNonNull(newDataFormat, "Data Format must not be null");
        newDataFormat.initialize(this.remoteCacheManager, this.isObjectStorage);
        RemoteCacheImpl<T, U> instance = this.newInstance();
        instance.dataFormat = newDataFormat;
        return instance;
    }

    private <T, U> RemoteCacheImpl<T, U> newInstance() {
        RemoteCacheImpl<K, V> copy = new RemoteCacheImpl<K, V>(this.remoteCacheManager, this.name, this.clientStatistics);
        copy.init(this.defaultMarshaller, this.operationsFactory, this.estimateKeySize, this.estimateValueSize, this.batchSize);
        return copy;
    }

    public PingResponse resolveStorage() {
        if (this.remoteCacheManager.isStarted()) {
            PingResponse result = this.ping();
            this.isObjectStorage = this.operationsFactory.getCodec().isObjectStorageHinted(result);
            this.defaultDataFormat.initialize(this.remoteCacheManager, this.isObjectStorage);
            return result;
        }
        return PingResponse.EMPTY;
    }

    @Override
    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    @Override
    public boolean isTransactional() {
        return false;
    }

    public boolean isObjectStorage() {
        return this.isObjectStorage;
    }

    private class ValuesCollection
    extends AbstractCollection<V>
    implements CloseableIteratorCollection<V> {
        private final IntSet segments;

        private ValuesCollection(IntSet segments) {
            this.segments = segments;
        }

        @Override
        public CloseableIterator<V> iterator() {
            CloseableIterator entryIterator = RemoteCacheImpl.this.operationsFactory.getCodec().entryIterator(RemoteCacheImpl.this, this.segments, RemoteCacheImpl.this.batchSize);
            return new IteratorMapper((Iterator)new RemovableCloseableIterator(entryIterator, e -> RemoteCacheImpl.this.remove(e.getKey(), e.getValue())), Map.Entry::getValue);
        }

        @Override
        public CloseableSpliterator<V> spliterator() {
            return Closeables.spliterator(this.iterator(), (long)Long.MAX_VALUE, (int)4352);
        }

        @Override
        public Stream<V> stream() {
            return Closeables.stream(this.spliterator(), (boolean)false);
        }

        @Override
        public Stream<V> parallelStream() {
            return Closeables.stream(this.spliterator(), (boolean)true);
        }

        @Override
        public int size() {
            return RemoteCacheImpl.this.size();
        }

        @Override
        public void clear() {
            RemoteCacheImpl.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            try (Stream stream = this.stream();){
                boolean bl = stream.anyMatch(v -> Objects.deepEquals(v, o));
                return bl;
            }
        }

        @Override
        public boolean remove(Object o) {
            Objects.requireNonNull(o);
            try (CloseableIterator iter = this.iterator();){
                while (iter.hasNext()) {
                    if (!o.equals(iter.next())) continue;
                    iter.remove();
                    boolean bl = true;
                    return bl;
                }
            }
            return false;
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>>
    implements CloseableIteratorSet<Map.Entry<K, V>> {
        private final IntSet segments;

        public EntrySet(IntSet segments) {
            this.segments = segments;
        }

        @Override
        public CloseableIterator<Map.Entry<K, V>> iterator() {
            return new RemovableCloseableIterator(RemoteCacheImpl.this.operationsFactory.getCodec().entryIterator(RemoteCacheImpl.this, this.segments, RemoteCacheImpl.this.batchSize), this::remove);
        }

        @Override
        public CloseableSpliterator<Map.Entry<K, V>> spliterator() {
            return Closeables.spliterator(this.iterator(), (long)Long.MAX_VALUE, (int)4352);
        }

        @Override
        public Stream<Map.Entry<K, V>> stream() {
            return Closeables.stream(this.spliterator(), (boolean)false);
        }

        @Override
        public Stream<Map.Entry<K, V>> parallelStream() {
            return Closeables.stream(this.spliterator(), (boolean)true);
        }

        @Override
        public int size() {
            return RemoteCacheImpl.this.size();
        }

        @Override
        public void clear() {
            RemoteCacheImpl.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            Map.Entry entry = this.toEntry(o);
            if (entry != null) {
                Object value = RemoteCacheImpl.this.get(entry.getKey());
                return value != null && value.equals(entry.getValue());
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            Map.Entry entry = this.toEntry(o);
            return entry != null && RemoteCacheImpl.this.removeEntry(entry);
        }

        private Map.Entry<K, V> toEntry(Object obj) {
            if (obj instanceof Map.Entry) {
                return (Map.Entry)obj;
            }
            return null;
        }
    }

    private class KeySet
    extends AbstractSet<K>
    implements CloseableIteratorSet<K> {
        private final IntSet segments;

        private KeySet(IntSet segments) {
            this.segments = segments;
        }

        @Override
        public CloseableIterator<K> iterator() {
            CloseableIterator keyIterator = RemoteCacheImpl.this.operationsFactory.getCodec().keyIterator(RemoteCacheImpl.this, RemoteCacheImpl.this.operationsFactory, this.segments, RemoteCacheImpl.this.batchSize);
            return new RemovableCloseableIterator(keyIterator, this::remove);
        }

        @Override
        public CloseableSpliterator<K> spliterator() {
            return Closeables.spliterator(this.iterator(), (long)Long.MAX_VALUE, (int)4353);
        }

        @Override
        public Stream<K> stream() {
            return Closeables.stream(this.spliterator(), (boolean)false);
        }

        @Override
        public Stream<K> parallelStream() {
            return Closeables.stream(this.spliterator(), (boolean)true);
        }

        @Override
        public int size() {
            return RemoteCacheImpl.this.size();
        }

        @Override
        public void clear() {
            RemoteCacheImpl.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return RemoteCacheImpl.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return RemoteCacheImpl.this.remove(o) != null;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean removedSomething = false;
            for (Object key : c) {
                removedSomething |= this.remove(key);
            }
            return removedSomething;
        }
    }
}

