/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.query;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.impl.Util;
import org.infinispan.client.hotrod.impl.operations.QueryOperation;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.dsl.IndexedQueryMode;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.impl.BaseQuery;
import org.infinispan.query.remote.client.impl.BaseQueryResponse;

public final class RemoteQuery
extends BaseQuery {
    private final RemoteCacheImpl<?, ?> cache;
    private final SerializationContext serializationContext;
    private final IndexedQueryMode indexedQueryMode;
    private List<?> results = null;
    private int totalResults;

    RemoteQuery(QueryFactory queryFactory, RemoteCacheImpl<?, ?> cache, SerializationContext serializationContext, String queryString, IndexedQueryMode indexQueryMode) {
        super(queryFactory, queryString);
        this.cache = cache;
        this.serializationContext = serializationContext;
        this.indexedQueryMode = indexQueryMode;
    }

    RemoteQuery(QueryFactory queryFactory, RemoteCacheImpl<?, ?> cache, SerializationContext serializationContext, String queryString, Map<String, Object> namedParameters, String[] projection, long startOffset, int maxResults) {
        super(queryFactory, queryString, namedParameters, projection, startOffset, maxResults);
        this.cache = cache;
        this.serializationContext = serializationContext;
        this.indexedQueryMode = null;
    }

    public void resetQuery() {
        this.results = null;
    }

    public <T> List<T> list() {
        this.executeQuery();
        return this.results;
    }

    public int getResultSize() {
        this.executeQuery();
        return this.totalResults;
    }

    private void executeQuery() {
        if (this.results == null) {
            this.validateNamedParameters();
            QueryOperation op = this.cache.getOperationsFactory().newQueryOperation(this, this.cache.getDataFormat());
            BaseQueryResponse response = (BaseQueryResponse)Util.await(op.execute());
            this.totalResults = (int)response.getTotalResults();
            try {
                this.results = response.extractResults(this.serializationContext);
            }
            catch (IOException e) {
                throw new HotRodClientException(e);
            }
        }
    }

    public SerializationContext getSerializationContext() {
        return this.serializationContext;
    }

    public RemoteCache<?, ?> getCache() {
        return this.cache;
    }

    public IndexedQueryMode getIndexedQueryMode() {
        return this.indexedQueryMode;
    }

    public String toString() {
        return "RemoteQuery{queryString=" + this.queryString + ", namedParameters=" + this.namedParameters + ", startOffset=" + this.startOffset + ", maxResults=" + this.maxResults + '}';
    }
}

