package org.infinispan.client.hotrod.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.commons.CacheConfigurationException;
import java.lang.String;
import org.jboss.logging.Logger;
import org.jboss.logging.BasicLogger;
import java.net.SocketAddress;
import org.infinispan.client.hotrod.exceptions.InvalidResponseException;
import java.lang.IllegalArgumentException;
import javax.annotation.Generated;
import org.infinispan.commons.CacheListenerException;
import io.netty.channel.Channel;
import java.lang.SecurityException;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import java.lang.reflect.Method;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.exceptions.CacheNotTransactionalException;
import java.lang.Exception;
import javax.transaction.xa.Xid;
import java.lang.Throwable;
import java.lang.Object;
import org.infinispan.client.hotrod.configuration.ExhaustedAction;
import java.util.Arrays;
import org.infinispan.client.hotrod.event.IncorrectClientListenerException;
import java.util.NoSuchElementException;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2022-09-13T05:13:01-0400")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void couldNotFindPropertiesFile(final String propertiesFile) {
        super.log.logf(FQCN, WARN, null, couldNotFindPropertiesFile$str(), propertiesFile);
    }
    private static final String couldNotFindPropertiesFile = "ISPN004001: Could not find '%s' file in classpath, using defaults.";
    protected String couldNotFindPropertiesFile$str() {
        return couldNotFindPropertiesFile;
    }
    @Override
    public final void unstartedRemoteCacheManager() {
        super.log.logf(FQCN, INFO, null, unstartedRemoteCacheManager$str());
    }
    private static final String unstartedRemoteCacheManager = "ISPN004002: Cannot perform operations on a cache associated with an unstarted RemoteCacheManager. Use RemoteCacheManager.start before using the remote cache.";
    protected String unstartedRemoteCacheManager$str() {
        return unstartedRemoteCacheManager;
    }
    private static final String invalidMagicNumber = "ISPN004003: Invalid magic number. Expected %#x and received %#x";
    protected String invalidMagicNumber$str() {
        return invalidMagicNumber;
    }
    @Override
    public final InvalidResponseException invalidMagicNumber(final short expectedMagicNumber, final short receivedMagic) {
        final InvalidResponseException result = new InvalidResponseException(String.format(getLoggingLocale(), invalidMagicNumber$str(), expectedMagicNumber, receivedMagic));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void errorFromServer(final String message) {
        super.log.logf(FQCN, WARN, null, errorFromServer$str(), message);
    }
    private static final String errorFromServer = "ISPN004005: Error received from the server: %s";
    protected String errorFromServer$str() {
        return errorFromServer;
    }
    @Override
    public final void newTopology(final int viewId, final int age, final int topologySize, final java.util.Collection<? extends SocketAddress> addresses) {
        super.log.logf(FQCN, INFO, null, newTopology$str(), viewId, age, topologySize, addresses);
    }
    private static final String newTopology = "ISPN004006: Server sent new topology view (id=%d, age=%d) containing %d addresses: %s";
    protected String newTopology$str() {
        return newTopology;
    }
    @Override
    public final void exceptionAndNoRetriesLeft(final int retry, final int maxRetries, final Throwable te) {
        super.log.logf(FQCN, ERROR, te, exceptionAndNoRetriesLeft$str(), retry, maxRetries);
    }
    private static final String exceptionAndNoRetriesLeft = "ISPN004007: Exception encountered. Retry %d out of %d";
    protected String exceptionAndNoRetriesLeft$str() {
        return exceptionAndNoRetriesLeft;
    }
    @Override
    public final void noHasHFunctionConfigured(final int hashFunctionVersion) {
        super.log.logf(FQCN, WARN, null, noHasHFunctionConfigured$str(), hashFunctionVersion);
    }
    private static final String noHasHFunctionConfigured = "ISPN004011: No hash function configured for version: %d";
    protected String noHasHFunctionConfigured$str() {
        return noHasHFunctionConfigured;
    }
    @Override
    public final void newServerAdded(final SocketAddress server) {
        super.log.logf(FQCN, INFO, null, newServerAdded$str(), server);
    }
    private static final String newServerAdded = "ISPN004014: New server added(%s), adding to the pool.";
    protected String newServerAdded$str() {
        return newServerAdded;
    }
    @Override
    public final void failedAddingNewServer(final SocketAddress server, final Throwable e) {
        super.log.logf(FQCN, WARN, e, failedAddingNewServer$str(), server);
    }
    private static final String failedAddingNewServer = "ISPN004015: Failed adding new server %s";
    protected String failedAddingNewServer$str() {
        return failedAddingNewServer;
    }
    @Override
    public final void removingServer(final SocketAddress server) {
        super.log.logf(FQCN, INFO, null, removingServer$str(), server);
    }
    private static final String removingServer = "ISPN004016: Server not in cluster anymore(%s), removing from the pool.";
    protected String removingServer$str() {
        return removingServer;
    }
    @Override
    public final void version(final String version) {
        super.log.logf(FQCN, INFO, null, version$str(), version);
    }
    private static final String version = "ISPN004021: Infinispan version: %s";
    protected String version$str() {
        return version;
    }
    private static final String noSSLTrustManagerConfiguration = "ISPN004024: SSL Enabled but no TrustStore specified";
    protected String noSSLTrustManagerConfiguration$str() {
        return noSSLTrustManagerConfiguration;
    }
    @Override
    public final CacheConfigurationException noSSLTrustManagerConfiguration() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), noSSLTrustManagerConfiguration$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingKeyStorePassword = "ISPN004025: A password is required to open the KeyStore '%s'";
    protected String missingKeyStorePassword$str() {
        return missingKeyStorePassword;
    }
    @Override
    public final CacheConfigurationException missingKeyStorePassword(final String keyStore) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingKeyStorePassword$str(), keyStore));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingTrustStorePassword = "ISPN004026: A password is required to open the TrustStore '%s'";
    protected String missingTrustStorePassword$str() {
        return missingTrustStorePassword;
    }
    @Override
    public final CacheConfigurationException missingTrustStorePassword(final String trustStore) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingTrustStorePassword$str(), trustStore));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xorSSLContext = "ISPN004027: Cannot configure custom KeyStore and/or TrustStore when specifying a SSLContext";
    protected String xorSSLContext$str() {
        return xorSSLContext;
    }
    @Override
    public final CacheConfigurationException xorSSLContext() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), xorSSLContext$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String parseErrorServerAddress = "ISPN004028: Unable to parse server IP address %s";
    protected String parseErrorServerAddress$str() {
        return parseErrorServerAddress;
    }
    @Override
    public final CacheConfigurationException parseErrorServerAddress(final String server) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), parseErrorServerAddress$str(), server));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidMaxRetries = "ISPN004029: Invalid max_retries (value=%s). Value should be greater or equal than zero.";
    protected String invalidMaxRetries$str() {
        return invalidMaxRetries;
    }
    @Override
    public final CacheConfigurationException invalidMaxRetries(final int retriesPerServer) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidMaxRetries$str(), retriesPerServer));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidAuthenticationConfiguration = "ISPN004030: Cannot enable authentication without specifying either a username, a token, a client Subject or a CallbackHandler";
    protected String invalidAuthenticationConfiguration$str() {
        return invalidAuthenticationConfiguration;
    }
    @Override
    public final CacheConfigurationException invalidAuthenticationConfiguration() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidAuthenticationConfiguration$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedMech = "ISPN004031: The selected authentication mechanism '%s' is not among the supported server mechanisms: %s";
    protected String unsupportedMech$str() {
        return unsupportedMech;
    }
    @Override
    public final SecurityException unsupportedMech(final String authMech, final java.util.List<String> serverMechs) {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), unsupportedMech$str(), authMech, serverMechs));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToUnmarshallBytes = "ISPN004034: Unable to unmarshall bytes %s";
    protected String unableToUnmarshallBytes$str() {
        return unableToUnmarshallBytes;
    }
    @Override
    public final HotRodClientException unableToUnmarshallBytes(final String bytes, final Exception e) {
        final HotRodClientException result = new HotRodClientException(String.format(getLoggingLocale(), unableToUnmarshallBytes$str(), bytes), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String exceptionInvokingListener = "ISPN004035: Caught exception [%s] while invoking method [%s] on listener instance: %s";
    protected String exceptionInvokingListener$str() {
        return exceptionInvokingListener;
    }
    @Override
    public final CacheListenerException exceptionInvokingListener(final String name, final Method m, final Object target, final Throwable cause) {
        final CacheListenerException result = new CacheListenerException(String.format(getLoggingLocale(), exceptionInvokingListener$str(), name, m, target), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String incorrectClientListener2 = "ISPN004036: Methods annotated with %s must accept exactly one parameter, of assignable from type %s";
    protected String incorrectClientListener2$str() {
        return incorrectClientListener2;
    }
    @Override
    public final IncorrectClientListenerException incorrectClientListener(final String annotationName, final java.util.Collection<?> allowedParameters) {
        final IncorrectClientListenerException result = new IncorrectClientListenerException(String.format(getLoggingLocale(), incorrectClientListener2$str(), annotationName, allowedParameters));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String incorrectClientListener1 = "ISPN004037: Methods annotated with %s should have a return type of void.";
    protected String incorrectClientListener1$str() {
        return incorrectClientListener1;
    }
    @Override
    public final IncorrectClientListenerException incorrectClientListener(final String annotationName) {
        final IncorrectClientListenerException result = new IncorrectClientListenerException(String.format(getLoggingLocale(), incorrectClientListener1$str(), annotationName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void unexpectedErrorConsumingEvent(final Object event, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unexpectedErrorConsumingEvent$str(), event);
    }
    private static final String unexpectedErrorConsumingEvent = "ISPN004038: Unexpected error consuming event %s";
    protected String unexpectedErrorConsumingEvent$str() {
        return unexpectedErrorConsumingEvent;
    }
    @Override
    public final void unableToReadEventFromServer(final Throwable t, final SocketAddress server) {
        super.log.logf(FQCN, WARN, t, unableToReadEventFromServer$str(), server);
    }
    private static final String unableToReadEventFromServer = "ISPN004039: Unable to complete reading event from server %s";
    protected String unableToReadEventFromServer$str() {
        return unableToReadEventFromServer;
    }
    private static final String missingClientListenerAnnotation = "ISPN004040: Cache listener class %s must be annotated with org.infinispan.client.hotrod.annotation.ClientListener";
    protected String missingClientListenerAnnotation$str() {
        return missingClientListenerAnnotation;
    }
    @Override
    public final IncorrectClientListenerException missingClientListenerAnnotation(final String className) {
        final IncorrectClientListenerException result = new IncorrectClientListenerException(String.format(getLoggingLocale(), missingClientListenerAnnotation$str(), className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownEvent = "ISPN004041: Unknown event type %s received";
    protected String unknownEvent$str() {
        return unknownEvent;
    }
    @Override
    public final HotRodClientException unknownEvent(final short eventTypeId) {
        final HotRodClientException result = new HotRodClientException(String.format(getLoggingLocale(), unknownEvent$str(), eventTypeId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void unableToSetAccesible(final Method m, final Exception e) {
        super.log.logf(FQCN, ERROR, e, unableToSetAccesible$str(), m);
    }
    private static final String unableToSetAccesible = "ISPN004042: Unable to set method %s accessible";
    protected String unableToSetAccesible$str() {
        return unableToSetAccesible;
    }
    private static final String nearCacheMaxEntriesUndefined = "ISPN004045: When enabling near caching, number of max entries must be configured";
    protected String nearCacheMaxEntriesUndefined$str() {
        return nearCacheMaxEntriesUndefined;
    }
    @Override
    public final CacheConfigurationException nearCacheMaxEntriesUndefined() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), nearCacheMaxEntriesUndefined$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void iterationClosed(final String iterationId) {
        super.log.logf(FQCN, DEBUG, null, iterationClosed$str(), iterationId);
    }
    private static final String iterationClosed = "ISPN004046: Successfully closed remote iterator '%s'";
    protected String iterationClosed$str() {
        return iterationClosed;
    }
    private static final String errorClosingIteration = "ISPN004047: Invalid iteration id '%s'";
    protected String errorClosingIteration$str() {
        return errorClosingIteration;
    }
    @Override
    public final IllegalStateException errorClosingIteration(final String iterationId) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), errorClosingIteration$str(), iterationId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorRetrievingNext = "ISPN004048: Invalid iteration id '%s'";
    protected String errorRetrievingNext$str() {
        return errorRetrievingNext;
    }
    @Override
    public final NoSuchElementException errorRetrievingNext(final String iterationId) {
        final NoSuchElementException result = new NoSuchElementException(String.format(getLoggingLocale(), errorRetrievingNext$str(), iterationId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void switchedToCluster(final String clusterName) {
        super.log.logf(FQCN, INFO, null, switchedToCluster$str(), clusterName);
    }
    private static final String switchedToCluster = "ISPN004050: Switched to cluster '%s'";
    protected String switchedToCluster$str() {
        return switchedToCluster;
    }
    @Override
    public final void switchedBackToMainCluster() {
        super.log.logf(FQCN, INFO, null, switchedBackToMainCluster$str());
    }
    private static final String switchedBackToMainCluster = "ISPN004051: Switched back to main cluster";
    protected String switchedBackToMainCluster$str() {
        return switchedBackToMainCluster;
    }
    @Override
    public final void manuallySwitchedToCluster(final String clusterName) {
        super.log.logf(FQCN, INFO, null, manuallySwitchedToCluster$str(), clusterName);
    }
    private static final String manuallySwitchedToCluster = "ISPN004052: Manually switched to cluster '%s'";
    protected String manuallySwitchedToCluster$str() {
        return manuallySwitchedToCluster;
    }
    @Override
    public final void manuallySwitchedBackToMainCluster() {
        super.log.logf(FQCN, INFO, null, manuallySwitchedBackToMainCluster$str());
    }
    private static final String manuallySwitchedBackToMainCluster = "ISPN004053: Manually switched back to main cluster";
    protected String manuallySwitchedBackToMainCluster$str() {
        return manuallySwitchedBackToMainCluster;
    }
    private static final String missingClusterNameDefinition = "ISPN004054: Name of the failover cluster needs to be specified";
    protected String missingClusterNameDefinition$str() {
        return missingClusterNameDefinition;
    }
    @Override
    public final CacheConfigurationException missingClusterNameDefinition() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingClusterNameDefinition$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingHostDefinition = "ISPN004055: Host needs to be specified in server definition of failover cluster";
    protected String missingHostDefinition$str() {
        return missingHostDefinition;
    }
    @Override
    public final CacheConfigurationException missingHostDefinition() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingHostDefinition$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingClusterServersDefinition = "ISPN004056: At least one server address needs to be specified for failover cluster %s";
    protected String missingClusterServersDefinition$str() {
        return missingClusterServersDefinition;
    }
    @Override
    public final CacheConfigurationException missingClusterServersDefinition(final String siteName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), missingClusterServersDefinition$str(), siteName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateClusterDefinition = "ISPN004057: Duplicate failover cluster %s has been specified";
    protected String duplicateClusterDefinition$str() {
        return duplicateClusterDefinition;
    }
    @Override
    public final CacheConfigurationException duplicateClusterDefinition(final String siteName) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), duplicateClusterDefinition$str(), siteName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String clientListenerMustUseRawData = "ISPN004058: The client listener must use raw data when it uses a query as a filter: %s";
    protected String clientListenerMustUseRawData$str() {
        return clientListenerMustUseRawData;
    }
    @Override
    public final IncorrectClientListenerException clientListenerMustUseRawData(final String className) {
        final IncorrectClientListenerException result = new IncorrectClientListenerException(String.format(getLoggingLocale(), clientListenerMustUseRawData$str(), className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String clientListenerMustUseDesignatedFilterConverterFactory = "ISPN004059: The client listener must use the '%s' filter/converter factory";
    protected String clientListenerMustUseDesignatedFilterConverterFactory$str() {
        return clientListenerMustUseDesignatedFilterConverterFactory;
    }
    @Override
    public final IncorrectClientListenerException clientListenerMustUseDesignatedFilterConverterFactory(final String filterConverterFactoryName) {
        final IncorrectClientListenerException result = new IncorrectClientListenerException(String.format(getLoggingLocale(), clientListenerMustUseDesignatedFilterConverterFactory$str(), filterConverterFactoryName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void ignoringErrorDuringIterationClose(final String iterationId, final Throwable e) {
        super.log.logf(FQCN, WARN, e, ignoringErrorDuringIterationClose$str(), iterationId);
    }
    private static final String ignoringErrorDuringIterationClose = "ISPN004061: Ignoring error when closing iteration '%s'";
    protected String ignoringErrorDuringIterationClose$str() {
        return ignoringErrorDuringIterationClose;
    }
    @Override
    public final void startedIteration(final String iterationId) {
        super.log.logf(FQCN, DEBUG, null, startedIteration$str(), iterationId);
    }
    private static final String startedIteration = "ISPN004062: Started iteration '%s'";
    protected String startedIteration$str() {
        return startedIteration;
    }
    @Override
    public final void iterationTransportObtained(final SocketAddress address, final String iterationId) {
        super.log.logf(FQCN, DEBUG, null, iterationTransportObtained$str(), address, iterationId);
    }
    private static final String iterationTransportObtained = "ISPN004063: Channel to %s obtained for iteration '%s'";
    protected String iterationTransportObtained$str() {
        return iterationTransportObtained;
    }
    @Override
    public final void trackingSegmentKey(final String key, final int segment, final boolean isTracked) {
        super.log.logf(FQCN, TRACE, null, trackingSegmentKey$str(), key, segment, isTracked);
    }
    private static final String trackingSegmentKey = "ISPN004064: Tracking key %s belonging to segment %d, already tracked? = %b";
    protected String trackingSegmentKey$str() {
        return trackingSegmentKey;
    }
    private static final String callbackHandlerAndUsernameMutuallyExclusive = "ISPN004067: Cannot specify both a callback handler and a username/token for authentication";
    protected String callbackHandlerAndUsernameMutuallyExclusive$str() {
        return callbackHandlerAndUsernameMutuallyExclusive;
    }
    @Override
    public final CacheConfigurationException callbackHandlerAndUsernameMutuallyExclusive() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), callbackHandlerAndUsernameMutuallyExclusive$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String channelInactive = "ISPN004069: Connection to %s is not active.";
    protected String channelInactive$str() {
        return channelInactive;
    }
    @Override
    public final TransportException channelInactive(final SocketAddress address1, final SocketAddress address2) {
        final TransportException result = new TransportException(String.format(getLoggingLocale(), channelInactive$str(), address2), address1);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToAddListener = "ISPN004070: Failed to add client listener %s, server responded with status %d";
    protected String failedToAddListener$str() {
        return failedToAddListener;
    }
    @Override
    public final HotRodClientException failedToAddListener(final Object listener, final short status) {
        final HotRodClientException result = new HotRodClientException(String.format(getLoggingLocale(), failedToAddListener$str(), listener, status));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String connectionClosed = "ISPN004071: Connection to %s was closed while waiting for response.";
    protected String connectionClosed$str() {
        return connectionClosed;
    }
    @Override
    public final TransportException connectionClosed(final SocketAddress address1, final SocketAddress address2) {
        final TransportException result = new TransportException(String.format(getLoggingLocale(), connectionClosed$str(), address2), address1);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void cannotCreateAsyncThread(final int maxPoolSize) {
        super.log.logf(FQCN, ERROR, null, cannotCreateAsyncThread$str(), maxPoolSize);
    }
    private static final String cannotCreateAsyncThread = "ISPN004072: Cannot create another async thread. Please increase 'infinispan.client.hotrod.default_executor_factory.pool_size' (current value is %d).";
    protected String cannotCreateAsyncThread$str() {
        return cannotCreateAsyncThread;
    }
    @Override
    public final void epollNotAvailable(final String cause) {
        super.log.logf(FQCN, INFO, null, epollNotAvailable$str(), cause);
    }
    private static final String epollNotAvailable = "ISPN004074: Native Epoll transport not available, using NIO instead: %s";
    protected String epollNotAvailable$str() {
        return epollNotAvailable;
    }
    private static final String trustStoreFileAndPathExclusive = "ISPN004075: TrustStoreFileName and TrustStorePath are mutually exclusive";
    protected String trustStoreFileAndPathExclusive$str() {
        return trustStoreFileAndPathExclusive;
    }
    @Override
    public final CacheConfigurationException trustStoreFileAndPathExclusive() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), trustStoreFileAndPathExclusive$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownMessageId = "ISPN004076: Unknown message id %d; cannot find matching request";
    protected String unknownMessageId$str() {
        return unknownMessageId;
    }
    @Override
    public final IllegalStateException unknownMessageId(final long messageId) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unknownMessageId$str(), messageId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorFromUnknownOperation = "ISPN004077: Closing channel %s due to error in unknown operation.";
    protected String errorFromUnknownOperation$str() {
        return errorFromUnknownOperation;
    }
    @Override
    public final TransportException errorFromUnknownOperation(final Channel channel, final Throwable cause, final SocketAddress address) {
        final TransportException result = new TransportException(String.format(getLoggingLocale(), errorFromUnknownOperation$str(), channel), cause, address);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noMoreOperationsAllowed = "ISPN004078: This channel is about to be closed and does not accept any further operations.";
    protected String noMoreOperationsAllowed$str() {
        return noMoreOperationsAllowed;
    }
    @Override
    public final HotRodClientException noMoreOperationsAllowed() {
        final HotRodClientException result = new HotRodClientException(String.format(getLoggingLocale(), noMoreOperationsAllowed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedListenerId = "ISPN004079: Unexpected listenerId %s";
    protected String unexpectedListenerId$str() {
        return unexpectedListenerId;
    }
    @Override
    public final IllegalStateException unexpectedListenerId(final String listenerId) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unexpectedListenerId$str(), listenerId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String operationIsNotAddClientListener = "ISPN004080: Event should use messageId of previous Add Client Listener operation but id is %d and operation is %s";
    protected String operationIsNotAddClientListener$str() {
        return operationIsNotAddClientListener;
    }
    @Override
    public final IllegalStateException operationIsNotAddClientListener(final long messageId, final String operation) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), operationIsNotAddClientListener$str(), messageId, operation));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidTransactionMode = "ISPN004082: TransactionMode must be non-null.";
    protected String invalidTransactionMode$str() {
        return invalidTransactionMode;
    }
    @Override
    public final CacheConfigurationException invalidTransactionMode() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidTransactionMode$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidTransactionManagerLookup = "ISPN004083: TransactionManagerLookup must be non-null";
    protected String invalidTransactionManagerLookup$str() {
        return invalidTransactionManagerLookup;
    }
    @Override
    public final CacheConfigurationException invalidTransactionManagerLookup() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), invalidTransactionManagerLookup$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cacheDoesNotSupportTransactions = "ISPN004084: Cache %s doesn't support transactions. Please check the documentation how to configure it properly.";
    protected String cacheDoesNotSupportTransactions$str() {
        return cacheDoesNotSupportTransactions;
    }
    @Override
    public final CacheNotTransactionalException cacheDoesNotSupportTransactions(final String name) {
        final CacheNotTransactionalException result = new CacheNotTransactionalException(String.format(getLoggingLocale(), cacheDoesNotSupportTransactions$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void invalidTxServerConfig(final String name, final Throwable throwable) {
        super.log.logf(FQCN, ERROR, throwable, invalidTxServerConfig$str(), name);
    }
    private static final String invalidTxServerConfig = "ISPN004085: Error checking server configuration for transactional cache %s";
    protected String invalidTxServerConfig$str() {
        return invalidTxServerConfig;
    }
    @Override
    public final void exceptionDuringPrepare(final Xid xid, final Exception e) {
        super.log.logf(FQCN, WARN, e, exceptionDuringPrepare$str(), xid);
    }
    private static final String exceptionDuringPrepare = "ISPN004086: Exception caught while preparing transaction %s";
    protected String exceptionDuringPrepare$str() {
        return exceptionDuringPrepare;
    }
    @Override
    public final void nearCacheMaxIdleUnsupported() {
        super.log.logf(FQCN, WARN, null, nearCacheMaxIdleUnsupported$str());
    }
    private static final String nearCacheMaxIdleUnsupported = "ISPN004087: Use of maxIdle expiration with a near cache is unsupported.";
    protected String nearCacheMaxIdleUnsupported$str() {
        return nearCacheMaxIdleUnsupported;
    }
    private static final String invalidTransactionTimeout = "ISPN004088: Transactions timeout must be positive";
    protected String invalidTransactionTimeout$str() {
        return invalidTransactionTimeout;
    }
    @Override
    public final HotRodClientException invalidTransactionTimeout() {
        final HotRodClientException result = new HotRodClientException(String.format(getLoggingLocale(), invalidTransactionTimeout$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String transactionTableNotStarted = "ISPN004089: TransactionTable is not started!";
    protected String transactionTableNotStarted$str() {
        return transactionTableNotStarted;
    }
    @Override
    public final HotRodClientException transactionTableNotStarted() {
        final HotRodClientException result = new HotRodClientException(String.format(getLoggingLocale(), transactionTableNotStarted$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidResponse = "ISPN004090: [%s] Invalid response operation. Expected %#x and received %#x";
    protected String invalidResponse$str() {
        return invalidResponse;
    }
    @Override
    public final InvalidResponseException invalidResponse(final String cacheName, final short opRespCode, final double receivedOpCode) {
        final InvalidResponseException result = new InvalidResponseException(String.format(getLoggingLocale(), invalidResponse$str(), cacheName, opRespCode, receivedOpCode));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String jmxRegistrationFailure = "ISPN004091: MBean registration failed";
    protected String jmxRegistrationFailure$str() {
        return jmxRegistrationFailure;
    }
    @Override
    public final HotRodClientException jmxRegistrationFailure(final Throwable cause) {
        final HotRodClientException result = new HotRodClientException(String.format(getLoggingLocale(), jmxRegistrationFailure$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String jmxUnregistrationFailure = "ISPN004092: MBean unregistration failed";
    protected String jmxUnregistrationFailure$str() {
        return jmxUnregistrationFailure;
    }
    @Override
    public final HotRodClientException jmxUnregistrationFailure(final Throwable cause) {
        final HotRodClientException result = new HotRodClientException(String.format(getLoggingLocale(), jmxUnregistrationFailure$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String oauthBearerWithoutToken = "ISPN004093: OAUTHBEARER mechanism selected without providing a token";
    protected String oauthBearerWithoutToken$str() {
        return oauthBearerWithoutToken;
    }
    @Override
    public final CacheConfigurationException oauthBearerWithoutToken() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), oauthBearerWithoutToken$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String remoteCacheTemplateNameXorConfiguration = "ISPN004094: Cannot specify both template name and configuration for '%s'";
    protected String remoteCacheTemplateNameXorConfiguration$str() {
        return remoteCacheTemplateNameXorConfiguration;
    }
    @Override
    public final CacheConfigurationException remoteCacheTemplateNameXorConfiguration(final String name) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), remoteCacheTemplateNameXorConfiguration$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notaHotRodURI = "ISPN004095: Not a Hot Rod URI: %s";
    protected String notaHotRodURI$str() {
        return notaHotRodURI;
    }
    @Override
    public final IllegalArgumentException notaHotRodURI(final String uri) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), notaHotRodURI$str(), uri));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPropertyFormat = "ISPN004096: Invalid property format in URI: %s";
    protected String invalidPropertyFormat$str() {
        return invalidPropertyFormat;
    }
    @Override
    public final IllegalArgumentException invalidPropertyFormat(final String part) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidPropertyFormat$str(), part));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateCacheConfiguration = "ISPN004097: Illegal attempt to redefine an already existing cache configuration: %s";
    protected String duplicateCacheConfiguration$str() {
        return duplicateCacheConfiguration;
    }
    @Override
    public final IllegalArgumentException duplicateCacheConfiguration(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), duplicateCacheConfiguration$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void closingChannelAfterError(final Channel channel, final Throwable t) {
        super.log.logf(FQCN, WARN, t, closingChannelAfterError$str(), channel);
    }
    private static final String closingChannelAfterError = "ISPN004098: Closing connection %s due to transport error";
    protected String closingChannelAfterError$str() {
        return closingChannelAfterError;
    }
    @Override
    public final void warnPerfRemoteIterationWithoutPagination(final String query) {
        super.log.logf(FQCN, WARN, null, warnPerfRemoteIterationWithoutPagination$str(), query);
    }
    private static final String warnPerfRemoteIterationWithoutPagination = "ISPN004099: Remote iteration over the entire result set of query '%s' without using pagination options is inefficient for large result sets. Please consider using 'startOffset' and 'maxResults' options.";
    protected String warnPerfRemoteIterationWithoutPagination$str() {
        return warnPerfRemoteIterationWithoutPagination;
    }
    @Override
    public final void throwableDuringPublisher(final Throwable t) {
        super.log.logf(FQCN, WARN, t, throwableDuringPublisher$str());
    }
    private static final String throwableDuringPublisher = "ISPN004100: Error reaching the server during iteration";
    protected String throwableDuringPublisher$str() {
        return throwableDuringPublisher;
    }
    @Override
    public final void deprecatedConfigurationProperty(final String property) {
        super.log.logf(FQCN, WARN, null, deprecatedConfigurationProperty$str(), property);
    }
    private static final String deprecatedConfigurationProperty = "ISPN004101: Configuration property '%s' has been deprecated";
    protected String deprecatedConfigurationProperty$str() {
        return deprecatedConfigurationProperty;
    }
    private static final String nearCacheMaxEntriesPositiveWithBloom = "ISPN004102: Near cache number of max entries must be a positive number when using bloom filter optimization, it was %d";
    protected String nearCacheMaxEntriesPositiveWithBloom$str() {
        return nearCacheMaxEntriesPositiveWithBloom;
    }
    @Override
    public final CacheConfigurationException nearCacheMaxEntriesPositiveWithBloom(final int maxEntries) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), nearCacheMaxEntriesPositiveWithBloom$str(), maxEntries));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String bloomFilterRequiresMaxActiveOneAndWait = "ISPN004103: Near cache with bloom filter requires pool max active to be 1, was %s, and exhausted action to be WAIT, was %s";
    protected String bloomFilterRequiresMaxActiveOneAndWait$str() {
        return bloomFilterRequiresMaxActiveOneAndWait;
    }
    @Override
    public final CacheConfigurationException bloomFilterRequiresMaxActiveOneAndWait(final int maxActive, final ExhaustedAction action) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), bloomFilterRequiresMaxActiveOneAndWait$str(), maxActive, action));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void failedToCreatePredefinedSerializationContextInitializer(final String className, final Throwable throwable) {
        super.log.logf(FQCN, WARN, throwable, failedToCreatePredefinedSerializationContextInitializer$str(), className);
    }
    private static final String failedToCreatePredefinedSerializationContextInitializer = "ISPN004104: Failed to load and create an optional ProtoStream serialization context initializer: %s";
    protected String failedToCreatePredefinedSerializationContextInitializer$str() {
        return failedToCreatePredefinedSerializationContextInitializer;
    }
    @Override
    public final void revertCacheToInitialServerList(final java.util.Collection<String> cacheName) {
        super.log.logf(FQCN, WARN, null, revertCacheToInitialServerList$str(), cacheName);
    }
    private static final String revertCacheToInitialServerList = "ISPN004105: Reverting to the initial server list for caches %s";
    protected String revertCacheToInitialServerList$str() {
        return revertCacheToInitialServerList;
    }
    @Override
    public final void invalidActiveCountAfterClose(final Channel channel) {
        super.log.logf(FQCN, WARN, null, invalidActiveCountAfterClose$str(), channel);
    }
    private static final String invalidActiveCountAfterClose = "ISPN004106: Invalid active count after closing channel %s";
    protected String invalidActiveCountAfterClose$str() {
        return invalidActiveCountAfterClose;
    }
    @Override
    public final void invalidCreatedCountAfterClose(final Channel channel) {
        super.log.logf(FQCN, WARN, null, invalidCreatedCountAfterClose$str(), channel);
    }
    private static final String invalidCreatedCountAfterClose = "ISPN004107: Invalid created count after closing channel %s";
    protected String invalidCreatedCountAfterClose$str() {
        return invalidCreatedCountAfterClose;
    }
}
