/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.net.SocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.ClientStatistics;
import org.infinispan.client.hotrod.impl.ClientTopology;
import org.infinispan.client.hotrod.impl.operations.ParallelHotRodOperation;
import org.infinispan.client.hotrod.impl.operations.PutAllOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.telemetry.impl.TelemetryService;

public class PutAllParallelOperation
extends ParallelHotRodOperation<Void, PutAllOperation> {
    protected final Map<byte[], byte[]> map;
    protected final long lifespan;
    private final TimeUnit lifespanTimeUnit;
    protected final long maxIdle;
    private final TimeUnit maxIdleTimeUnit;
    private final TelemetryService telemetryService;

    public PutAllParallelOperation(Codec codec, ChannelFactory channelFactory, Map<byte[], byte[]> map, byte[] cacheName, AtomicReference<ClientTopology> clientTopology, int flags, Configuration cfg, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit, DataFormat dataFormat, ClientStatistics clientStatistics, TelemetryService telemetryService) {
        super(codec, channelFactory, cacheName, clientTopology, flags, cfg, dataFormat, clientStatistics);
        this.map = map;
        this.lifespan = lifespan;
        this.lifespanTimeUnit = lifespanTimeUnit;
        this.maxIdle = maxIdle;
        this.maxIdleTimeUnit = maxIdleTimeUnit;
        this.telemetryService = telemetryService;
    }

    @Override
    protected List<PutAllOperation> mapOperations() {
        HashMap<SocketAddress, Map> splittedMaps = new HashMap<SocketAddress, Map>();
        for (Map.Entry<byte[], byte[]> entry : this.map.entrySet()) {
            SocketAddress socketAddress = this.channelFactory.getHashAwareServer(entry.getKey(), this.cacheName());
            Map keyValueMap = splittedMaps.computeIfAbsent(socketAddress, k -> new HashMap());
            keyValueMap.put(entry.getKey(), entry.getValue());
        }
        return splittedMaps.values().stream().map(mapSubset -> new PutAllOperation(this.codec, this.channelFactory, (Map<byte[], byte[]>)mapSubset, this.cacheName(), this.header.getClientTopology(), this.flags(), this.cfg, this.lifespan, this.lifespanTimeUnit, this.maxIdle, this.maxIdleTimeUnit, this.dataFormat(), this.clientStatistics, this.telemetryService)).collect(Collectors.toList());
    }

    @Override
    protected Void createCollector() {
        return null;
    }

    @Override
    protected void combine(Void collector, Void result) {
    }
}

