/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.configuration;

import java.util.Map;
import java.util.Properties;
import org.infinispan.client.hotrod.configuration.AbstractConfigurationChildBuilder;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ExecutorFactoryConfiguration;
import org.infinispan.client.hotrod.impl.async.DefaultAsyncExecutorFactory;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.executors.ExecutorFactory;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.Util;

public class ExecutorFactoryConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<ExecutorFactoryConfiguration> {
    private Class<? extends ExecutorFactory> factoryClass = DefaultAsyncExecutorFactory.class;
    private ExecutorFactory factory;
    private Properties properties;
    private final ConfigurationBuilder builder;

    ExecutorFactoryConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
        this.builder = builder;
        this.properties = new Properties();
    }

    public AttributeSet attributes() {
        return AttributeSet.EMPTY;
    }

    public ExecutorFactoryConfigurationBuilder factoryClass(Class<? extends ExecutorFactory> factoryClass) {
        this.factoryClass = factoryClass;
        return this;
    }

    public ExecutorFactoryConfigurationBuilder factoryClass(String factoryClass) {
        this.factoryClass = Util.loadClass((String)factoryClass, (ClassLoader)this.builder.classLoader());
        return this;
    }

    public ExecutorFactoryConfigurationBuilder factory(ExecutorFactory factory) {
        this.factory = factory;
        return this;
    }

    public ExecutorFactoryConfigurationBuilder addExecutorProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public ExecutorFactoryConfigurationBuilder withExecutorProperties(Properties props) {
        this.properties = props;
        return this;
    }

    public ExecutorFactoryConfiguration create() {
        if (this.factory != null) {
            return new ExecutorFactoryConfiguration(this.factory, TypedProperties.toTypedProperties((Map)this.properties));
        }
        return new ExecutorFactoryConfiguration(this.factoryClass, TypedProperties.toTypedProperties((Map)this.properties));
    }

    public ExecutorFactoryConfigurationBuilder read(ExecutorFactoryConfiguration template) {
        this.factory = template.factory();
        this.factoryClass = template.factoryClass();
        this.properties = template.properties();
        return this;
    }

    public String toString() {
        return "ExecutorFactoryConfigurationBuilder [factoryClass=" + String.valueOf(this.factoryClass) + ", factory=" + String.valueOf(this.factory) + ", properties=" + String.valueOf(this.properties) + "]";
    }
}

