/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.Xid;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.ServerStatistics;
import org.infinispan.client.hotrod.event.impl.ClientListenerNotifier;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.impl.VersionedOperationResponse;
import org.infinispan.client.hotrod.impl.iteration.KeyTracker;
import org.infinispan.client.hotrod.impl.operations.AddBloomNearCacheClientListenerOperation;
import org.infinispan.client.hotrod.impl.operations.AddClientListenerOperation;
import org.infinispan.client.hotrod.impl.operations.CacheExecuteOperation;
import org.infinispan.client.hotrod.impl.operations.CacheOperationsFactory;
import org.infinispan.client.hotrod.impl.operations.CachePingOperation;
import org.infinispan.client.hotrod.impl.operations.ClearOperation;
import org.infinispan.client.hotrod.impl.operations.ClientListenerOperation;
import org.infinispan.client.hotrod.impl.operations.ContainsKeyOperation;
import org.infinispan.client.hotrod.impl.operations.GetAllOperation;
import org.infinispan.client.hotrod.impl.operations.GetOperation;
import org.infinispan.client.hotrod.impl.operations.GetStreamEndOperation;
import org.infinispan.client.hotrod.impl.operations.GetStreamNextOperation;
import org.infinispan.client.hotrod.impl.operations.GetStreamNextResponse;
import org.infinispan.client.hotrod.impl.operations.GetStreamStartOperation;
import org.infinispan.client.hotrod.impl.operations.GetStreamStartResponse;
import org.infinispan.client.hotrod.impl.operations.GetWithMetadataOperation;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.operations.IterationEndOperation;
import org.infinispan.client.hotrod.impl.operations.IterationEndResponse;
import org.infinispan.client.hotrod.impl.operations.IterationNextOperation;
import org.infinispan.client.hotrod.impl.operations.IterationNextResponse;
import org.infinispan.client.hotrod.impl.operations.IterationStartOperation;
import org.infinispan.client.hotrod.impl.operations.IterationStartResponse;
import org.infinispan.client.hotrod.impl.operations.NoHotRodOperation;
import org.infinispan.client.hotrod.impl.operations.PingResponse;
import org.infinispan.client.hotrod.impl.operations.PutAllOperation;
import org.infinispan.client.hotrod.impl.operations.PutIfAbsentOperation;
import org.infinispan.client.hotrod.impl.operations.PutOperation;
import org.infinispan.client.hotrod.impl.operations.PutStreamEndOperation;
import org.infinispan.client.hotrod.impl.operations.PutStreamNextOperation;
import org.infinispan.client.hotrod.impl.operations.PutStreamResponse;
import org.infinispan.client.hotrod.impl.operations.PutStreamStartOperation;
import org.infinispan.client.hotrod.impl.operations.QueryOperation;
import org.infinispan.client.hotrod.impl.operations.RemoveClientListenerOperation;
import org.infinispan.client.hotrod.impl.operations.RemoveIfUnmodifiedOperation;
import org.infinispan.client.hotrod.impl.operations.RemoveOperation;
import org.infinispan.client.hotrod.impl.operations.ReplaceIfUnmodifiedOperation;
import org.infinispan.client.hotrod.impl.operations.ReplaceOperation;
import org.infinispan.client.hotrod.impl.operations.SizeOperation;
import org.infinispan.client.hotrod.impl.operations.StatsOperation;
import org.infinispan.client.hotrod.impl.operations.UpdateBloomFilterOperation;
import org.infinispan.client.hotrod.impl.query.RemoteQuery;
import org.infinispan.client.hotrod.impl.transaction.entry.Modification;
import org.infinispan.client.hotrod.impl.transaction.operations.PrepareTransactionOperation;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.Util;

public final class DefaultCacheOperationsFactory
implements CacheOperationsFactory {
    private final InternalRemoteCache<?, ?> remoteCache;

    public DefaultCacheOperationsFactory(InternalRemoteCache<?, ?> remoteCache) {
        this.remoteCache = Objects.requireNonNull(remoteCache);
    }

    @Override
    public InternalRemoteCache<?, ?> getRemoteCache() {
        return this.remoteCache;
    }

    @Override
    public <V> HotRodOperation<V> newGetOperation(Object key) {
        return new GetOperation(this.remoteCache, this.remoteCache.getDataFormat().keyToBytes(key));
    }

    @Override
    public HotRodOperation<PingResponse> newPingOperation() {
        return new CachePingOperation(this.remoteCache.getName());
    }

    @Override
    public <T> HotRodOperation<T> executeOperation(String taskName, Map<String, byte[]> marshalledParams, Object key) {
        return new CacheExecuteOperation(this.remoteCache, taskName, marshalledParams, key != null ? this.remoteCache.getDataFormat().keyToBytes(key) : null);
    }

    @Override
    public PrepareTransactionOperation newPrepareTransactionOperation(Xid xid, boolean onePhaseCommit, List<Modification> modifications, boolean recoverable, long timeoutMs) {
        return new PrepareTransactionOperation(this.remoteCache, xid, onePhaseCommit, modifications, recoverable, timeoutMs);
    }

    @Override
    public HotRodOperation<Void> newRemoveClientListenerOperation(Object listener) {
        ClientListenerNotifier cln = this.remoteCache.getDispatcher().getClientListenerNotifier();
        byte[] listenerId = cln.findListenerId(listener);
        if (listenerId == null) {
            return NoHotRodOperation.instance();
        }
        return new RemoveClientListenerOperation(this.remoteCache, cln, listenerId);
    }

    @Override
    public HotRodOperation<IterationStartResponse> newIterationStartOperation(String filterConverterFactory, byte[][] filterParams, IntSet segments, int batchSize, boolean metadata) {
        return new IterationStartOperation(this.remoteCache, filterConverterFactory, filterParams, segments, batchSize, metadata);
    }

    @Override
    public <K, E> HotRodOperation<IterationNextResponse<K, E>> newIterationNextOperation(byte[] iterationId, KeyTracker segmentKeyTracker) {
        return new IterationNextOperation(this.remoteCache, iterationId, segmentKeyTracker);
    }

    @Override
    public HotRodOperation<IterationEndResponse> newIterationEndOperation(byte[] iterationId) {
        return new IterationEndOperation(this.remoteCache, iterationId);
    }

    public ClearOperation newClearOperation() {
        return new ClearOperation(this.remoteCache);
    }

    @Override
    public <K, V> HotRodOperation<MetadataValue<V>> newPutKeyValueOperation(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return new PutOperation(this.remoteCache, this.remoteCache.getDataFormat().keyToBytes(key), this.remoteCache.getDataFormat().valueToBytes(value), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public <V> HotRodOperation<MetadataValue<V>> newRemoveOperation(Object key) {
        return new RemoveOperation(this.remoteCache, this.remoteCache.getDataFormat().keyToBytes(key));
    }

    @Override
    public <K> HotRodOperation<Boolean> newContainsKeyOperation(K key) {
        return new ContainsKeyOperation(this.remoteCache, this.remoteCache.getDataFormat().keyToBytes(key));
    }

    @Override
    public <K, V> HotRodOperation<V> newReplaceOperation(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return new ReplaceOperation(this.remoteCache, this.remoteCache.getDataFormat().keyToBytes(key), this.remoteCache.getDataFormat().valueToBytes(value), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public <K, V> HotRodOperation<MetadataValue<V>> newPutIfAbsentOperation(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return new PutIfAbsentOperation(this.remoteCache, this.remoteCache.getDataFormat().keyToBytes(key), this.remoteCache.getDataFormat().valueToBytes(value), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public <K, V> HotRodOperation<MetadataValue<V>> newPutIfAbsentOperation(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit, Flag ... flags) {
        return new PutIfAbsentOperation((InternalRemoteCache<?, ?>)this.remoteCache.withFlags(flags), this.remoteCache.getDataFormat().keyToBytes(key), this.remoteCache.getDataFormat().valueToBytes(value), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public HotRodOperation<ServerStatistics> newStatsOperation() {
        return new StatsOperation(this.remoteCache);
    }

    @Override
    public HotRodOperation<Integer> newSizeOperation() {
        return new SizeOperation(this.remoteCache);
    }

    @Override
    public <K, V> HotRodOperation<GetWithMetadataOperation.GetWithMetadataResult<V>> newGetWithMetadataOperation(K key, Channel channel) {
        return new GetWithMetadataOperation(this.remoteCache, this.remoteCache.getDataFormat().keyToBytes(key), channel);
    }

    @Override
    public <K, V> HotRodOperation<VersionedOperationResponse<V>> newReplaceIfUnmodifiedOperation(K key, V value, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit, long version) {
        return new ReplaceIfUnmodifiedOperation(this.remoteCache, this.remoteCache.getDataFormat().keyToBytes(key), this.remoteCache.getDataFormat().valueToBytes(value), lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit, version);
    }

    @Override
    public <K, V> HotRodOperation<VersionedOperationResponse<V>> newRemoveIfUnmodifiedOperation(K key, long version) {
        return new RemoveIfUnmodifiedOperation(this.remoteCache, this.remoteCache.getDataFormat().keyToBytes(key), version);
    }

    public PutAllOperation newPutAllBytesOperation(Map<byte[], byte[]> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return new PutAllOperation(this.remoteCache, map, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public <K, V> GetAllOperation<K, V> newGetAllBytesOperation(Set<byte[]> keys) {
        return new GetAllOperation(this.remoteCache, keys);
    }

    @Override
    public HotRodOperation<Void> newUpdateBloomFilterOperation(byte[] bloomFilterBits) {
        return new UpdateBloomFilterOperation(this.remoteCache, bloomFilterBits);
    }

    @Override
    public ClientListenerOperation newAddNearCacheListenerOperation(Object listener, int bloomBits) {
        return new AddBloomNearCacheClientListenerOperation(this.remoteCache, listener, bloomBits);
    }

    @Override
    public <T> QueryOperation<T> newQueryOperation(RemoteQuery<T> ts, boolean withHitCount) {
        return new QueryOperation<T>(this.remoteCache, ts, withHitCount);
    }

    @Override
    public AddClientListenerOperation newAddClientListenerOperation(Object listener) {
        return this.newAddClientListenerOperation(listener, null, null);
    }

    @Override
    public AddClientListenerOperation newAddClientListenerOperation(Object listener, Object[] filterFactoryParams, Object[] converterFactoryParams) {
        return new AddClientListenerOperation(this.remoteCache, listener, this.marshallParams(filterFactoryParams), this.marshallParams(converterFactoryParams));
    }

    @Override
    public HotRodOperation<GetStreamStartResponse> newGetStreamStartOperation(Object key, int batchSize) {
        return new GetStreamStartOperation(this.remoteCache, this.remoteCache.getDataFormat().keyToBytes(key), batchSize);
    }

    @Override
    public HotRodOperation<GetStreamNextResponse> newGetStreamNextOperation(int id, Channel channel) {
        return new GetStreamNextOperation(this.remoteCache, id, channel);
    }

    @Override
    public GetStreamEndOperation newGetStreamEndOperation(int id) {
        return new GetStreamEndOperation(this.remoteCache, id);
    }

    @Override
    public HotRodOperation<PutStreamResponse> newPutStreamStartOperation(Object key, long version, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return new PutStreamStartOperation(this.remoteCache, this.remoteCache.getDataFormat().keyToBytes(key), version, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public PutStreamNextOperation newPutStreamNextOperation(int id, boolean lastChunk, ByteBuf valueBytes, Channel channel) {
        return new PutStreamNextOperation(this.remoteCache, id, lastChunk, valueBytes, channel);
    }

    @Override
    public PutStreamEndOperation newPutStreamEndOperation(int id) {
        return new PutStreamEndOperation(this.remoteCache, id);
    }

    @Override
    public byte[][] marshallParams(Object[] params) {
        if (params == null) {
            return Util.EMPTY_BYTE_ARRAY_ARRAY;
        }
        byte[][] marshalledParams = new byte[params.length][];
        for (int i = 0; i < marshalledParams.length; ++i) {
            byte[] bytes = this.remoteCache.getDataFormat().keyToBytes(params[i]);
            marshalledParams[i] = bytes;
        }
        return marshalledParams;
    }

    @Override
    public CacheOperationsFactory newFactoryFor(InternalRemoteCache<?, ?> internalRemoteCache) {
        return new DefaultCacheOperationsFactory(internalRemoteCache);
    }
}

