/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.resolver.dns.RoundRobinDnsAddressResolverGroup;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.processors.FlowableProcessor;
import io.reactivex.rxjava3.processors.UnicastProcessor;
import java.io.File;
import java.net.SocketAddress;
import java.security.Provider;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.infinispan.client.hotrod.TransportFactory;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.SslConfiguration;
import org.infinispan.client.hotrod.impl.ConfigurationProperties;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelInitializer;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.impl.transport.netty.OperationChannel;
import org.infinispan.client.hotrod.impl.transport.netty.OperationDispatcher;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.io.FileWatcher;
import org.infinispan.commons.util.ProcessorInfo;
import org.infinispan.commons.util.SslContextFactory;

public class ChannelHandler {
    private static final Log log = LogFactory.getLog(ChannelHandler.class, Log.class);
    private final ConcurrentMap<SocketAddress, OperationChannel> channels = new ConcurrentHashMap<SocketAddress, OperationChannel>();
    private final Function<SocketAddress, OperationChannel> newOpChannel = this::newOperationChannel;
    private final Configuration configuration;
    private final String sniHostName;
    private final EventLoopGroup eventLoopGroup;
    private final AddressResolverGroup<?> dnsResolver;
    private final SslContext sslContext;
    private final FileWatcher watcher;
    private final OperationDispatcher dispatcher;
    private final Consumer<ChannelPipeline> pipelineDecorator;

    public ChannelHandler(Configuration configuration, String sniHostName, ExecutorService executorService, OperationDispatcher dispatcher, Consumer<ChannelPipeline> pipelineDecorator) {
        this.configuration = configuration;
        this.sniHostName = sniHostName;
        this.dispatcher = dispatcher;
        this.pipelineDecorator = pipelineDecorator;
        DnsNameResolverBuilder builder = new DnsNameResolverBuilder().channelType(configuration.transportFactory().datagramChannelClass()).ttl(configuration.dnsResolverMinTTL(), configuration.dnsResolverMaxTTL()).negativeTtl(configuration.dnsResolverNegativeTTL());
        this.dnsResolver = new RoundRobinDnsAddressResolverGroup(builder);
        int asyncThreads = this.maxAsyncThreads(executorService, configuration);
        int eventLoopThreads = Integer.getInteger("io.netty.eventLoopThreads", ProcessorInfo.availableProcessors() * 2);
        int maxExecutors = Math.min(asyncThreads, eventLoopThreads);
        this.eventLoopGroup = configuration.transportFactory().createEventLoopGroup(maxExecutors, executorService);
        SslConfiguration ssl = configuration.security().ssl();
        if (!ssl.enabled()) {
            this.sslContext = null;
            this.watcher = null;
        } else if (ssl.sslContext() == null) {
            this.sslContext = this.initSslContext(ssl);
            this.watcher = new FileWatcher();
        } else {
            this.sslContext = new JdkSslContext(ssl.sslContext(), true, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, null, ClientAuth.NONE, null, false);
            this.watcher = null;
        }
        configuration.metricRegistry().createGauge("connection.pool.size", "The total number of connections", this.channels::size, Map.of(), null);
    }

    public <E> CompletionStage<E> submitOperation(HotRodOperation<E> operation, SocketAddress socketAddress) {
        OperationChannel operationChannel = (OperationChannel)this.channels.get(socketAddress);
        if (operationChannel == null) {
            operationChannel = this.channels.computeIfAbsent(socketAddress, this.newOpChannel);
        }
        operationChannel.sendOperation(operation);
        return operation.asCompletableFuture();
    }

    public CompletionStage<Void> startChannelIfNeeded(SocketAddress socketAddress) {
        OperationChannel operationChannel = this.channels.computeIfAbsent(socketAddress, this.newOpChannel);
        return operationChannel.attemptConnect();
    }

    public List<HotRodOperation<?>> closeChannel(SocketAddress address) {
        log.tracef("Removing OperationChannel for %s", address);
        OperationChannel channel = (OperationChannel)this.channels.remove(address);
        if (channel != null) {
            log.tracef("Closing channel for %s", address);
            return channel.close();
        }
        return List.of();
    }

    public void close() {
        try {
            if (this.watcher != null) {
                this.watcher.stop();
            }
            if (this.configuration.transportFactory() == TransportFactory.DEFAULT) {
                this.eventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS).get();
            }
        }
        catch (Exception e) {
            log.warn("Exception while shutting down the channel handler.", e);
        }
    }

    private SslContext initSslContext(SslConfiguration ssl) {
        SslContextBuilder builder = SslContextBuilder.forClient();
        try {
            if (ssl.keyStoreFileName() != null) {
                builder.keyManager(new SslContextFactory().keyStoreFileName(ssl.keyStoreFileName()).keyStoreType(ssl.keyStoreType()).keyStorePassword(ssl.keyStorePassword()).keyAlias(ssl.keyAlias()).classLoader(this.configuration.classLoader()).provider(ssl.provider()).watcher(this.watcher).build().keyManager());
            }
            if (ssl.trustStoreFileName() != null) {
                if ("pem".equalsIgnoreCase(ssl.trustStoreType())) {
                    builder.trustManager(new File(ssl.trustStoreFileName()));
                } else {
                    builder.trustManager(new SslContextFactory().trustStoreFileName(ssl.trustStoreFileName()).trustStoreType(ssl.trustStoreType()).trustStorePassword(ssl.trustStorePassword()).classLoader(this.configuration.classLoader()).provider(ssl.provider()).watcher(this.watcher).build().trustManager());
                }
            }
            if (ssl.trustStorePath() != null) {
                builder.trustManager(new File(ssl.trustStorePath()));
            }
            if (ssl.protocol() != null) {
                builder.protocols(new String[]{ssl.protocol()});
            }
            if (ssl.ciphers() != null) {
                builder.ciphers(ssl.ciphers());
            }
            if (ssl.provider() != null) {
                Provider provider = SslContextFactory.findProvider((String)ssl.provider(), (String)SslContext.class.getSimpleName(), (String)"TLS");
                builder.sslContextProvider(provider);
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new CacheConfigurationException(e);
        }
    }

    private int maxAsyncThreads(ExecutorService executorService, Configuration configuration) {
        if (executorService instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)executorService).getMaximumPoolSize();
        }
        return new ConfigurationProperties((Properties)configuration.asyncExecutorFactory().properties()).getDefaultExecutorFactoryPoolSize();
    }

    private OperationChannel newOperationChannel(SocketAddress address) {
        log.debugf("Creating new channel pool for %s", address);
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.eventLoopGroup)).channel(this.configuration.transportFactory().socketChannelClass())).resolver(this.dnsResolver).remoteAddress(address).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.configuration.connectionTimeout())).option(ChannelOption.SO_KEEPALIVE, (Object)this.configuration.tcpKeepAlive())).option(ChannelOption.TCP_NODELAY, (Object)this.configuration.tcpNoDelay())).option(ChannelOption.SO_RCVBUF, (Object)1024576);
        ChannelInitializer channelInitializer = this.createChannelInitializer(address, bootstrap);
        bootstrap.handler((io.netty.channel.ChannelHandler)channelInitializer);
        OperationChannel operationChannel = this.createOperationChannel(channelInitializer, address);
        return operationChannel;
    }

    public ChannelInitializer createChannelInitializer(SocketAddress address, Bootstrap bootstrap) {
        return new ChannelInitializer(bootstrap, address, this.configuration, this.sniHostName, this.sslContext, this.dispatcher, this.pipelineDecorator);
    }

    protected OperationChannel createOperationChannel(ChannelInitializer channelInitializer, SocketAddress address) {
        return OperationChannel.createAndStart(address, channelInitializer, this.dispatcher::getClientTopologyInfo, this.dispatcher::handleConnectionFailure);
    }

    public Flowable<HotRodOperation<?>> pendingOperationFlowable() {
        return Flowable.defer(() -> {
            FlowableProcessor processor = UnicastProcessor.create().toSerialized();
            try {
                AtomicInteger toComplete = new AtomicInteger(1);
                for (OperationChannel oc : this.channels.values()) {
                    Channel channel = oc.getChannel();
                    if (channel == null) {
                        oc.pendingChannelOperations().forEach(arg_0 -> ((FlowableProcessor)processor).onNext(arg_0));
                        continue;
                    }
                    toComplete.addAndGet(1);
                    channel.eventLoop().execute(() -> {
                        try {
                            oc.pendingChannelOperations().forEach(arg_0 -> ((FlowableProcessor)processor).onNext(arg_0));
                            HeaderDecoder decoder = (HeaderDecoder)channel.pipeline().get(HeaderDecoder.class);
                            decoder.registeredOperationsById().forEach((k, v) -> processor.onNext(v));
                            if (toComplete.decrementAndGet() == 0) {
                                processor.onComplete();
                            }
                        }
                        catch (Throwable t) {
                            processor.onError(t);
                        }
                    });
                }
                if (toComplete.decrementAndGet() == 0) {
                    processor.onComplete();
                }
            }
            catch (Throwable t) {
                processor.onError(t);
            }
            return processor;
        });
    }

    public Stream<HotRodOperation<?>> gatherOperations() {
        return this.channels.values().stream().flatMap(oc -> oc.getChannel() != null ? ((HeaderDecoder)oc.getChannel().pipeline().get(HeaderDecoder.class)).registeredOperationsById().values().stream() : Stream.empty());
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    public OperationChannel getChannelForAddress(SocketAddress socketAddress) {
        return (OperationChannel)this.channels.get(socketAddress);
    }
}

