/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.ServerStatistics;
import org.infinispan.client.hotrod.Version;
import org.infinispan.client.hotrod.VersionedValue;
import org.infinispan.client.hotrod.exceptions.RemoteCacheManagerNotStartedException;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.impl.BinaryVersionedValue;
import org.infinispan.client.hotrod.impl.RemoteCacheSupport;
import org.infinispan.client.hotrod.impl.ServerStatisticsImpl;
import org.infinispan.client.hotrod.impl.VersionedOperationResponse;
import org.infinispan.client.hotrod.impl.VersionedValueImpl;
import org.infinispan.client.hotrod.impl.async.NotifyingFutureImpl;
import org.infinispan.client.hotrod.impl.operations.BulkGetOperation;
import org.infinispan.client.hotrod.impl.operations.ClearOperation;
import org.infinispan.client.hotrod.impl.operations.ContainsKeyOperation;
import org.infinispan.client.hotrod.impl.operations.GetOperation;
import org.infinispan.client.hotrod.impl.operations.GetWithVersionOperation;
import org.infinispan.client.hotrod.impl.operations.OperationsFactory;
import org.infinispan.client.hotrod.impl.operations.PutIfAbsentOperation;
import org.infinispan.client.hotrod.impl.operations.PutOperation;
import org.infinispan.client.hotrod.impl.operations.RemoveIfUnmodifiedOperation;
import org.infinispan.client.hotrod.impl.operations.RemoveOperation;
import org.infinispan.client.hotrod.impl.operations.ReplaceIfUnmodifiedOperation;
import org.infinispan.client.hotrod.impl.operations.ReplaceOperation;
import org.infinispan.client.hotrod.impl.operations.StatsOperation;
import org.infinispan.marshall.Marshaller;
import org.infinispan.util.concurrent.NotifyingFuture;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RemoteCacheImpl<K, V>
extends RemoteCacheSupport<K, V> {
    private static final Log log = LogFactory.getLog(RemoteCacheImpl.class);
    private Marshaller marshaller;
    private final String name;
    private final RemoteCacheManager remoteCacheManager;
    private volatile ExecutorService executorService;
    private OperationsFactory operationsFactory;
    private int estimateKeySize;
    private int estimateValueSize;

    public RemoteCacheImpl(RemoteCacheManager rcm, String name) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Creating remote cache: " + name));
        }
        this.name = name;
        this.remoteCacheManager = rcm;
    }

    public void init(Marshaller marshaller, ExecutorService executorService, OperationsFactory operationsFactory, int estimateKeySize, int estimateValueSize) {
        this.marshaller = marshaller;
        this.executorService = executorService;
        this.operationsFactory = operationsFactory;
        this.estimateKeySize = estimateKeySize;
        this.estimateValueSize = estimateValueSize;
    }

    @Override
    public RemoteCacheManager getRemoteCacheManager() {
        return this.remoteCacheManager;
    }

    @Override
    public boolean removeWithVersion(K key, long version) {
        this.assertRemoteCacheManagerIsStarted();
        RemoveIfUnmodifiedOperation op = this.operationsFactory.newRemoveIfUnmodifiedOperation(this.obj2bytes(key, true), version);
        VersionedOperationResponse response = (VersionedOperationResponse)op.execute();
        return response.getCode().isUpdated();
    }

    @Override
    public NotifyingFuture<Boolean> removeWithVersionAsync(final K key, final long version) {
        this.assertRemoteCacheManagerIsStarted();
        final NotifyingFutureImpl<Boolean> result = new NotifyingFutureImpl<Boolean>();
        Future future = this.executorService.submit(new Callable(){

            public Object call() throws Exception {
                boolean removed = RemoteCacheImpl.this.removeWithVersion(key, version);
                result.notifyFutureCompletion();
                return removed;
            }
        });
        result.setExecuting(future);
        return result;
    }

    @Override
    public boolean replaceWithVersion(K key, V newValue, long version, int lifespanSeconds, int maxIdleTimeSeconds) {
        this.assertRemoteCacheManagerIsStarted();
        ReplaceIfUnmodifiedOperation op = this.operationsFactory.newReplaceIfUnmodifiedOperation(this.obj2bytes(key, true), this.obj2bytes(newValue, false), lifespanSeconds, maxIdleTimeSeconds, version);
        VersionedOperationResponse response = (VersionedOperationResponse)op.execute();
        return response.getCode().isUpdated();
    }

    @Override
    public NotifyingFuture<Boolean> replaceWithVersionAsync(final K key, final V newValue, final long version, final int lifespanSeconds, final int maxIdleSeconds) {
        this.assertRemoteCacheManagerIsStarted();
        final NotifyingFutureImpl<Boolean> result = new NotifyingFutureImpl<Boolean>();
        Future future = this.executorService.submit(new Callable(){

            public Object call() throws Exception {
                boolean removed = RemoteCacheImpl.this.replaceWithVersion(key, newValue, version, lifespanSeconds, maxIdleSeconds);
                result.notifyFutureCompletion();
                return removed;
            }
        });
        result.setExecuting(future);
        return result;
    }

    @Override
    public VersionedValue<V> getVersioned(K key) {
        this.assertRemoteCacheManagerIsStarted();
        GetWithVersionOperation op = this.operationsFactory.newGetWithVersionOperation(this.obj2bytes(key, true));
        BinaryVersionedValue value = (BinaryVersionedValue)op.execute();
        return this.binary2VersionedValue(value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.assertRemoteCacheManagerIsStarted();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue(), lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        }
    }

    @Override
    public NotifyingFuture<Void> putAllAsync(final Map<? extends K, ? extends V> data, final long lifespan, final TimeUnit lifespanUnit, final long maxIdle, final TimeUnit maxIdleUnit) {
        this.assertRemoteCacheManagerIsStarted();
        final NotifyingFutureImpl<Void> result = new NotifyingFutureImpl<Void>();
        Future future = this.executorService.submit(new Callable(){

            public Object call() throws Exception {
                RemoteCacheImpl.this.putAll(data, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
                result.notifyFutureCompletion();
                return null;
            }
        });
        result.setExecuting(future);
        return result;
    }

    @Override
    public ServerStatistics stats() {
        this.assertRemoteCacheManagerIsStarted();
        StatsOperation op = this.operationsFactory.newStatsOperation();
        Map statsMap = (Map)op.execute();
        ServerStatisticsImpl stats = new ServerStatisticsImpl();
        for (Map.Entry entry : statsMap.entrySet()) {
            stats.addStats((String)entry.getKey(), (String)entry.getValue());
        }
        return stats;
    }

    public V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.assertRemoteCacheManagerIsStarted();
        int lifespanSecs = this.toSeconds(lifespan, lifespanUnit);
        int maxIdleSecs = this.toSeconds(maxIdleTime, maxIdleTimeUnit);
        if (log.isTraceEnabled()) {
            log.trace((Object)("About to add (K,V): (" + key + ", " + value + ") lifespanSecs:" + lifespanSecs + ", maxIdleSecs:" + maxIdleSecs));
        }
        PutOperation op = this.operationsFactory.newPutKeyValueOperation(this.obj2bytes(key, true), this.obj2bytes(value, false), lifespanSecs, maxIdleSecs);
        byte[] result = (byte[])op.execute();
        return (V)this.bytes2obj(result);
    }

    public V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.assertRemoteCacheManagerIsStarted();
        int lifespanSecs = this.toSeconds(lifespan, lifespanUnit);
        int maxIdleSecs = this.toSeconds(maxIdleTime, maxIdleTimeUnit);
        PutIfAbsentOperation op = this.operationsFactory.newPutIfAbsentOperation(this.obj2bytes(key, true), this.obj2bytes(value, false), lifespanSecs, maxIdleSecs);
        byte[] bytes = (byte[])op.execute();
        return (V)this.bytes2obj(bytes);
    }

    public V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.assertRemoteCacheManagerIsStarted();
        int lifespanSecs = this.toSeconds(lifespan, lifespanUnit);
        int maxIdleSecs = this.toSeconds(maxIdleTime, maxIdleTimeUnit);
        ReplaceOperation op = this.operationsFactory.newReplaceOperation(this.obj2bytes(key, true), this.obj2bytes(value, false), lifespanSecs, maxIdleSecs);
        byte[] bytes = (byte[])op.execute();
        return (V)this.bytes2obj(bytes);
    }

    public NotifyingFuture<V> putAsync(final K key, final V value, final long lifespan, final TimeUnit lifespanUnit, final long maxIdle, final TimeUnit maxIdleUnit) {
        this.assertRemoteCacheManagerIsStarted();
        final NotifyingFutureImpl result = new NotifyingFutureImpl();
        Future future = this.executorService.submit(new Callable(){

            public Object call() throws Exception {
                Object prevValue = RemoteCacheImpl.this.put(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
                result.notifyFutureCompletion();
                return prevValue;
            }
        });
        result.setExecuting(future);
        return result;
    }

    public NotifyingFuture<Void> clearAsync() {
        this.assertRemoteCacheManagerIsStarted();
        final NotifyingFutureImpl<Void> result = new NotifyingFutureImpl<Void>();
        Future future = this.executorService.submit(new Callable(){

            public Object call() throws Exception {
                RemoteCacheImpl.this.clear();
                result.notifyFutureCompletion();
                return null;
            }
        });
        result.setExecuting(future);
        return result;
    }

    public NotifyingFuture<V> putIfAbsentAsync(final K key, final V value, final long lifespan, final TimeUnit lifespanUnit, final long maxIdle, final TimeUnit maxIdleUnit) {
        this.assertRemoteCacheManagerIsStarted();
        final NotifyingFutureImpl result = new NotifyingFutureImpl();
        Future future = this.executorService.submit(new Callable(){

            public Object call() throws Exception {
                Object prevValue = RemoteCacheImpl.this.putIfAbsent(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
                result.notifyFutureCompletion();
                return prevValue;
            }
        });
        result.setExecuting(future);
        return result;
    }

    public NotifyingFuture<V> removeAsync(final Object key) {
        this.assertRemoteCacheManagerIsStarted();
        final NotifyingFutureImpl result = new NotifyingFutureImpl();
        Future future = this.executorService.submit(new Callable(){

            public Object call() throws Exception {
                Object toReturn = RemoteCacheImpl.this.remove(key);
                result.notifyFutureCompletion();
                return toReturn;
            }
        });
        result.setExecuting(future);
        return result;
    }

    public NotifyingFuture<V> replaceAsync(final K key, final V value, final long lifespan, final TimeUnit lifespanUnit, final long maxIdle, final TimeUnit maxIdleUnit) {
        this.assertRemoteCacheManagerIsStarted();
        final NotifyingFutureImpl result = new NotifyingFutureImpl();
        Future future = this.executorService.submit(new Callable(){

            public Object call() throws Exception {
                Object v = RemoteCacheImpl.this.replace(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
                result.notifyFutureCompletion();
                return v;
            }
        });
        result.setExecuting(future);
        return result;
    }

    public boolean containsKey(Object key) {
        this.assertRemoteCacheManagerIsStarted();
        ContainsKeyOperation op = this.operationsFactory.newContainsKeyOperation(this.obj2bytes(key, true));
        return (Boolean)op.execute();
    }

    public V get(Object key) {
        this.assertRemoteCacheManagerIsStarted();
        byte[] keyBytes = this.obj2bytes(key, true);
        GetOperation gco = this.operationsFactory.newGetKeyOperation(keyBytes);
        byte[] bytes = (byte[])gco.execute();
        Object result = this.bytes2obj(bytes);
        if (log.isTraceEnabled()) {
            log.trace((Object)("For key(" + key + ") returning " + result));
        }
        return (V)result;
    }

    @Override
    public Map<K, V> getBulk() {
        return this.getBulk(0);
    }

    @Override
    public Map<K, V> getBulk(int size) {
        this.assertRemoteCacheManagerIsStarted();
        BulkGetOperation op = this.operationsFactory.newBulkGetOperation(size);
        Map result = (Map)op.execute();
        HashMap<Object, Object> toReturn = new HashMap<Object, Object>();
        for (Map.Entry entry : result.entrySet()) {
            Object value = this.bytes2obj((byte[])entry.getValue());
            Object key = this.bytes2obj((byte[])entry.getKey());
            toReturn.put(key, value);
        }
        return Collections.unmodifiableMap(toReturn);
    }

    public V remove(Object key) {
        this.assertRemoteCacheManagerIsStarted();
        RemoveOperation removeOperation = this.operationsFactory.newRemoveOperation(this.obj2bytes(key, true));
        byte[] existingValue = (byte[])removeOperation.execute();
        return (V)this.bytes2obj(existingValue);
    }

    public void clear() {
        this.assertRemoteCacheManagerIsStarted();
        ClearOperation op = this.operationsFactory.newClearOperation();
        op.execute();
    }

    public void start() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Start called, nothing to do here(" + this.getName() + ")"));
        }
    }

    public void stop() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Stop called, nothing to do here(" + this.getName() + ")"));
        }
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return Version.getProtocolVersion();
    }

    @Override
    public RemoteCache<K, V> withFlags(Flag ... flags) {
        this.operationsFactory.setFlags(flags);
        return this;
    }

    private byte[] obj2bytes(Object o, boolean isKey) {
        try {
            return this.marshaller.objectToByteBuffer(o, isKey ? this.estimateKeySize : this.estimateValueSize);
        }
        catch (IOException ioe) {
            throw new TransportException("Unable to marshall object of type [" + o.getClass().getName() + "]", ioe);
        }
    }

    private Object bytes2obj(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return this.marshaller.objectFromByteBuffer(bytes);
        }
        catch (Exception e) {
            throw new TransportException("Unable to unmarshall byte stream", e);
        }
    }

    private VersionedValue<V> binary2VersionedValue(BinaryVersionedValue value) {
        if (value == null) {
            return null;
        }
        Object valueObj = this.bytes2obj(value.getValue());
        return new VersionedValueImpl<Object>(value.getVersion(), valueObj);
    }

    private int toSeconds(long duration, TimeUnit timeUnit) {
        return (int)timeUnit.toSeconds(duration);
    }

    private void assertRemoteCacheManagerIsStarted() {
        if (!this.remoteCacheManager.isStarted()) {
            String message = "Cannot perform operations on a cache associated with an unstarted RemoteCacheManager. Use RemoteCacheManager.start before using the remote cache.";
            if (log.isInfoEnabled()) {
                log.info((Object)message);
            }
            throw new RemoteCacheManagerNotStartedException(message);
        }
    }
}

