/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.tcp;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.impl.ConfigurationProperties;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHashFactory;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.client.hotrod.impl.transport.tcp.PropsKeyedObjectPoolFactory;
import org.infinispan.client.hotrod.impl.transport.tcp.RequestBalancingStrategy;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransport;
import org.infinispan.client.hotrod.impl.transport.tcp.TransportObjectFactory;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public class TcpTransportFactory
implements TransportFactory {
    private static final Log log = LogFactory.getLog(TcpTransportFactory.class);
    private volatile GenericKeyedObjectPool connectionPool;
    private volatile RequestBalancingStrategy balancer;
    private volatile Collection<InetSocketAddress> servers;
    private volatile ConsistentHash consistentHash;
    private volatile boolean tcpNoDelay;
    private final ConsistentHashFactory hashFactory = new ConsistentHashFactory();

    @Override
    public void start(ConfigurationProperties cfg, Collection<InetSocketAddress> staticConfiguredServers, AtomicInteger topologyId) {
        this.hashFactory.init(cfg);
        boolean pingOnStartup = cfg.getPingOnStartup();
        this.servers = staticConfiguredServers;
        String balancerClass = cfg.getRequestBalancingStrategy();
        this.balancer = (RequestBalancingStrategy)Util.getInstance((String)balancerClass);
        this.tcpNoDelay = cfg.getTcpNoDelay();
        PropsKeyedObjectPoolFactory poolFactory = new PropsKeyedObjectPoolFactory((KeyedPoolableObjectFactory)new TransportObjectFactory(this, topologyId, pingOnStartup), cfg.getProperties());
        this.createAndPreparePool(staticConfiguredServers, poolFactory);
        this.balancer.setServers(this.servers);
    }

    private void createAndPreparePool(Collection<InetSocketAddress> staticConfiguredServers, PropsKeyedObjectPoolFactory poolFactory) {
        this.connectionPool = (GenericKeyedObjectPool)poolFactory.createPool();
        for (InetSocketAddress addr : staticConfiguredServers) {
            this.connectionPool.preparePool((Object)addr, false);
        }
    }

    @Override
    public void destroy() {
        this.connectionPool.clear();
        try {
            this.connectionPool.close();
        }
        catch (Exception e) {
            log.warn((Object)"Exception while shutting down the connection pool.", (Throwable)e);
        }
    }

    @Override
    public void updateHashFunction(LinkedHashMap<InetSocketAddress, Integer> servers2HashCode, int numKeyOwners, short hashFunctionVersion, int hashSpace) {
        ConsistentHash hash = this.hashFactory.newConsistentHash(hashFunctionVersion);
        if (hash == null) {
            log.warn((Object)("No hash function configured for version: " + hashFunctionVersion));
        } else {
            hash.init(servers2HashCode, numKeyOwners, hashSpace);
        }
        this.consistentHash = hash;
    }

    @Override
    public Transport getTransport() {
        InetSocketAddress server = this.balancer.nextServer();
        return this.borrowTransportFromPool(server);
    }

    @Override
    public Transport getTransport(byte[] key) {
        InetSocketAddress server;
        if (this.consistentHash != null) {
            server = this.consistentHash.getServer(key);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Using consistent hash for determining the server: " + server));
            }
        } else {
            server = this.balancer.nextServer();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Using the balancer for determining the server: " + server));
            }
        }
        return this.borrowTransportFromPool(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseTransport(Transport transport) {
        TcpTransport tcpTransport = (TcpTransport)transport;
        if (!tcpTransport.isValid()) {
            try {
                if (log.isTraceEnabled()) {
                    log.info((Object)("Dropping connection as it is no longer valid: " + tcpTransport));
                }
                this.connectionPool.invalidateObject((Object)tcpTransport.getServerAddress(), (Object)tcpTransport);
            }
            catch (Exception e) {
                log.warn((Object)("Could not invalidate connection: " + tcpTransport), (Throwable)e);
            }
        } else {
            try {
                this.connectionPool.returnObject((Object)tcpTransport.getServerAddress(), (Object)tcpTransport);
            }
            catch (Exception e) {
                log.warn((Object)("Could not release connection: " + tcpTransport), (Throwable)e);
            }
            finally {
                this.logConnectionInfo(tcpTransport.getServerAddress());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateServers(Collection<InetSocketAddress> newServers) {
        TcpTransportFactory tcpTransportFactory = this;
        synchronized (tcpTransportFactory) {
            HashSet<InetSocketAddress> addedServers = new HashSet<InetSocketAddress>(newServers);
            addedServers.removeAll(this.servers);
            HashSet<InetSocketAddress> failedServers = new HashSet<InetSocketAddress>(this.servers);
            failedServers.removeAll(newServers);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Current list: " + this.servers));
                log.trace((Object)("New list: " + newServers));
                log.trace((Object)("Added servers: " + addedServers));
                log.trace((Object)("Removed servers: " + failedServers));
            }
            if (failedServers.isEmpty() && newServers.isEmpty()) {
                log.info((Object)"Same list of servers, not changing the pool");
                return;
            }
            for (InetSocketAddress server : newServers) {
                log.info((Object)("New server added(" + server + "), adding to the pool."));
                try {
                    this.connectionPool.addObject((Object)server);
                }
                catch (Exception e) {
                    log.warn((Object)("Failed adding new server " + server), (Throwable)e);
                }
            }
            this.balancer.setServers(newServers);
            for (InetSocketAddress server : failedServers) {
                log.info((Object)("Server not in cluster anymore(" + server + "), removing from the pool."));
                this.connectionPool.clear((Object)server);
            }
            this.servers.clear();
            this.servers.addAll(newServers);
        }
    }

    public Collection<InetSocketAddress> getServers() {
        return this.servers;
    }

    private void logConnectionInfo(InetSocketAddress server) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("For server " + server + ": active = " + this.connectionPool.getNumActive((Object)server) + "; idle = " + this.connectionPool.getNumIdle((Object)server)));
        }
    }

    private Transport borrowTransportFromPool(InetSocketAddress server) {
        try {
            Transport transport = (Transport)this.connectionPool.borrowObject((Object)server);
            return transport;
        }
        catch (Exception e) {
            String message = "Could not fetch transport";
            log.error((Object)message, (Throwable)e);
            throw new TransportException(message, e);
        }
        finally {
            this.logConnectionInfo(server);
        }
    }

    public ConsistentHash getConsistentHash() {
        return this.consistentHash;
    }

    @Override
    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    @Override
    public int getTransportCount() {
        if (Thread.currentThread().isInterrupted()) {
            return -1;
        }
        if (this.connectionPool.getMaxActive() > 0) {
            return this.connectionPool.getMaxActive() * this.servers.size();
        }
        return 10 * this.servers.size();
    }

    public RequestBalancingStrategy getBalancer() {
        return this.balancer;
    }

    public GenericKeyedObjectPool getConnectionPool() {
        return this.connectionPool;
    }
}

