/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Immutable
public abstract class RetryOnFailureOperation
extends HotRodOperation {
    private static final Log log = LogFactory.getLog(RetryOnFailureOperation.class);
    protected final TransportFactory transportFactory;

    protected RetryOnFailureOperation(TransportFactory transportFactory, byte[] cacheName, AtomicInteger topologyId, Flag[] flags) {
        super(flags, cacheName, topologyId);
        this.transportFactory = transportFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute() {
        int retryCount = 0;
        Transport transport = this.getTransport(retryCount);
        do {
            try {
                Object object = this.executeOperation(transport);
                return object;
            }
            catch (TransportException te) {
                this.logErrorAndThrowExceptionIfNeeded(retryCount, te);
            }
            finally {
                this.releaseTransport(transport);
            }
            if (!this.shouldRetry(retryCount)) continue;
            transport = this.getTransport(retryCount);
        } while (this.shouldRetry(++retryCount));
        throw new IllegalStateException("We should not reach here!");
    }

    protected boolean shouldRetry(int retryCount) {
        return retryCount < this.transportFactory.getTransportCount();
    }

    protected void logErrorAndThrowExceptionIfNeeded(int i, TransportException te) {
        String message = "Transport exception. Retry " + i + " out of " + this.transportFactory.getTransportCount();
        if (i == this.transportFactory.getTransportCount() - 1 || this.transportFactory.getTransportCount() < 0) {
            log.warn((Object)message, (Throwable)te);
            throw te;
        }
        log.trace((Object)(message + ":" + te));
    }

    protected void releaseTransport(Transport transport) {
        if (transport != null) {
            this.transportFactory.releaseTransport(transport);
        }
    }

    protected abstract Transport getTransport(int var1);

    protected abstract Object executeOperation(Transport var1);
}

