/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.Map;
import java.util.Properties;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.BulkGetSimpleTest", groups={"functional"})
public class BulkGetSimpleTest
extends SingleCacheManagerTest {
    private HotRodServer hotRodServer;
    private RemoteCacheManager remoteCacheManager;
    private RemoteCache<Object, Object> remoteCache;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createLocalCacheManager();
        this.cache = this.cacheManager.getCache();
        this.hotRodServer = TestHelper.startHotRodServer(this.cacheManager);
        Properties hotrodClientConf = new Properties();
        hotrodClientConf.put("infinispan.client.hotrod.server_list", "localhost:" + this.hotRodServer.getPort());
        this.remoteCacheManager = new RemoteCacheManager(hotrodClientConf);
        this.remoteCache = this.remoteCacheManager.getCache();
        this.populateCacheManager();
        return this.cacheManager;
    }

    @AfterMethod
    protected void clearContent() {
    }

    private void populateCacheManager() {
        for (int i = 0; i < 100; ++i) {
            this.remoteCache.put((Object)i, (Object)i);
        }
    }

    public void testBulkGet() {
        Map map = this.remoteCache.getBulk();
        assert (map.size() == 100);
        for (int i = 0; i < 100; ++i) {
            assert (map.get(i).equals(i));
        }
    }

    public void testBulkGetWithSize() {
        Map map = this.remoteCache.getBulk(50);
        AssertJUnit.assertEquals((int)50, (int)map.size());
        for (int i = 0; i < 100; ++i) {
            if (!map.containsKey(i)) continue;
            Integer value = (Integer)map.get(i);
            AssertJUnit.assertEquals((Object)i, (Object)value);
        }
    }
}

