/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.Properties;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory;
import org.infinispan.config.Configuration;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.PingOnStartupTest")
public class PingOnStartupTest
extends MultipleCacheManagersTest {
    private HotRodServer hotRodServer1;
    private HotRodServer hotRodServer2;

    protected void createCacheManagers() throws Throwable {
        Configuration config = PingOnStartupTest.getDefaultClusteredConfig((Configuration.CacheMode)Configuration.CacheMode.DIST_SYNC);
        this.addClusterEnabledCacheManager(config);
        this.addClusterEnabledCacheManager(config);
        this.hotRodServer1 = TestHelper.startHotRodServer(this.manager(0));
        this.hotRodServer2 = TestHelper.startHotRodServer(this.manager(1));
        assert (this.manager(0).getCache() != null);
        assert (this.manager(1).getCache() != null);
        TestingUtil.blockUntilViewReceived((Cache)this.manager(0).getCache(), (int)2, (long)10000L);
        TestingUtil.blockUntilCacheStatusAchieved((Cache)this.manager(0).getCache(), (ComponentStatus)ComponentStatus.RUNNING, (long)10000L);
        TestingUtil.blockUntilCacheStatusAchieved((Cache)this.manager(1).getCache(), (ComponentStatus)ComponentStatus.RUNNING, (long)10000L);
        this.cache(0).put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache(1).get((Object)"k"));
    }

    @AfterClass
    protected void destroy() {
        super.destroy();
        try {
            this.hotRodServer1.stop();
            this.hotRodServer2.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTopologyFetched() throws Exception {
        Properties props = new Properties();
        props.put("infinispan.client.hotrod.server_list", "localhost:" + this.hotRodServer2.getPort() + ";localhost:" + this.hotRodServer2.getPort());
        props.put("infinispan.client.hotrod.ping_on_startup", "true");
        props.put("timeBetweenEvictionRunsMillis", "500");
        RemoteCacheManager remoteCacheManager = new RemoteCacheManager(props);
        TcpTransportFactory tcpConnectionFactory = (TcpTransportFactory)TestingUtil.extractField((Object)remoteCacheManager, (String)"transportFactory");
        for (int i = 0; i < 10; ++i) {
            try {
                if (tcpConnectionFactory.getServers().size() != 1) break;
                Thread.sleep(1000L);
                continue;
            }
            finally {
                remoteCacheManager.stop();
            }
        }
        AssertJUnit.assertEquals((int)2, (int)tcpConnectionFactory.getServers().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTopologyNotFetched() {
        Properties props = new Properties();
        props.put("infinispan.client.hotrod.server_list", "localhost:" + this.hotRodServer2.getPort() + ";localhost:" + this.hotRodServer2.getPort());
        props.put("infinispan.client.hotrod.ping_on_startup", "false");
        RemoteCacheManager remoteCacheManager = new RemoteCacheManager(props);
        TcpTransportFactory tcpConnectionFactory = (TcpTransportFactory)TestingUtil.extractField((Object)remoteCacheManager, (String)"transportFactory");
        try {
            AssertJUnit.assertEquals((int)1, (int)tcpConnectionFactory.getServers().size());
        }
        finally {
            remoteCacheManager.stop();
        }
    }
}

