/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.net.InetSocketAddress;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory;
import org.infinispan.config.Configuration;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.ReplTopologyChangeTest", groups={"functional"})
public class ReplTopologyChangeTest
extends MultipleCacheManagersTest {
    HotRodServer hotRodServer1;
    HotRodServer hotRodServer2;
    HotRodServer hotRodServer3;
    RemoteCache remoteCache;
    private RemoteCacheManager remoteCacheManager;
    private TcpTransportFactory tcpConnectionFactory;
    private Configuration config;

    protected void assertSupportedConfig() {
    }

    @AfterMethod
    protected void clearContent() throws Throwable {
    }

    @AfterClass(alwaysRun=true)
    protected void destroy() {
        try {
            this.hotRodServer1.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.hotRodServer2.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.destroy();
    }

    protected void createCacheManagers() throws Throwable {
        this.config = ReplTopologyChangeTest.getDefaultClusteredConfig((Configuration.CacheMode)this.getCacheMode());
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createClusteredCacheManager((Configuration)this.config);
        EmbeddedCacheManager cm2 = TestCacheManagerFactory.createClusteredCacheManager((Configuration)this.config);
        this.registerCacheManager(new CacheContainer[]{cm1});
        this.registerCacheManager(new CacheContainer[]{cm2});
        this.hotRodServer1 = TestHelper.startHotRodServer(this.manager(0));
        this.hotRodServer2 = TestHelper.startHotRodServer(this.manager(1));
        this.manager(0).getCache();
        this.manager(1).getCache();
        this.waitForClusterToForm(2);
        this.manager(0).getCache().put((Object)"k_test", (Object)"v");
        this.manager(0).getCache().get((Object)"k_test").equals("v");
        this.manager(1).getCache().get((Object)"k_test").equals("v");
        this.log.info((Object)"Local replication test passed!");
        this.remoteCacheManager = new RemoteCacheManager("localhost", this.hotRodServer2.getPort());
        this.remoteCache = this.remoteCacheManager.getCache();
        this.tcpConnectionFactory = (TcpTransportFactory)TestingUtil.extractField((Object)this.remoteCacheManager, (String)"transportFactory");
    }

    protected Configuration.CacheMode getCacheMode() {
        return Configuration.CacheMode.REPL_SYNC;
    }

    public void testTwoMembers() {
        InetSocketAddress server1Address = new InetSocketAddress("localhost", this.hotRodServer1.getPort());
        this.expectTopologyChange(server1Address, true);
        AssertJUnit.assertEquals((int)2, (int)this.tcpConnectionFactory.getServers().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dependsOnMethods={"testTwoMembers"})
    public void testAddNewServer() {
        EmbeddedCacheManager cm3 = TestCacheManagerFactory.createClusteredCacheManager((Configuration)this.config);
        this.registerCacheManager(new CacheContainer[]{cm3});
        this.hotRodServer3 = TestHelper.startHotRodServer(this.manager(2));
        this.manager(2).getCache();
        this.waitForClusterToForm(3);
        try {
            this.expectTopologyChange(new InetSocketAddress("localhost", this.hotRodServer3.getPort()), true);
            AssertJUnit.assertEquals((int)3, (int)this.tcpConnectionFactory.getServers().size());
        }
        finally {
            this.log.info((Object)("Members are: " + this.manager(0).getCache().getAdvancedCache().getRpcManager().getTransport().getMembers()));
            this.log.info((Object)("Members are: " + this.manager(1).getCache().getAdvancedCache().getRpcManager().getTransport().getMembers()));
            this.log.info((Object)("Members are: " + this.manager(2).getCache().getAdvancedCache().getRpcManager().getTransport().getMembers()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dependsOnMethods={"testAddNewServer"})
    public void testDropServer() {
        this.hotRodServer3.stop();
        this.manager(2).stop();
        this.log.trace((Object)"Just stopped server 2");
        this.waitForClusterToForm(2);
        InetSocketAddress server3Address = new InetSocketAddress("localhost", this.hotRodServer3.getPort());
        try {
            this.expectTopologyChange(server3Address, false);
            AssertJUnit.assertEquals((int)2, (int)this.tcpConnectionFactory.getServers().size());
        }
        finally {
            this.log.info((Object)("Members are: " + this.manager(0).getCache().getAdvancedCache().getRpcManager().getTransport().getMembers()));
            this.log.info((Object)("Members are: " + this.manager(1).getCache().getAdvancedCache().getRpcManager().getTransport().getMembers()));
            if (this.manager(2).getStatus() != ComponentStatus.RUNNING) {
                this.log.info((Object)"Members are: 0");
            } else {
                this.log.info((Object)("Members are: " + this.manager(2).getCache().getAdvancedCache().getRpcManager().getTransport().getMembers()));
            }
        }
    }

    private void expectTopologyChange(InetSocketAddress server1Address, boolean added) {
        for (int i = 0; i < 10; ++i) {
            this.remoteCache.put((Object)("k" + i), (Object)("v" + i));
            if (added == this.tcpConnectionFactory.getServers().contains(server1Address)) break;
        }
        AssertJUnit.assertEquals((String)(server1Address + " not found"), (boolean)added, (boolean)this.tcpConnectionFactory.getServers().contains(server1Address));
    }

    protected void waitForClusterToForm(int memberCount) {
        TestingUtil.blockUntilViewReceived((Cache)this.manager(0).getCache(), (int)memberCount, (long)30000L);
        for (int i = 0; i < memberCount; ++i) {
            TestingUtil.blockUntilCacheStatusAchieved((Cache)this.manager(i).getCache(), (ComponentStatus)ComponentStatus.RUNNING, (long)30000L);
        }
    }
}

