/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import junit.framework.Assert;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.ServerShutdownTest", groups={"functional"})
public class ServerShutdownTest {
    public void testServerShutdownWithConnectedClient() {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createLocalCacheManager();
        HotRodServer hotrodServer = TestHelper.startHotRodServer(cacheManager);
        RemoteCacheManager remoteCacheManager = new RemoteCacheManager("localhost", hotrodServer.getPort());
        RemoteCache remoteCache = remoteCacheManager.getCache();
        remoteCache.put((Object)"k", (Object)"v");
        Assert.assertEquals((Object)"v", (Object)remoteCache.get((Object)"k"));
        hotrodServer.stop();
        cacheManager.stop();
        remoteCacheManager.stop();
    }

    public void testServerShutdownWithoutConnectedClient() {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createLocalCacheManager();
        HotRodServer hotrodServer = TestHelper.startHotRodServer(cacheManager);
        RemoteCacheManager remoteCacheManager = new RemoteCacheManager("localhost", hotrodServer.getPort());
        RemoteCache remoteCache = remoteCacheManager.getCache();
        remoteCache.put((Object)"k", (Object)"v");
        Assert.assertEquals((Object)"v", (Object)remoteCache.get((Object)"k"));
        remoteCacheManager.stop();
        hotrodServer.stop();
        cacheManager.stop();
    }
}

