/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class WorkerThread {
    private static final AtomicInteger WORKER_INDEX = new AtomicInteger();
    private static final Log log = LogFactory.getLog(WorkerThread.class);
    private final RemoteCache remoteCache;
    private volatile Future<?> future;
    private final ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "WorkerThread-" + WORKER_INDEX.getAndIncrement());
        }
    });

    public WorkerThread(RemoteCache remoteCache) {
        this.remoteCache = remoteCache;
    }

    private void stressInternal() throws Exception {
        Random rnd = new Random();
        while (!this.executor.isShutdown()) {
            this.remoteCache.put((Object)rnd.nextLong(), (Object)rnd.nextLong());
            Thread.sleep(50L);
        }
    }

    public String put(final String key, final String value) {
        Future<Object> result = this.executor.submit(new Callable<Object>(){

            @Override
            public Object call() {
                return WorkerThread.this.remoteCache.put((Object)key, (Object)value);
            }
        });
        try {
            return (String)result.get();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException();
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Error during put", e.getCause());
        }
    }

    public Future<?> putAsync(final String key, final String value) throws ExecutionException, InterruptedException {
        if (this.future != null) {
            this.future.get();
        }
        return this.executor.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return WorkerThread.this.remoteCache.put((Object)key, (Object)value);
            }
        });
    }

    public Future<?> stress() throws InterruptedException, ExecutionException {
        if (this.future != null) {
            this.future.get();
        }
        return this.executor.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                WorkerThread.this.stressInternal();
                return null;
            }
        });
    }

    public void stop() {
        this.executor.shutdown();
    }

    public void awaitTermination() throws InterruptedException, ExecutionException {
        this.executor.awaitTermination(1L, TimeUnit.SECONDS);
        if (this.future != null) {
            this.future.get();
        }
    }
}

