/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.retry;

import java.util.Properties;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.HitsAwareCacheManagersTest;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.impl.transport.tcp.RoundRobinBalancingStrategy;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory;
import org.infinispan.config.Configuration;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;

public abstract class AbstractRetryTest
extends HitsAwareCacheManagersTest {
    protected HotRodServer hotRodServer1;
    protected HotRodServer hotRodServer2;
    protected HotRodServer hotRodServer3;
    RemoteCacheImpl remoteCache;
    protected RemoteCacheManager remoteCacheManager;
    protected TcpTransportFactory tcpConnectionFactory;
    protected Configuration config;
    protected RoundRobinBalancingStrategy strategy;

    public AbstractRetryTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    protected void assertSupportedConfig() {
    }

    protected void createCacheManagers() throws Throwable {
        assert (this.cleanupAfterMethod());
        this.config = this.getCacheConfig();
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createClusteredCacheManager((Configuration)this.config);
        EmbeddedCacheManager cm2 = TestCacheManagerFactory.createClusteredCacheManager((Configuration)this.config);
        EmbeddedCacheManager cm3 = TestCacheManagerFactory.createClusteredCacheManager((Configuration)this.config);
        this.registerCacheManager(new CacheContainer[]{cm1});
        this.registerCacheManager(new CacheContainer[]{cm2});
        this.registerCacheManager(new CacheContainer[]{cm3});
        this.hotRodServer1 = TestHelper.startHotRodServer(this.manager(0));
        this.hrServ2CacheManager.put(this.getAddress(this.hotRodServer1), cm1);
        this.hotRodServer2 = TestHelper.startHotRodServer(this.manager(1));
        this.hrServ2CacheManager.put(this.getAddress(this.hotRodServer2), cm2);
        this.hotRodServer3 = TestHelper.startHotRodServer(this.manager(2));
        this.hrServ2CacheManager.put(this.getAddress(this.hotRodServer3), cm3);
        this.manager(0).getCache();
        this.manager(1).getCache();
        this.manager(2).getCache();
        this.waitForClusterToForm();
        Properties clientConfig = new Properties();
        clientConfig.put("infinispan.client.hotrod.server_list", "localhost:" + this.hotRodServer2.getPort());
        clientConfig.put("infinispan.client.hotrod.force_return_values", "true");
        clientConfig.put("maxActive", (Object)1);
        this.remoteCacheManager = new RemoteCacheManager(clientConfig);
        this.remoteCache = (RemoteCacheImpl)this.remoteCacheManager.getCache();
        this.tcpConnectionFactory = (TcpTransportFactory)TestingUtil.extractField((Object)this.remoteCacheManager, (String)"transportFactory");
        this.strategy = (RoundRobinBalancingStrategy)this.tcpConnectionFactory.getBalancer();
        this.addInterceptors();
        assert (this.cacheManagers.size() == 3);
    }

    protected abstract Configuration getCacheConfig();

    protected void waitForClusterToForm() {
        TestingUtil.blockUntilViewReceived((Cache)this.manager(0).getCache(), (int)3, (long)10000L);
        TestingUtil.blockUntilCacheStatusAchieved((Cache)this.manager(0).getCache(), (ComponentStatus)ComponentStatus.RUNNING, (long)10000L);
        TestingUtil.blockUntilCacheStatusAchieved((Cache)this.manager(1).getCache(), (ComponentStatus)ComponentStatus.RUNNING, (long)10000L);
        TestingUtil.blockUntilCacheStatusAchieved((Cache)this.manager(2).getCache(), (ComponentStatus)ComponentStatus.RUNNING, (long)10000L);
    }
}

