/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Immutable
public class PingOperation
extends HotRodOperation {
    private static final Log log = LogFactory.getLog(PingOperation.class);
    private final Transport transport;

    public PingOperation(AtomicInteger topologyId, Transport transport) {
        this(topologyId, transport, DEFAULT_CACHE_NAME_BYTES);
    }

    public PingOperation(AtomicInteger topologyId, Transport transport, byte[] cacheName) {
        super(null, cacheName, topologyId);
        this.transport = transport;
    }

    public PingResult execute() {
        try {
            long messageId = this.writeHeader(this.transport, (short)23);
            this.transport.flush();
            short respStatus = this.readHeaderAndValidate(this.transport, messageId, (short)24);
            if (respStatus == 0) {
                if (log.isTraceEnabled()) {
                    log.tracef("Successfully validated transport: %s", (Object)this.transport);
                }
                return PingResult.SUCCESS;
            }
            if (log.isTraceEnabled()) {
                log.tracef("Unknown response status: %s", (Object)respStatus);
            }
            return PingResult.FAIL;
        }
        catch (HotRodClientException e) {
            if (e.getMessage().contains("CacheNotFoundException")) {
                return PingResult.CACHE_DOES_NOT_EXIST;
            }
            return PingResult.FAIL;
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.tracef((Throwable)e, "Failed to validate transport: %s", (Object)this.transport);
            }
            return PingResult.FAIL;
        }
    }

    public static enum PingResult {
        SUCCESS,
        CACHE_DOES_NOT_EXIST,
        FAIL;

    }
}

