/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.protocol;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.exceptions.InvalidResponseException;
import org.infinispan.client.hotrod.exceptions.RemoteNodeSuspecException;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.util.Util;

public class Codec10
implements Codec {
    private static final Log log = LogFactory.getLog(Codec10.class, Log.class);
    static final AtomicLong MSG_ID = new AtomicLong();

    @Override
    public HeaderParams writeHeader(Transport transport, HeaderParams params) {
        return this.writeHeader(transport, params, (byte)10);
    }

    protected HeaderParams writeHeader(Transport transport, HeaderParams params, byte version) {
        transport.writeByte((short)160);
        transport.writeVLong(params.messageId((long)Codec10.MSG_ID.incrementAndGet()).messageId);
        transport.writeByte(version);
        transport.writeByte(params.opCode);
        transport.writeArray(params.cacheName);
        int flagInt = 0;
        if (params.flags != null) {
            for (Flag flag : params.flags) {
                flagInt = flag.getFlagInt() | flagInt;
            }
        }
        transport.writeVInt(flagInt);
        transport.writeByte(params.clientIntel);
        transport.writeVInt(params.topologyId.get());
        transport.writeByte(params.txMarker);
        log.tracef("Wrote header for message %d. Operation code: %#04x. Flags: %#x", params.messageId, params.opCode, flagInt);
        return params;
    }

    @Override
    public short readHeader(Transport transport, HeaderParams params) {
        short magic = transport.readByte();
        boolean isTrace = log.isTraceEnabled();
        if (magic != 161) {
            String message = "Invalid magic number. Expected %#x and received %#x";
            log.invalidMagicNumber((short)161, magic);
            if (isTrace) {
                log.tracef("Socket dump: %s", Util.hexDump((byte[])transport.dumpStream()));
            }
            throw new InvalidResponseException(String.format(message, (short)161, magic));
        }
        long receivedMessageId = transport.readVLong();
        if (receivedMessageId != params.messageId) {
            String message = "Invalid message id. Expected %d and received %d";
            log.invalidMessageId(params.messageId, receivedMessageId);
            if (isTrace) {
                log.tracef("Socket dump: %s", Util.hexDump((byte[])transport.dumpStream()));
            }
            throw new InvalidResponseException(String.format(message, params.messageId, receivedMessageId));
        }
        log.tracef("Received response for message id: %d", receivedMessageId);
        short receivedOpCode = transport.readByte();
        if (receivedOpCode != params.opRespCode) {
            if (receivedOpCode == 80) {
                this.checkForErrorsInResponseStatus(transport, params, transport.readByte());
            }
            throw new InvalidResponseException(String.format("Invalid response operation. Expected %#x and received %#x", params.opRespCode, receivedOpCode));
        }
        log.tracef("Received operation code is: %#04x", receivedOpCode);
        short status = transport.readByte();
        this.readNewTopologyIfPresent(transport, params);
        return status;
    }

    private void checkForErrorsInResponseStatus(Transport transport, HeaderParams params, short status) {
        boolean isTrace = log.isTraceEnabled();
        if (isTrace) {
            log.tracef("Received operation status: %#x", status);
        }
        switch (status) {
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: {
                this.readNewTopologyIfPresent(transport, params);
                String msgFromServer = transport.readString();
                if (status == 134 && isTrace) {
                    log.tracef("Server-side timeout performing operation: %s", msgFromServer);
                }
                if (msgFromServer.contains("SuspectException")) {
                    if (isTrace) {
                        log.tracef("A remote node was suspected while executing messageId=%d. Check if retry possible. Message from server: %s", params.messageId, msgFromServer);
                    }
                    throw new RemoteNodeSuspecException(msgFromServer, params.messageId, status);
                }
                log.errorFromServer(msgFromServer);
                throw new HotRodClientException(msgFromServer, params.messageId, status);
            }
        }
        throw new IllegalStateException(String.format("Unknown status: %#04x", status));
    }

    private void readNewTopologyIfPresent(Transport transport, HeaderParams params) {
        short topologyChangeByte = transport.readByte();
        if (topologyChangeByte == 1) {
            this.readNewTopologyAndHash(transport, params.topologyId);
        }
    }

    protected void readNewTopologyAndHash(Transport transport, AtomicInteger topologyId) {
        int newTopologyId = transport.readVInt();
        topologyId.set(newTopologyId);
        int numKeyOwners = transport.readUnsignedShort();
        short hashFunctionVersion = transport.readByte();
        int hashSpace = transport.readVInt();
        int clusterSize = transport.readVInt();
        log.tracef("Topology change request: newTopologyId=%d, numKeyOwners=%d, hashFunctionVersion=%d, hashSpaceSize=%d, clusterSize=%d", new Object[]{newTopologyId, numKeyOwners, hashFunctionVersion, hashSpace, clusterSize});
        LinkedHashMap<SocketAddress, Set<Integer>> servers2Hash = new LinkedHashMap<SocketAddress, Set<Integer>>();
        for (int i = 0; i < clusterSize; ++i) {
            String host = transport.readString();
            int port = transport.readUnsignedShort();
            log.tracef("Server read: %s:%d", host, port);
            int hashCode = transport.read4ByteInt();
            InetSocketAddress address = new InetSocketAddress(host, port);
            HashSet<Integer> hashes = (HashSet<Integer>)servers2Hash.get(address);
            if (hashes == null) {
                hashes = new HashSet<Integer>();
                servers2Hash.put(address, hashes);
            }
            hashes.add(hashCode);
            log.tracef("Hash code is: %d", hashCode);
        }
        if (log.isInfoEnabled()) {
            log.newTopology(servers2Hash.keySet());
        }
        transport.getTransportFactory().updateServers(servers2Hash.keySet());
        if (hashFunctionVersion == 0) {
            log.trace("Not using a consistent hash function (hash function version == 0).");
        } else {
            transport.getTransportFactory().updateHashFunction(servers2Hash, numKeyOwners, hashFunctionVersion, hashSpace);
        }
    }
}

