/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.impl.MetadataValueImpl;
import org.infinispan.client.hotrod.impl.operations.AbstractKeyOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

@Immutable
public class GetWithMetadataOperation
extends AbstractKeyOperation<MetadataValue<byte[]>> {
    private static final Log log = LogFactory.getLog(GetWithMetadataOperation.class);

    public GetWithMetadataOperation(Codec codec, TransportFactory transportFactory, byte[] key, byte[] cacheName, AtomicInteger topologyId, Flag[] flags) {
        super(codec, transportFactory, key, cacheName, false, topologyId, flags);
    }

    @Override
    protected MetadataValue<byte[]> executeOperation(Transport transport) {
        short status = this.sendKeyOperation(this.key, transport, (byte)27, (byte)28);
        MetadataValueImpl<byte[]> result = null;
        if (status == 2) {
            result = null;
        } else if (status == 0) {
            short flags = transport.readByte();
            long creation = -1L;
            int lifespan = -1;
            long lastUsed = -1L;
            int maxIdle = -1;
            if ((flags & 1) != 1) {
                creation = transport.readLong();
                lifespan = transport.readVInt();
            }
            if ((flags & 2) != 2) {
                lastUsed = transport.readLong();
                maxIdle = transport.readVInt();
            }
            long version = transport.readLong();
            if (log.isTraceEnabled()) {
                log.tracef("Received version: %d", version);
            }
            byte[] value = transport.readArray();
            result = new MetadataValueImpl<byte[]>(creation, lifespan, lastUsed, maxIdle, version, value);
        }
        return result;
    }
}

