/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.tcp;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ServerConfiguration;
import org.infinispan.client.hotrod.configuration.SslConfiguration;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHashFactory;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.client.hotrod.impl.transport.tcp.PropsKeyedObjectPoolFactory;
import org.infinispan.client.hotrod.impl.transport.tcp.RequestBalancingStrategy;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransport;
import org.infinispan.client.hotrod.impl.transport.tcp.TransportObjectFactory;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.util.SslContextFactory;
import org.infinispan.commons.util.Util;

@ThreadSafe
public class TcpTransportFactory
implements TransportFactory {
    private static final Log log = LogFactory.getLog(TcpTransportFactory.class, Log.class);
    private final Object lock = new Object();
    private GenericKeyedObjectPool<SocketAddress, TcpTransport> connectionPool;
    private RequestBalancingStrategy balancer;
    private Collection<SocketAddress> servers;
    private ConsistentHash consistentHash;
    private final ConsistentHashFactory hashFactory = new ConsistentHashFactory();
    private volatile boolean tcpNoDelay;
    private volatile int soTimeout;
    private volatile int connectTimeout;
    private volatile int transportCount;
    private volatile SSLContext sslContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Codec codec, Configuration configuration, AtomicInteger topologyId) {
        Object object = this.lock;
        synchronized (object) {
            this.hashFactory.init(configuration);
            boolean pingOnStartup = configuration.pingOnStartup();
            this.servers = new ArrayList<SocketAddress>();
            for (ServerConfiguration server : configuration.servers()) {
                this.servers.add(new InetSocketAddress(server.host(), server.port()));
            }
            this.servers = Collections.unmodifiableCollection(this.servers);
            this.balancer = (RequestBalancingStrategy)Util.getInstance(configuration.balancingStrategy());
            this.tcpNoDelay = configuration.tcpNoDelay();
            this.soTimeout = configuration.socketTimeout();
            this.connectTimeout = configuration.connectionTimeout();
            if (configuration.ssl().enabled()) {
                SslConfiguration ssl = configuration.ssl();
                this.sslContext = ssl.sslContext() != null ? ssl.sslContext() : SslContextFactory.getContext((String)ssl.keyStoreFileName(), (char[])ssl.keyStorePassword(), (String)ssl.trustStoreFileName(), (char[])ssl.trustStorePassword());
            }
            if (log.isDebugEnabled()) {
                log.debugf("Statically configured servers: %s", this.servers);
                log.debugf("Load balancer class: %s", this.balancer.getClass().getName());
                log.debugf("Tcp no delay = %b; client socket timeout = %d ms; connect timeout = %d ms", this.tcpNoDelay, this.soTimeout, this.connectTimeout);
            }
            PropsKeyedObjectPoolFactory<SocketAddress, TcpTransport> poolFactory = new PropsKeyedObjectPoolFactory<SocketAddress, TcpTransport>((KeyedPoolableObjectFactory<SocketAddress, TcpTransport>)new TransportObjectFactory(codec, this, topologyId, pingOnStartup), configuration.connectionPool());
            this.createAndPreparePool(poolFactory);
            this.balancer.setServers(this.servers);
            this.updateTransportCount();
        }
        if (configuration.pingOnStartup()) {
            this.pingServers();
        }
    }

    private void pingServers() {
        GenericKeyedObjectPool<SocketAddress, TcpTransport> pool = this.getConnectionPool();
        for (SocketAddress addr : this.servers) {
            try {
                pool.returnObject((Object)addr, pool.borrowObject((Object)addr));
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) continue;
                log.tracef(e, "Ignoring exception pinging configured servers %s to establish a connection", this.servers);
            }
        }
    }

    private void createAndPreparePool(PropsKeyedObjectPoolFactory<SocketAddress, TcpTransport> poolFactory) {
        this.connectionPool = (GenericKeyedObjectPool)poolFactory.createPool();
        for (SocketAddress addr : this.servers) {
            this.connectionPool.preparePool((Object)addr, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            this.connectionPool.clear();
            try {
                this.connectionPool.close();
            }
            catch (Exception e) {
                log.warn("Exception while shutting down the connection pool.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateHashFunction(Map<SocketAddress, Set<Integer>> servers2Hash, int numKeyOwners, short hashFunctionVersion, int hashSpace) {
        Object object = this.lock;
        synchronized (object) {
            ConsistentHash hash = this.hashFactory.newConsistentHash(hashFunctionVersion);
            if (hash == null) {
                log.noHasHFunctionConfigured(hashFunctionVersion);
            } else {
                hash.init(servers2Hash, numKeyOwners, hashSpace);
            }
            this.consistentHash = hash;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transport getTransport() {
        SocketAddress server;
        Object object = this.lock;
        synchronized (object) {
            server = this.balancer.nextServer();
        }
        return this.borrowTransportFromPool(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transport getTransport(byte[] key) {
        SocketAddress server;
        Object object = this.lock;
        synchronized (object) {
            if (this.consistentHash != null) {
                server = this.consistentHash.getServer(key);
                if (log.isTraceEnabled()) {
                    log.tracef("Using consistent hash for determining the server: " + server, new Object[0]);
                }
            } else {
                server = this.balancer.nextServer();
                if (log.isTraceEnabled()) {
                    log.tracef("Using the balancer for determining the server: %s", server);
                }
            }
        }
        return this.borrowTransportFromPool(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseTransport(Transport transport) {
        GenericKeyedObjectPool<SocketAddress, TcpTransport> pool = this.getConnectionPool();
        TcpTransport tcpTransport = (TcpTransport)transport;
        if (!tcpTransport.isValid()) {
            try {
                if (log.isTraceEnabled()) {
                    log.tracef("Dropping connection as it is no longer valid: %s", tcpTransport);
                }
                pool.invalidateObject((Object)tcpTransport.getServerAddress(), (Object)tcpTransport);
            }
            catch (Exception e) {
                log.couldNoInvalidateConnection(tcpTransport, e);
            }
        } else {
            try {
                pool.returnObject((Object)tcpTransport.getServerAddress(), (Object)tcpTransport);
            }
            catch (Exception e) {
                log.couldNotReleaseConnection(tcpTransport, e);
            }
            finally {
                this.logConnectionInfo(tcpTransport.getServerAddress());
            }
        }
    }

    @Override
    public void invalidateTransport(SocketAddress serverAddress, Transport transport) {
        GenericKeyedObjectPool<SocketAddress, TcpTransport> pool = this.getConnectionPool();
        try {
            pool.invalidateObject((Object)serverAddress, (Object)((TcpTransport)transport));
        }
        catch (Exception e) {
            log.unableToInvalidateTransport(serverAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateServers(Collection<SocketAddress> newServers) {
        Object object = this.lock;
        synchronized (object) {
            HashSet<SocketAddress> addedServers = new HashSet<SocketAddress>(newServers);
            addedServers.removeAll(this.servers);
            HashSet<SocketAddress> failedServers = new HashSet<SocketAddress>(this.servers);
            failedServers.removeAll(newServers);
            if (log.isTraceEnabled()) {
                log.tracef("Current list: %s", this.servers);
                log.tracef("New list: %s", newServers);
                log.tracef("Added servers: %s", addedServers);
                log.tracef("Removed servers: %s", failedServers);
            }
            if (failedServers.isEmpty() && newServers.isEmpty()) {
                log.debug("Same list of servers, not changing the pool");
                return;
            }
            for (SocketAddress server : addedServers) {
                log.newServerAdded(server);
                try {
                    this.connectionPool.addObject((Object)server);
                }
                catch (Exception e) {
                    log.failedAddingNewServer(server, e);
                }
            }
            this.balancer.setServers(newServers);
            for (SocketAddress server : failedServers) {
                log.removingServer(server);
                this.connectionPool.clear((Object)server);
            }
            this.servers = Collections.unmodifiableList(new ArrayList<SocketAddress>(newServers));
            this.updateTransportCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<SocketAddress> getServers() {
        Object object = this.lock;
        synchronized (object) {
            return this.servers;
        }
    }

    private void logConnectionInfo(SocketAddress server) {
        if (log.isTraceEnabled()) {
            GenericKeyedObjectPool<SocketAddress, TcpTransport> pool = this.getConnectionPool();
            log.tracef("For server %s: active = %d; idle = %d", server, pool.getNumActive((Object)server), pool.getNumIdle((Object)server));
        }
    }

    private Transport borrowTransportFromPool(SocketAddress server) {
        GenericKeyedObjectPool<SocketAddress, TcpTransport> pool = this.getConnectionPool();
        try {
            Transport transport = (Transport)pool.borrowObject((Object)server);
            return transport;
        }
        catch (Exception e) {
            String message = "Could not fetch transport";
            log.couldNotFetchTransport(e);
            throw new TransportException(message, e, server);
        }
        finally {
            this.logConnectionInfo(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsistentHash getConsistentHash() {
        Object object = this.lock;
        synchronized (object) {
            return this.consistentHash;
        }
    }

    @Override
    public ConsistentHashFactory getConsistentHashFactory() {
        return this.hashFactory;
    }

    @Override
    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    @Override
    public int getTransportCount() {
        if (Thread.currentThread().isInterrupted()) {
            return -1;
        }
        return this.transportCount;
    }

    @Override
    public int getSoTimeout() {
        return this.soTimeout;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestBalancingStrategy getBalancer() {
        Object object = this.lock;
        synchronized (object) {
            return this.balancer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericKeyedObjectPool<SocketAddress, TcpTransport> getConnectionPool() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionPool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTransportCount() {
        Object object = this.lock;
        synchronized (object) {
            int maxActive = this.connectionPool.getMaxActive();
            this.transportCount = maxActive > 0 ? Math.max(maxActive * this.servers.size(), maxActive) : 10 * this.servers.size();
        }
    }
}

