/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.impl.operations.QueryOperation;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.impl.SortCriteria;
import org.infinispan.query.remote.client.QueryResponse;

public final class RemoteQuery
implements Query {
    private final RemoteCacheImpl cache;
    private final SerializationContext serializationContext;
    private final String jpqlString;
    private final List<SortCriteria> sortCriteria;
    private final long startOffset;
    private final int maxResults;
    private List results = null;
    private int totalResults;

    public RemoteQuery(RemoteCacheImpl cache, SerializationContext serializationContext, String jpqlString, List<SortCriteria> sortCriteria, long startOffset, int maxResults) {
        this.cache = cache;
        this.serializationContext = serializationContext;
        this.jpqlString = jpqlString;
        this.sortCriteria = sortCriteria;
        this.startOffset = startOffset;
        this.maxResults = maxResults;
    }

    public RemoteCacheImpl getCache() {
        return this.cache;
    }

    public String getJpqlString() {
        return this.jpqlString;
    }

    public List<SortCriteria> getSortCriteria() {
        return this.sortCriteria;
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public <T> List<T> list() {
        if (this.results == null) {
            this.results = this.executeQuery();
        }
        return this.results;
    }

    private List<Object> executeQuery() {
        ArrayList<Object> results;
        QueryOperation op = this.cache.getOperationsFactory().newQueryOperation(this);
        QueryResponse response = (QueryResponse)op.execute();
        this.totalResults = (int)response.getTotalResults();
        if (response.getProjectionSize() > 0) {
            results = new ArrayList(response.getResults().size() / response.getProjectionSize());
            Iterator it = response.getResults().iterator();
            while (it.hasNext()) {
                Object[] row = new Object[response.getProjectionSize()];
                for (int i = 0; i < response.getProjectionSize(); ++i) {
                    row[i] = ((WrappedMessage)it.next()).getValue();
                }
                results.add(row);
            }
        } else {
            results = new ArrayList<Object>(response.getResults().size());
            SerializationContext serCtx = this.getSerializationContext();
            for (WrappedMessage r : response.getResults()) {
                try {
                    byte[] bytes = (byte[])r.getValue();
                    Object o = ProtobufUtil.fromWrappedByteArray((SerializationContext)serCtx, (byte[])bytes);
                    results.add(o);
                }
                catch (IOException e) {
                    throw new HotRodClientException(e);
                }
            }
        }
        return results;
    }

    public int getResultSize() {
        this.list();
        return this.totalResults;
    }

    public SerializationContext getSerializationContext() {
        return this.serializationContext;
    }
}

