/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.tcp;

import java.net.SocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.Subject;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import org.infinispan.client.hotrod.configuration.AuthenticationConfiguration;
import org.infinispan.client.hotrod.impl.operations.AuthMechListOperation;
import org.infinispan.client.hotrod.impl.operations.AuthOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransport;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory;
import org.infinispan.client.hotrod.impl.transport.tcp.TransportObjectFactory;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

public class SaslTransportObjectFactory
extends TransportObjectFactory {
    private static final Log log = LogFactory.getLog(SaslTransportObjectFactory.class);
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final String AUTH_INT = "auth-int";
    private static final String AUTO_CONF = "auth-conf";
    private final AuthenticationConfiguration configuration;

    public SaslTransportObjectFactory(Codec codec, TcpTransportFactory tcpTransportFactory, AtomicInteger topologyId, boolean pingOnStartup, AuthenticationConfiguration configuration) {
        super(codec, tcpTransportFactory, topologyId, pingOnStartup);
        this.configuration = configuration;
    }

    @Override
    public TcpTransport makeObject(SocketAddress address) throws Exception {
        List<String> serverMechs;
        TcpTransport tcpTransport = new TcpTransport(address, this.tcpTransportFactory);
        if (log.isTraceEnabled()) {
            log.tracef("Created tcp transport: %s", tcpTransport);
        }
        if (!(serverMechs = this.mechList(tcpTransport, this.topologyId)).contains(this.configuration.saslMechanism())) {
            throw log.unsupportedMech(this.configuration.saslMechanism(), serverMechs);
        }
        SaslClient saslClient = this.configuration.clientSubject() != null ? Subject.doAs(this.configuration.clientSubject(), new PrivilegedExceptionAction<SaslClient>(){

            @Override
            public SaslClient run() throws Exception {
                return Sasl.createSaslClient(new String[]{SaslTransportObjectFactory.this.configuration.saslMechanism()}, null, "hotrod", SaslTransportObjectFactory.this.configuration.serverName(), SaslTransportObjectFactory.this.configuration.saslProperties(), SaslTransportObjectFactory.this.configuration.callbackHandler());
            }
        }) : Sasl.createSaslClient(new String[]{this.configuration.saslMechanism()}, null, "hotrod", this.configuration.serverName(), this.configuration.saslProperties(), this.configuration.callbackHandler());
        if (log.isTraceEnabled()) {
            log.tracef("Authenticating using mech: %s", this.configuration.saslMechanism());
        }
        byte[] response = saslClient.hasInitialResponse() ? saslClient.evaluateChallenge(EMPTY_BYTES) : EMPTY_BYTES;
        byte[] challenge = this.auth(tcpTransport, this.topologyId, this.configuration.saslMechanism(), response);
        while (!saslClient.isComplete() && challenge != null) {
            response = saslClient.evaluateChallenge(challenge);
            challenge = this.auth(tcpTransport, this.topologyId, "", response);
        }
        saslClient.dispose();
        if (this.pingOnStartup && !this.firstPingExecuted) {
            log.trace("Executing first ping!");
            this.firstPingExecuted = true;
            this.ping(tcpTransport, this.topologyId);
        }
        return tcpTransport;
    }

    private List<String> mechList(TcpTransport tcpTransport, AtomicInteger topologyId) {
        AuthMechListOperation op = new AuthMechListOperation(this.codec, topologyId, tcpTransport);
        return op.execute();
    }

    private byte[] auth(TcpTransport tcpTransport, AtomicInteger topologyId, String mech, byte[] response) {
        AuthOperation op = new AuthOperation(this.codec, topologyId, tcpTransport, mech, response);
        return op.execute();
    }
}

