/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.protocol;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.event.ClientCacheEntryCreatedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryCustomEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryModifiedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryRemovedEvent;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.exceptions.InvalidResponseException;
import org.infinispan.client.hotrod.exceptions.RemoteIllegalLifecycleStateException;
import org.infinispan.client.hotrod.exceptions.RemoteNodeSuspectException;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Either;
import org.infinispan.commons.util.Util;

public class Codec20
implements Codec,
HotRodConstants {
    private static final Log log = LogFactory.getLog(Codec20.class, Log.class);
    static final AtomicLong MSG_ID = new AtomicLong();
    final boolean trace = this.getLog().isTraceEnabled();

    @Override
    public HeaderParams writeHeader(Transport transport, HeaderParams params) {
        return this.writeHeader(transport, params, (byte)20);
    }

    protected HeaderParams writeHeader(Transport transport, HeaderParams params, byte version) {
        transport.writeByte((short)160);
        transport.writeVLong(params.messageId((long)Codec20.MSG_ID.incrementAndGet()).messageId);
        transport.writeByte(version);
        transport.writeByte(params.opCode);
        transport.writeArray(params.cacheName);
        int joinedFlags = HeaderParams.joinFlags(params.flags);
        transport.writeVInt(joinedFlags);
        transport.writeByte(params.clientIntel);
        transport.writeVInt(params.topologyId.get());
        if (this.trace) {
            this.getLog().tracef("Wrote header for message %d. Operation code: %#04x. Flags: %#x", params.messageId, params.opCode, joinedFlags);
        }
        return params;
    }

    @Override
    public short readHeader(Transport transport, HeaderParams params) {
        short magic = this.readMagic(transport);
        long receivedMessageId = this.readMessageId(transport, params);
        short receivedOpCode = transport.readByte();
        return this.readPartialHeader(transport, params, receivedOpCode);
    }

    private short readPartialHeader(Transport transport, HeaderParams params, short receivedOpCode) {
        short status = transport.readByte();
        this.readNewTopologyIfPresent(transport, params);
        if (receivedOpCode != params.opRespCode) {
            if (receivedOpCode == 80) {
                this.checkForErrorsInResponseStatus(transport, params, status);
            }
            throw new InvalidResponseException(String.format("Invalid response operation. Expected %#x and received %#x", params.opRespCode, receivedOpCode));
        }
        if (this.trace) {
            this.getLog().tracef("Received operation code is: %#04x", receivedOpCode);
        }
        return status;
    }

    @Override
    public ClientEvent readEvent(Transport transport, byte[] expectedListenerId, Marshaller marshaller) {
        this.readMagic(transport);
        this.readMessageId(transport, null);
        short eventTypeId = transport.readByte();
        return this.readPartialEvent(transport, expectedListenerId, marshaller, eventTypeId);
    }

    private ClientEvent readPartialEvent(Transport transport, byte[] expectedListenerId, Marshaller marshaller, short eventTypeId) {
        boolean isRetried;
        ClientEvent.Type eventType;
        short status = transport.readByte();
        transport.readByte();
        switch (eventTypeId) {
            case 96: {
                eventType = ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED;
                break;
            }
            case 97: {
                eventType = ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED;
                break;
            }
            case 98: {
                eventType = ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED;
                break;
            }
            case 80: {
                this.checkForErrorsInResponseStatus(transport, null, status);
            }
            default: {
                throw log.unknownEvent(eventTypeId);
            }
        }
        byte[] listenerId = transport.readArray();
        if (!Arrays.equals(listenerId, expectedListenerId)) {
            throw log.unexpectedListenerId(Util.printArray((byte[])listenerId), Util.printArray((byte[])expectedListenerId));
        }
        short isCustom = transport.readByte();
        boolean bl = isRetried = transport.readByte() == 1;
        if (isCustom == 1) {
            Object eventData = MarshallerUtil.bytes2obj(marshaller, transport.readArray());
            return this.createCustomEvent(eventData, eventType, isRetried);
        }
        switch (eventType) {
            case CLIENT_CACHE_ENTRY_CREATED: {
                Object createdKey = MarshallerUtil.bytes2obj(marshaller, transport.readArray());
                long createdDataVersion = transport.readLong();
                return this.createCreatedEvent(createdKey, createdDataVersion, isRetried);
            }
            case CLIENT_CACHE_ENTRY_MODIFIED: {
                Object modifiedKey = MarshallerUtil.bytes2obj(marshaller, transport.readArray());
                long modifiedDataVersion = transport.readLong();
                return this.createModifiedEvent(modifiedKey, modifiedDataVersion, isRetried);
            }
            case CLIENT_CACHE_ENTRY_REMOVED: {
                Object removedKey = MarshallerUtil.bytes2obj(marshaller, transport.readArray());
                return this.createRemovedEvent(removedKey, isRetried);
            }
        }
        throw log.unknownEvent(eventTypeId);
    }

    @Override
    public Either<Short, ClientEvent> readHeaderOrEvent(Transport transport, HeaderParams params, byte[] expectedListenerId, Marshaller marshaller) {
        this.readMagic(transport);
        this.readMessageId(transport, null);
        short opCode = transport.readByte();
        switch (opCode) {
            case 96: 
            case 97: 
            case 98: {
                ClientEvent clientEvent = this.readPartialEvent(transport, expectedListenerId, marshaller, opCode);
                return Either.newRight((Object)clientEvent);
            }
        }
        return Either.newLeft((Object)this.readPartialHeader(transport, params, opCode));
    }

    @Override
    public byte[] returnPossiblePrevValue(Transport transport, short status, Flag[] flags) {
        if (status == 3 || status == 4) {
            byte[] bytes = transport.readArray();
            if (log.isTraceEnabled()) {
                log.tracef("Previous value bytes is: %s", Util.printArray((byte[])bytes, (boolean)false));
            }
            return bytes.length == 0 ? null : bytes;
        }
        return null;
    }

    private ClientEvent createRemovedEvent(final Object key, final boolean isRetried) {
        return new ClientCacheEntryRemovedEvent(){

            public Object getKey() {
                return key;
            }

            @Override
            public ClientEvent.Type getType() {
                return ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED;
            }

            @Override
            public boolean isCommandRetried() {
                return isRetried;
            }

            public String toString() {
                return "ClientCacheEntryRemovedEvent(key=" + key + ")";
            }
        };
    }

    private ClientCacheEntryModifiedEvent createModifiedEvent(final Object key, final long dataVersion, final boolean isRetried) {
        return new ClientCacheEntryModifiedEvent(){

            public Object getKey() {
                return key;
            }

            @Override
            public long getVersion() {
                return dataVersion;
            }

            @Override
            public ClientEvent.Type getType() {
                return ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED;
            }

            @Override
            public boolean isCommandRetried() {
                return isRetried;
            }

            public String toString() {
                return "ClientCacheEntryModifiedEvent(key=" + key + ",dataVersion=" + dataVersion + ")";
            }
        };
    }

    private ClientCacheEntryCreatedEvent<Object> createCreatedEvent(final Object key, final long dataVersion, final boolean isRetried) {
        return new ClientCacheEntryCreatedEvent<Object>(){

            @Override
            public Object getKey() {
                return key;
            }

            @Override
            public long getVersion() {
                return dataVersion;
            }

            @Override
            public ClientEvent.Type getType() {
                return ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED;
            }

            @Override
            public boolean isCommandRetried() {
                return isRetried;
            }

            public String toString() {
                return "ClientCacheEntryCreatedEvent(key=" + key + ",dataVersion=" + dataVersion + ")";
            }
        };
    }

    private ClientCacheEntryCustomEvent<Object> createCustomEvent(final Object eventData, final ClientEvent.Type eventType, final boolean isRetried) {
        return new ClientCacheEntryCustomEvent<Object>(){

            @Override
            public Object getEventData() {
                return eventData;
            }

            @Override
            public ClientEvent.Type getType() {
                return eventType;
            }

            @Override
            public boolean isCommandRetried() {
                return isRetried;
            }

            public String toString() {
                return "ClientCacheEntryCustomEvent(eventData=" + eventData + ", eventType=" + (Object)((Object)eventType) + ")";
            }
        };
    }

    private long readMessageId(Transport transport, HeaderParams params) {
        long receivedMessageId = transport.readVLong();
        Log localLog = this.getLog();
        if (params != null && receivedMessageId != params.messageId && receivedMessageId != 0L) {
            String message = "Invalid message id. Expected %d and received %d";
            localLog.invalidMessageId(params.messageId, receivedMessageId);
            if (this.trace) {
                localLog.tracef("Socket dump: %s", Util.hexDump((byte[])transport.dumpStream()));
            }
            throw new InvalidResponseException(String.format(message, params.messageId, receivedMessageId));
        }
        if (this.trace) {
            localLog.tracef("Received response for message id: %d", receivedMessageId);
        }
        return receivedMessageId;
    }

    private short readMagic(Transport transport) {
        short magic = transport.readByte();
        if (magic != 161) {
            Log localLog = this.getLog();
            String message = "Invalid magic number. Expected %#x and received %#x";
            localLog.invalidMagicNumber((short)161, magic);
            if (this.trace) {
                localLog.tracef("Socket dump: %s", Util.hexDump((byte[])transport.dumpStream()));
            }
            throw new InvalidResponseException(String.format(message, (short)161, magic));
        }
        return magic;
    }

    @Override
    public Log getLog() {
        return log;
    }

    protected void checkForErrorsInResponseStatus(Transport transport, HeaderParams params, short status) {
        Log localLog = this.getLog();
        boolean isTrace = localLog.isTraceEnabled();
        if (isTrace) {
            localLog.tracef("Received operation status: %#x", status);
        }
        try {
            switch (status) {
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: {
                    String msgFromServer = transport.readString();
                    if (status == 134 && isTrace) {
                        localLog.tracef("Server-side timeout performing operation: %s", msgFromServer);
                    } else {
                        localLog.errorFromServer(msgFromServer);
                    }
                    throw new HotRodClientException(msgFromServer, params.messageId, status);
                }
                case 136: {
                    String msgFromServer = transport.readString();
                    throw new RemoteIllegalLifecycleStateException(msgFromServer, params.messageId, status);
                }
                case 135: {
                    String msgFromServer = transport.readString();
                    if (isTrace) {
                        localLog.tracef("A remote node was suspected while executing messageId=%d. Check if retry possible. Message from server: %s", params.messageId, msgFromServer);
                    }
                    throw new RemoteNodeSuspectException(msgFromServer, params.messageId, status);
                }
            }
            throw new IllegalStateException(String.format("Unknown status: %#04x", status));
        }
        catch (Throwable throwable) {
            switch (status) {
                case 129: 
                case 130: 
                case 131: 
                case 132: {
                    transport.invalidate();
                }
            }
            throw throwable;
        }
    }

    protected void readNewTopologyIfPresent(Transport transport, HeaderParams params) {
        short topologyChangeByte = transport.readByte();
        if (topologyChangeByte == 1) {
            this.readNewTopologyAndHash(transport, params.topologyId, params.cacheName);
        }
    }

    protected void readNewTopologyAndHash(Transport transport, AtomicInteger topologyId, byte[] cacheName) {
        Log localLog = this.getLog();
        int newTopologyId = transport.readVInt();
        topologyId.set(newTopologyId);
        int clusterSize = transport.readVInt();
        SocketAddress[] addresses = new SocketAddress[clusterSize];
        for (int i = 0; i < clusterSize; ++i) {
            String host = transport.readString();
            int port = transport.readUnsignedShort();
            addresses[i] = new InetSocketAddress(host, port);
        }
        short hashFunctionVersion = transport.readByte();
        int numSegments = transport.readVInt();
        SocketAddress[][] segmentOwners = new SocketAddress[numSegments][];
        for (int i = 0; i < numSegments; ++i) {
            int numOwners = transport.readByte();
            segmentOwners[i] = new SocketAddress[numOwners];
            for (int j = 0; j < numOwners; ++j) {
                int memberIndex = transport.readVInt();
                segmentOwners[i][j] = addresses[memberIndex];
            }
        }
        List<SocketAddress> addressList = Arrays.asList(addresses);
        if (localLog.isInfoEnabled()) {
            localLog.newTopology(transport.getRemoteSocketAddress(), newTopologyId, addresses.length, new HashSet<SocketAddress>(addressList));
        }
        transport.getTransportFactory().updateServers(addressList, cacheName);
        if (hashFunctionVersion == 0) {
            if (this.trace) {
                localLog.trace("Not using a consistent hash function (hash function version == 0).");
            }
        } else {
            transport.getTransportFactory().updateHashFunction(segmentOwners, numSegments, hashFunctionVersion, cacheName);
        }
    }
}

