/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.iteration;

import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.impl.iteration.KeyTracker;
import org.infinispan.client.hotrod.impl.iteration.KeyTrackerFactory;
import org.infinispan.client.hotrod.impl.operations.IterationEndResponse;
import org.infinispan.client.hotrod.impl.operations.IterationNextOperation;
import org.infinispan.client.hotrod.impl.operations.IterationNextResponse;
import org.infinispan.client.hotrod.impl.operations.IterationStartOperation;
import org.infinispan.client.hotrod.impl.operations.IterationStartResponse;
import org.infinispan.client.hotrod.impl.operations.OperationsFactory;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.util.CloseableIterator;

@NotThreadSafe
public class RemoteCloseableIterator<E>
implements CloseableIterator<Map.Entry<Object, E>> {
    private static final Log log = LogFactory.getLog(RemoteCloseableIterator.class);
    private final OperationsFactory operationsFactory;
    private final String filterConverterFactory;
    private final byte[][] filterParams;
    private final Set<Integer> segments;
    private final int batchSize;
    private final boolean metadata;
    private KeyTracker segmentKeyTracker;
    private Transport transport;
    private String iterationId;
    boolean endOfIteration = false;
    boolean closed;
    private Queue<Map.Entry<Object, E>> nextElements = new LinkedList<Map.Entry<Object, E>>();

    public RemoteCloseableIterator(OperationsFactory operationsFactory, String filterConverterFactory, byte[][] filterParams, Set<Integer> segments, int batchSize, boolean metadata) {
        this.filterConverterFactory = filterConverterFactory;
        this.filterParams = filterParams;
        this.segments = segments;
        this.batchSize = batchSize;
        this.operationsFactory = operationsFactory;
        this.metadata = metadata;
    }

    public RemoteCloseableIterator(OperationsFactory operationsFactory, int batchSize, Set<Integer> segments, boolean metadata) {
        this(operationsFactory, null, null, segments, batchSize, metadata);
    }

    public void close() {
        if (!this.closed) {
            IterationEndResponse endResponse = this.operationsFactory.newIterationEndOperation(this.iterationId, this.transport).execute();
            short status = endResponse.getStatus();
            if (HotRodConstants.isSuccess(status)) {
                log.iterationClosed(this.iterationId);
            }
            if (HotRodConstants.isInvalidIteration(status)) {
                throw log.errorClosingIteration(this.iterationId);
            }
            this.closed = true;
        }
    }

    public boolean hasNext() {
        if (!this.endOfIteration && this.nextElements.isEmpty()) {
            this.fetch();
        }
        return !this.endOfIteration;
    }

    public Map.Entry<Object, E> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.nextElements.remove();
    }

    private void fetch() {
        try {
            IterationNextOperation iterationNextOperation = this.operationsFactory.newIterationNextOperation(this.iterationId, this.transport, this.segmentKeyTracker);
            while (this.nextElements.isEmpty() && !this.endOfIteration) {
                Object iterationNextResponse = iterationNextOperation.execute();
                if (!((IterationNextResponse)iterationNextResponse).hasMore()) {
                    this.endOfIteration = true;
                    break;
                }
                this.nextElements.addAll(((IterationNextResponse)iterationNextResponse).getEntries());
            }
        }
        catch (TransportException e) {
            log.warnf(e, "Error reaching the server during iteration", new Object[0]);
            this.restartIteration(this.segmentKeyTracker.missedSegments());
            this.fetch();
        }
    }

    private void restartIteration(Set<Integer> missedSegments) {
        this.startInternal(missedSegments);
    }

    private void start(Set<Integer> fromSegments) {
        IterationStartResponse startResponse = this.startInternal(fromSegments);
        this.segmentKeyTracker = KeyTrackerFactory.create(startResponse.getSegmentConsistentHash(), startResponse.getTopologyId());
    }

    private IterationStartResponse startInternal(Set<Integer> fromSegments) {
        if (log.isDebugEnabled()) {
            log.debugf("Staring iteration with segments %s", fromSegments);
        }
        IterationStartOperation iterationStartOperation = this.operationsFactory.newIterationStartOperation(this.filterConverterFactory, this.filterParams, fromSegments, this.batchSize, this.metadata);
        IterationStartResponse startResponse = (IterationStartResponse)iterationStartOperation.execute();
        this.transport = startResponse.getTransport();
        if (log.isDebugEnabled()) {
            log.debugf("Obtained transport", this.transport);
        }
        this.iterationId = startResponse.getIterationId();
        if (log.isDebugEnabled()) {
            log.debugf("IterationId:", this.iterationId);
        }
        return startResponse;
    }

    public void start() {
        this.start(this.segments);
    }
}

