/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.Buffer;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.equivalence.AnyServerEquivalence;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.scripting.ScriptingManager;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.ExecTest")
public class ExecTest
extends MultiHotRodServersTest {
    private static final String SCRIPT_CACHE = "___script_cache";
    static final int NUM_SERVERS = 2;
    static final int SIZE = 20;

    protected void createCacheManagers() throws Throwable {
        this.createHotRodServers(2, new ConfigurationBuilder());
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp=".*Unknown task 'nonExistent\\.js'.*")
    public void testRemovingNonExistentScript() {
        ((RemoteCacheManager)this.clients.get(0)).getCache().execute("nonExistent.js", new HashMap());
    }

    public void testEmbeddedScriptRemoteExecution() throws IOException {
        String cacheName = "testEmbeddedScriptRemoteExecution";
        ConfigurationBuilder builder = ExecTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)true);
        builder.dataContainer().keyEquivalence((Equivalence)new AnyServerEquivalence()).valueEquivalence((Equivalence)new AnyServerEquivalence()).compatibility().enable().marshaller((Marshaller)new GenericJBossMarshaller());
        this.defineInAll(cacheName, builder);
        ScriptingManager scriptingManager = (ScriptingManager)this.manager(0).getGlobalComponentRegistry().getComponent(ScriptingManager.class);
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/test.js");){
            String script = TestingUtil.loadFileAsString((InputStream)is);
            scriptingManager.addScript("testEmbeddedScriptRemoteExecution.js", script);
        }
        this.populateCache(cacheName);
        AssertJUnit.assertEquals((int)20, (int)((RemoteCacheManager)this.clients.get(0)).getCache(cacheName).size());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("parameter", "guinness");
        Integer result = (Integer)((RemoteCacheManager)this.clients.get(0)).getCache(cacheName).execute("testEmbeddedScriptRemoteExecution.js", params);
        AssertJUnit.assertEquals((int)21, (int)result);
        AssertJUnit.assertEquals((Object)"guinness", (Object)((RemoteCacheManager)this.clients.get(0)).getCache(cacheName).get((Object)"parameter"));
    }

    public void testRemoteScriptRemoteExecution() throws IOException {
        String cacheName = "testRemoteScriptRemoteExecution";
        ConfigurationBuilder builder = ExecTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)true);
        builder.dataContainer().keyEquivalence((Equivalence)new AnyServerEquivalence()).valueEquivalence((Equivalence)new AnyServerEquivalence()).compatibility().enable().marshaller((Marshaller)new GenericJBossMarshaller());
        this.defineInAll(cacheName, builder);
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/test.js");){
            String script = TestingUtil.loadFileAsString((InputStream)is);
            ((RemoteCacheManager)this.clients.get(0)).getCache(SCRIPT_CACHE).put((Object)"testRemoteScriptRemoteExecution.js", (Object)script);
        }
        this.populateCache(cacheName);
        AssertJUnit.assertEquals((int)20, (int)((RemoteCacheManager)this.clients.get(0)).getCache(cacheName).size());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("parameter", "hoptimus prime");
        Integer result = (Integer)((RemoteCacheManager)this.clients.get(0)).getCache(cacheName).execute("testRemoteScriptRemoteExecution.js", params);
        AssertJUnit.assertEquals((int)21, (int)result);
        AssertJUnit.assertEquals((Object)"hoptimus prime", (Object)((RemoteCacheManager)this.clients.get(0)).getCache(cacheName).get((Object)"parameter"));
    }

    private void populateCache(String cacheName) {
        for (int i = 0; i < 20; ++i) {
            ((RemoteCacheManager)this.clients.get(i % 2)).getCache(cacheName).put((Object)String.format("Key %d", i), (Object)String.format("Value %d", i));
        }
    }

    public void testRemoteMapReduce() throws Exception {
        String cacheName = "testRemoteMapReduce";
        ConfigurationBuilder builder = ExecTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)true);
        builder.dataContainer().keyEquivalence((Equivalence)new AnyServerEquivalence()).valueEquivalence((Equivalence)new AnyServerEquivalence()).compatibility().enable().marshaller((Marshaller)new GenericJBossMarshaller());
        this.defineInAll(cacheName, builder);
        RemoteCache cache = ((RemoteCacheManager)this.clients.get(0)).getCache(cacheName);
        RemoteCache scriptCache = ((RemoteCacheManager)this.clients.get(0)).getCache(SCRIPT_CACHE);
        this.loadData((BasicCache<String, String>)cache, "/macbeth.txt");
        this.loadScript((BasicCache<String, String>)scriptCache, "/wordCountMapper.js");
        this.loadScript((BasicCache<String, String>)scriptCache, "/wordCountReducer.js");
        this.loadScript((BasicCache<String, String>)scriptCache, "/wordCountCollator.js");
        Map results = (Map)cache.execute("wordCountMapper.js", new HashMap());
        AssertJUnit.assertEquals((int)20, (int)results.size());
        AssertJUnit.assertTrue((boolean)((Double)results.get("macbeth")).equals(287.0));
    }

    @Test(enabled=false, description="Disabling this test until the distributed scripts in DIST mode are fixed - ISPN-6173")
    public void testRemoteMapReduceWithStreams() throws Exception {
        String cacheName = "testRemoteMapReduce_Streams";
        ConfigurationBuilder builder = ExecTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)true);
        builder.dataContainer().keyEquivalence((Equivalence)new AnyServerEquivalence()).valueEquivalence((Equivalence)new AnyServerEquivalence()).compatibility().enable().marshaller((Marshaller)new GenericJBossMarshaller());
        this.defineInAll(cacheName, builder);
        RemoteCache cache = ((RemoteCacheManager)this.clients.get(0)).getCache(cacheName);
        RemoteCache scriptCache = ((RemoteCacheManager)this.clients.get(0)).getCache(SCRIPT_CACHE);
        this.loadData((BasicCache<String, String>)cache, "/macbeth.txt");
        this.loadScript((BasicCache<String, String>)scriptCache, "/wordCountStream.js");
        Map results = (Map)cache.execute("wordCountStream.js", new HashMap());
        AssertJUnit.assertEquals((int)3209, (int)results.size());
        AssertJUnit.assertTrue((boolean)((Long)results.get("macbeth")).equals(287L));
    }

    @Test(enabled=false, description="Disabling this test until the distributed scripts in DIST mode are fixed - ISPN-6173")
    public void testRemoteMapReduceWithStreams_DistributedMode() throws Exception {
        String cacheName = "testRemoteMapReduce_Streams_dist";
        ConfigurationBuilder builder = ExecTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)true);
        builder.dataContainer().keyEquivalence((Equivalence)new AnyServerEquivalence()).valueEquivalence((Equivalence)new AnyServerEquivalence()).compatibility().enable().marshaller((Marshaller)new GenericJBossMarshaller());
        this.defineInAll(cacheName, builder);
        this.waitForClusterToForm(cacheName);
        RemoteCache cache = ((RemoteCacheManager)this.clients.get(0)).getCache(cacheName);
        RemoteCache scriptCache = ((RemoteCacheManager)this.clients.get(1)).getCache(SCRIPT_CACHE);
        this.loadData((BasicCache<String, String>)cache, "/macbeth.txt");
        this.loadScript((BasicCache<String, String>)scriptCache, "/wordCountStream_dist.js");
        ArrayList results = (ArrayList)cache.execute("wordCountStream_dist.js", new HashMap());
        AssertJUnit.assertEquals((int)2, (int)results.size());
        AssertJUnit.assertEquals((int)3209, (int)((Map)results.get(0)).size());
        AssertJUnit.assertEquals((int)3209, (int)((Map)results.get(1)).size());
        AssertJUnit.assertTrue((boolean)((Long)((Map)results.get(0)).get("macbeth")).equals(287L));
        AssertJUnit.assertTrue((boolean)((Long)((Map)results.get(1)).get("macbeth")).equals(287L));
    }

    @Test(enabled=false, description="Disabling this test until the distributed scripts in DIST mode are fixed - ISPN-6173")
    public void testRemoteMapReduceWithStreams_DistributedMode1() throws Exception {
        String cacheName = "testRemoteMapReduce_Streams_dist1";
        ConfigurationBuilder builder = ExecTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)true);
        builder.dataContainer().keyEquivalence((Equivalence)new AnyServerEquivalence()).valueEquivalence((Equivalence)new AnyServerEquivalence()).compatibility().enable().marshaller((Marshaller)new GenericJBossMarshaller());
        this.defineInAll(cacheName, builder);
        this.waitForClusterToForm(cacheName);
        RemoteCache cache = ((RemoteCacheManager)this.clients.get(1)).getCache(cacheName);
        RemoteCache scriptCache = ((RemoteCacheManager)this.clients.get(1)).getCache(SCRIPT_CACHE);
        this.loadData((BasicCache<String, String>)cache, "/macbeth.txt");
        this.loadScript((BasicCache<String, String>)scriptCache, "/wordCountStream_dist.js");
        this.waitForClusterToForm();
        ArrayList results = (ArrayList)cache.execute("wordCountStream_dist.js", new HashMap());
        AssertJUnit.assertEquals((int)2, (int)results.size());
        AssertJUnit.assertEquals((int)3209, (int)((Map)results.get(0)).size());
        AssertJUnit.assertEquals((int)3209, (int)((Map)results.get(1)).size());
        AssertJUnit.assertTrue((boolean)((Long)((Map)results.get(0)).get("macbeth")).equals(287L));
    }

    private void loadData(BasicCache<String, String> cache, String fileName) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(fileName)));){
            int chunkSize = 10;
            int chunkId = 0;
            CharBuffer cbuf = CharBuffer.allocate(1024 * chunkSize);
            while (bufferedReader.read(cbuf) >= 0) {
                Buffer buffer = cbuf.flip();
                String textChunk = buffer.toString();
                cache.put((Object)(fileName + chunkId++), (Object)textChunk);
                cbuf.clear();
            }
        }
    }

    private void loadScript(BasicCache<String, String> scriptCache, String fileName) throws IOException {
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(fileName);){
            String script = TestingUtil.loadFileAsString((InputStream)is);
            scriptCache.put((Object)fileName.replaceAll("\\/", ""), (Object)script);
        }
    }
}

