/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.scripting.ScriptingManager;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.ExecTypedTest")
public class ExecTypedTest
extends MultiHotRodServersTest {
    private static final String SCRIPT_CACHE = "___script_cache";
    private static final int NUM_SERVERS = 2;

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = ExecTypedTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false);
        builder.dataContainer().keyEquivalence((Equivalence)AnyEquivalence.getInstance()).valueEquivalence((Equivalence)AnyEquivalence.getInstance());
        this.createHotRodServers(2, builder);
    }

    public void testRemoteTypedScriptPutGetExecute() throws Exception {
        this.loadScript("testRemoteTypedScriptPutGetExecute.js", "/typed-put-get.js");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("k", "typed-key");
        params.put("v", "typed-value");
        String result = (String)((RemoteCacheManager)this.clients.get(0)).getCache().execute("testRemoteTypedScriptPutGetExecute.js", params);
        AssertJUnit.assertEquals((String)"typed-value", (String)result);
    }

    private void loadScript(String name, String scriptName) throws IOException {
        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(scriptName);){
            String script = TestingUtil.loadFileAsString((InputStream)is);
            ScriptingManager scriptingManager = (ScriptingManager)this.manager(0).getGlobalComponentRegistry().getComponent(ScriptingManager.class);
            scriptingManager.addScript(name, script);
        }
    }
}

