/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.equivalence.AnyServerEquivalence;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.ExpiryTest")
public class MixedExpiryTest
extends MultiHotRodServersTest {
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = MixedExpiryTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false);
        builder.dataContainer().keyEquivalence((Equivalence)new AnyServerEquivalence());
        this.configure(builder);
        this.createHotRodServers(1, builder);
    }

    protected void configure(ConfigurationBuilder configurationBuilder) {
    }

    public void testMixedExpiryLifespan() {
        RemoteCacheManager client0 = this.client(0);
        RemoteCache cache0 = client0.getCache();
        String key = "someKey";
        AssertJUnit.assertNull((Object)cache0.put((Object)key, (Object)"value1", 1000L, TimeUnit.SECONDS, 1000L, TimeUnit.SECONDS));
        AssertJUnit.assertEquals((String)"value1", (String)((String)cache0.get((Object)key)));
        this.assertMetadataAndValue(cache0.getWithMetadata((Object)key), "value1", 1000L, 1000L);
        AssertJUnit.assertEquals((String)"value1", (String)((String)cache0.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)key, (Object)"value2", -1L, TimeUnit.SECONDS, 1000L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((String)"value2", (String)((String)cache0.get((Object)key)));
        this.assertMetadataAndValue(cache0.getWithMetadata((Object)key), "value2", -1L, 1000L);
        AssertJUnit.assertEquals((String)"value2", (String)((String)cache0.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)key, (Object)"value3", -1L, TimeUnit.SECONDS, 1000L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((String)"value3", (String)((String)cache0.get((Object)key)));
        this.assertMetadataAndValue(cache0.getWithMetadata((Object)key), "value3", -1L, 1000L);
    }

    public void testMixedExpiryMaxIdle() {
        RemoteCacheManager client0 = this.client(0);
        RemoteCache cache0 = client0.getCache();
        String key = "someKey";
        AssertJUnit.assertNull((Object)cache0.put((Object)key, (Object)"value1", 1000L, TimeUnit.SECONDS, 1000L, TimeUnit.SECONDS));
        AssertJUnit.assertEquals((String)"value1", (String)((String)cache0.get((Object)key)));
        this.assertMetadataAndValue(cache0.getWithMetadata((Object)key), "value1", 1000L, 1000L);
        AssertJUnit.assertEquals((String)"value1", (String)((String)cache0.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)key, (Object)"value2", 1000L, TimeUnit.SECONDS, -1L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((String)"value2", (String)((String)cache0.get((Object)key)));
        this.assertMetadataAndValue(cache0.getWithMetadata((Object)key), "value2", 1000L, -1L);
        AssertJUnit.assertEquals((String)"value2", (String)((String)cache0.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)key, (Object)"value3", 1000L, TimeUnit.SECONDS, -1L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((String)"value3", (String)((String)cache0.get((Object)key)));
        this.assertMetadataAndValue(cache0.getWithMetadata((Object)key), "value3", 1000L, -1L);
    }

    private <V> void assertMetadataAndValue(MetadataValue<V> metadataValue, V value, long lifespanSeconds, long maxIdleSeconds) {
        AssertJUnit.assertEquals(value, (Object)metadataValue.getValue());
        AssertJUnit.assertEquals((long)lifespanSeconds, (long)metadataValue.getLifespan());
        AssertJUnit.assertEquals((long)maxIdleSeconds, (long)metadataValue.getMaxIdle());
    }
}

