/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.client.hotrod.event.EventLogListener;
import org.infinispan.client.hotrod.event.FailoverEventLogListener;
import org.infinispan.client.hotrod.event.StickyServerLoadBalancingStrategy;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.manager.CacheContainer;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.ControlledTimeService;
import org.infinispan.util.TimeService;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.ClientClusterFailoverEventsTest")
public class ClientClusterFailoverEventsTest
extends MultiHotRodServersTest {
    protected ControlledTimeService ts0;
    protected ControlledTimeService ts1;

    protected void createCacheManagers() throws Throwable {
    }

    private void injectTimeServices() {
        this.ts0 = new ControlledTimeService(0L);
        TestingUtil.replaceComponent((CacheContainer)this.server(0).getCacheManager(), TimeService.class, (Object)this.ts0, (boolean)true);
        this.ts1 = new ControlledTimeService(0L);
        TestingUtil.replaceComponent((CacheContainer)this.server(1).getCacheManager(), TimeService.class, (Object)this.ts1, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEventReplayWithAndWithoutStateAfterFailover() {
        org.infinispan.configuration.cache.ConfigurationBuilder base = ClientClusterFailoverEventsTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)base);
        this.createHotRodServers(2, builder);
        this.injectTimeServices();
        try {
            Integer key00 = HotRodClientTestingUtil.getIntKeyForServer(this.server(0));
            Integer key10 = HotRodClientTestingUtil.getIntKeyForServer(this.server(0));
            Integer key11 = HotRodClientTestingUtil.getIntKeyForServer(this.server(1));
            Integer key21 = HotRodClientTestingUtil.getIntKeyForServer(this.server(1));
            Integer key31 = HotRodClientTestingUtil.getIntKeyForServer(this.server(1));
            Integer key41 = HotRodClientTestingUtil.getIntKeyForServer(this.server(1));
            ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
            HotRodServer server = this.server(0);
            clientBuilder.addServers(server.getHost() + ":" + server.getPort());
            clientBuilder.balancingStrategy(StickyServerLoadBalancingStrategy.class);
            RemoteCacheManager newClient = new RemoteCacheManager(clientBuilder.build());
            try {
                WithStateEventLogListener<Integer> statefulListener = new WithStateEventLogListener<Integer>();
                EventLogListener<Integer> statelessListener = new EventLogListener<Integer>();
                FailoverEventLogListener<Integer> failoverListener = new FailoverEventLogListener<Integer>();
                RemoteCache c = newClient.getCache();
                c.addClientListener(statelessListener);
                c.addClientListener(statefulListener);
                c.addClientListener(failoverListener);
                c.put((Object)key00, (Object)"zero");
                statefulListener.expectOnlyCreatedEvent(key00, this.cache(0));
                statelessListener.expectOnlyCreatedEvent(key00, this.cache(0));
                failoverListener.expectOnlyCreatedEvent(key00, this.cache(0));
                c.put((Object)key10, (Object)"one", 1000L, TimeUnit.MILLISECONDS);
                statefulListener.expectOnlyCreatedEvent(key10, this.cache(0));
                statelessListener.expectOnlyCreatedEvent(key10, this.cache(0));
                failoverListener.expectOnlyCreatedEvent(key10, this.cache(0));
                c.put((Object)key11, (Object)"two");
                statefulListener.expectOnlyCreatedEvent(key11, this.cache(0));
                statelessListener.expectOnlyCreatedEvent(key11, this.cache(0));
                failoverListener.expectOnlyCreatedEvent(key11, this.cache(0));
                c.put((Object)key41, (Object)"three", 1000L, TimeUnit.MILLISECONDS);
                statefulListener.expectOnlyCreatedEvent(key41, this.cache(0));
                statelessListener.expectOnlyCreatedEvent(key41, this.cache(0));
                failoverListener.expectOnlyCreatedEvent(key41, this.cache(0));
                this.ts0.advance(1001L);
                this.ts1.advance(1001L);
                HotRodClientTestingUtil.findServerAndKill(newClient, this.servers, this.cacheManagers);
                c.put((Object)key21, (Object)"four");
                statelessListener.expectNoEvents();
                statefulListener.expectFailoverEvent();
                failoverListener.expectFailoverEvent();
                statelessListener.expectNoEvents();
                failoverListener.expectNoEvents();
                statefulListener.expectUnorderedEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED, key00, key11, key21);
                statefulListener.expectNoEvents();
                c.put((Object)key31, (Object)"five");
                statefulListener.expectUnorderedEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED, key31);
                c.remove((Object)key11);
                c.remove((Object)key21);
                c.remove((Object)key31);
            }
            finally {
                HotRodClientTestingUtil.killRemoteCacheManager(newClient);
            }
        }
        finally {
            this.destroy();
        }
    }

    @ClientListener(includeCurrentState=true)
    public static class WithStateEventLogListener<K>
    extends FailoverEventLogListener<K> {
    }
}

