/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.iteration;

import java.util.Set;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.impl.iteration.AbstractRemoteIteratorTest;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.iteration.MultiServerCompatTest")
public class MultiServerCompatTest
extends MultiHotRodServersTest
implements AbstractRemoteIteratorTest {
    private static final int NUM_SERVERS = 2;
    private static final int CACHE_SIZE = 50;

    protected void createCacheManagers() throws Throwable {
        this.createHotRodServers(2, this.getCacheConfiguration());
    }

    private ConfigurationBuilder getCacheConfiguration() {
        ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)MultiServerCompatTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        builder.clustering().hash().numSegments(60).numOwners(1);
        builder.compatibility().enable();
        builder.dataContainer().keyEquivalence((Equivalence)AnyEquivalence.getInstance());
        return builder;
    }

    @Test
    public void testIteration() throws Exception {
        RemoteCache remoteCache = ((RemoteCacheManager)this.clients.get(0)).getCache();
        this.populateCache(50, i -> "value", remoteCache);
        Set entries = this.extractEntries(remoteCache.retrieveEntries(null, 5));
        AssertJUnit.assertEquals((int)50, (int)entries.size());
    }
}

