/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.marshall;

import java.io.Serializable;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.test.data.Person;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.marshall.WhiteListMarshallingTest", groups={"functional", "smoke"})
public class WhiteListMarshallingTest
extends SingleHotRodServerTest {
    @Override
    protected RemoteCacheManager getRemoteCacheManager() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addJavaSerialWhiteList(new String[]{".*Person.*"});
        builder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort());
        return new InternalRemoteCacheManager(builder.build());
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp=".*ISPN004034:.*")
    public void testUnsafeClassNotAllowed() {
        this.remoteCacheManager.getCache().put((Object)"unsafe", (Object)new UnsafeClass());
        this.remoteCacheManager.getCache().get((Object)"unsafe");
    }

    public void testSafeClassAllowed() {
        this.remoteCacheManager.getCache().put((Object)"safe", (Object)new Person());
        this.remoteCacheManager.getCache().get((Object)"safe");
    }

    private static final class UnsafeClass
    implements Serializable {
        private UnsafeClass() {
        }
    }
}

