/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.management.Attribute;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.query.testdomain.protobuf.AddressPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.UserPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.MarshallerRegistration;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.equivalence.ByteArrayEquivalence;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Index;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.jmx.PerThreadMBeanServerLookup;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.testdomain.User;
import org.infinispan.query.remote.client.ProtobufMetadataManagerMBean;
import org.infinispan.query.remote.impl.indexing.ProtobufValueWrapper;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.query.RemoteQueryJmxTest", groups={"functional"})
public class RemoteQueryJmxTest
extends SingleCacheManagerTest {
    private static final String TEST_CACHE_NAME = "userCache";
    private final String jmxDomain = ((Object)((Object)this)).getClass().getSimpleName();
    private HotRodServer hotRodServer;
    private RemoteCacheManager remoteCacheManager;
    private RemoteCache<Integer, User> remoteCache;
    private MBeanServer mBeanServer;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder().nonClusteredDefault();
        gcb.globalJmxStatistics().enable().allowDuplicateDomains(Boolean.valueOf(true)).jmxDomain(this.jmxDomain).mBeanServerLookup((MBeanServerLookup)new PerThreadMBeanServerLookup());
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.dataContainer().keyEquivalence(ByteArrayEquivalence.INSTANCE).valueEquivalence(ByteArrayEquivalence.INSTANCE).indexing().index(Index.ALL).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        this.cacheManager = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)gcb, (org.infinispan.configuration.cache.ConfigurationBuilder)builder, (boolean)true);
        this.cacheManager.defineConfiguration(TEST_CACHE_NAME, builder.build());
        this.cache = this.cacheManager.getCache(TEST_CACHE_NAME);
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotRodServer.getPort());
        clientBuilder.marshaller((Marshaller)new ProtoStreamMarshaller());
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache(TEST_CACHE_NAME);
        this.mBeanServer = PerThreadMBeanServerLookup.getThreadMBeanServer();
        ProtobufMetadataManagerMBean protobufMetadataManagerMBean = JMX.newMBeanProxy(this.mBeanServer, this.getProtobufMetadataManagerObjectName(), ProtobufMetadataManagerMBean.class);
        String protofile = this.read("/sample_bank_account/bank.proto");
        protobufMetadataManagerMBean.registerProtofile("sample_bank_account/bank.proto", protofile);
        Assert.assertEquals((Object)protofile, (Object)protobufMetadataManagerMBean.getProtofile("sample_bank_account/bank.proto"));
        Assert.assertNull((Object)protobufMetadataManagerMBean.getFilesWithErrors());
        Assert.assertTrue((boolean)Arrays.asList(protobufMetadataManagerMBean.getProtofileNames()).contains("sample_bank_account/bank.proto"));
        MarshallerRegistration.registerMarshallers(ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.remoteCacheManager));
        return this.cacheManager;
    }

    private String read(String classPathResource) throws IOException {
        return Util.read((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(classPathResource));
    }

    @AfterClass(alwaysRun=true)
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer);
    }

    public void testIndexAndQuery() throws Exception {
        ObjectName name = this.getQueryStatsObjectName(TEST_CACHE_NAME);
        Assert.assertTrue((boolean)this.mBeanServer.isRegistered(name));
        Assert.assertFalse((boolean)((Boolean)this.mBeanServer.getAttribute(name, "StatisticsEnabled")));
        this.mBeanServer.setAttribute(name, new Attribute("StatisticsEnabled", true));
        Assert.assertTrue((boolean)((Boolean)this.mBeanServer.getAttribute(name, "StatisticsEnabled")));
        this.remoteCache.put((Object)1, (Object)this.createUser(1));
        this.remoteCache.put((Object)2, (Object)this.createUser(2));
        QueryFactory qf = Search.getQueryFactory(this.remoteCache);
        Query query = qf.from(UserPB.class).having("addresses.postCode").eq((Object)"1231").toBuilder().build();
        List list = query.list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(UserPB.class, ((User)list.get(0)).getClass());
        Assert.assertEquals((Object)"Tom1", (Object)((User)list.get(0)).getName());
        Assert.assertEquals((Object)2, (Object)this.mBeanServer.invoke(name, "getNumberOfIndexedEntities", new Object[]{ProtobufValueWrapper.class.getName()}, new String[]{String.class.getName()}));
        Set classNames = (Set)this.mBeanServer.getAttribute(name, "IndexedClassNames");
        Assert.assertEquals((long)1L, (long)classNames.size());
        Assert.assertTrue((String)"The set should contain the ProtobufValueWrapper class name.", (boolean)classNames.contains(ProtobufValueWrapper.class.getName()));
        Assert.assertTrue((String)"The query execution total time should be > 0.", ((Long)this.mBeanServer.getAttribute(name, "SearchQueryTotalTime") > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)1L, (Object)this.mBeanServer.getAttribute(name, "SearchQueryExecutionCount"));
    }

    private User createUser(int id) {
        UserPB user = new UserPB();
        user.setId(id);
        user.setName("Tom" + id);
        user.setSurname("Cat" + id);
        user.setGender(User.Gender.MALE);
        user.setAccountIds(Collections.singleton(12));
        AddressPB address = new AddressPB();
        address.setStreet("Dark Alley");
        address.setPostCode("123" + id);
        user.setAddresses(Collections.singletonList(address));
        return user;
    }

    private ObjectName getQueryStatsObjectName(String cacheName) throws MalformedObjectNameException {
        String cacheManagerName = this.cacheManager.getCacheManagerConfiguration().globalJmxStatistics().cacheManagerName();
        return new ObjectName(this.jmxDomain + ":type=Query,manager=" + ObjectName.quote(cacheManagerName) + ",cache=" + ObjectName.quote(cacheName) + ",component=Statistics");
    }

    private ObjectName getProtobufMetadataManagerObjectName() throws MalformedObjectNameException {
        String cacheManagerName = this.cacheManager.getCacheManagerConfiguration().globalJmxStatistics().cacheManagerName();
        return new ObjectName(this.jmxDomain + ":type=RemoteQuery,name=" + ObjectName.quote(cacheManagerName) + ",component=" + "ProtobufMetadataManager");
    }
}

