/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.query.testdomain.protobuf.AccountPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.UserPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.MarshallerRegistration;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.equivalence.ByteArrayEquivalence;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Index;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.indexmanager.InfinispanIndexManager;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.query.TwoCachesSharedIndexTest", groups={"functional"})
public class TwoCachesSharedIndexTest
extends MultiHotRodServersTest {
    private static final String USER_CACHE = "users";
    private static final String ACCOUNT_CACHE = "accounts";
    public static final String USER_METADATA = "user_metadata";
    public static final String USER_DATA = "user_data";
    public static final String USER_LOCKING = "user_locking";
    public static final String ACCOUNT_METADATA = "account_metadata";
    public static final String ACCOUNT_DATA = "account_data";
    public static final String ACCOUNT_LOCKING = "account_locking";

    public Configuration buildIndexedConfig(String lockCache, String dataCache, String metadataCache) {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)TwoCachesSharedIndexTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        builder.dataContainer().keyEquivalence(ByteArrayEquivalence.INSTANCE).valueEquivalence(ByteArrayEquivalence.INSTANCE).indexing().index(Index.LOCAL).addProperty("default.indexmanager", InfinispanIndexManager.class.getName()).addProperty("default.metadata_cachename", metadataCache).addProperty("default.data_cachename", dataCache).addProperty("default.locking_cachename", lockCache).addProperty("lucene_version", "LUCENE_CURRENT");
        return builder.build();
    }

    public Configuration getNonIndexLockConfig() {
        return TwoCachesSharedIndexTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false).build();
    }

    public Configuration getNonIndexDataConfig() {
        return TwoCachesSharedIndexTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false).build();
    }

    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder defaultConfiguration = new org.infinispan.configuration.cache.ConfigurationBuilder();
        this.createHotRodServers(2, defaultConfiguration);
        this.cacheManagers.forEach(cm -> {
            cm.defineConfiguration(USER_CACHE, this.buildIndexedConfig(USER_LOCKING, USER_DATA, USER_METADATA));
            cm.defineConfiguration(ACCOUNT_CACHE, this.buildIndexedConfig(ACCOUNT_LOCKING, ACCOUNT_DATA, ACCOUNT_METADATA));
            cm.defineConfiguration(ACCOUNT_METADATA, this.getNonIndexDataConfig());
            cm.defineConfiguration(USER_METADATA, this.getNonIndexDataConfig());
            cm.defineConfiguration(ACCOUNT_DATA, this.getNonIndexDataConfig());
            cm.defineConfiguration(USER_DATA, this.getNonIndexDataConfig());
            cm.defineConfiguration(USER_LOCKING, this.getNonIndexLockConfig());
            cm.defineConfiguration(ACCOUNT_LOCKING, this.getNonIndexLockConfig());
            cm.getCache(USER_CACHE);
            cm.getCache(ACCOUNT_CACHE);
        });
        this.waitForClusterToForm(new String[]{USER_CACHE, ACCOUNT_CACHE});
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(int serverPort) {
        return super.createHotRodClientConfigurationBuilder(serverPort).marshaller((Marshaller)new ProtoStreamMarshaller());
    }

    @BeforeClass(alwaysRun=true)
    protected void registerSerCtx() throws Exception {
        ProtobufMetadataManager protobufMetadataManager = (ProtobufMetadataManager)this.manager(0).getGlobalComponentRegistry().getComponent(ProtobufMetadataManager.class);
        protobufMetadataManager.registerProtofile("sample_bank_account/bank.proto", this.read("/sample_bank_account/bank.proto"));
        for (RemoteCacheManager rcm : this.clients) {
            MarshallerRegistration.registerMarshallers(ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)rcm));
        }
    }

    private String read(String classPathResource) throws IOException {
        return Util.read((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(classPathResource));
    }

    @Test
    public void testWithUserCache() throws IOException {
        RemoteCache userCache = this.client(0).getCache(USER_CACHE);
        userCache.put((Object)1, (Object)this.getUserPB());
        Query query = Search.getQueryFactory((RemoteCache)userCache).from(UserPB.class).having("name").eq((Object)"John").toBuilder().build();
        List users = query.list();
        Assert.assertEquals((String)"John", (String)((UserPB)users.iterator().next()).getName());
    }

    @Test
    public void testWithAccountCache() throws IOException {
        RemoteCache accountCache = this.client(0).getCache(ACCOUNT_CACHE);
        accountCache.put((Object)1, (Object)this.getAccountPB());
        Query query = Search.getQueryFactory((RemoteCache)accountCache).from(AccountPB.class).having("description").eq((Object)"account1").toBuilder().build();
        List accounts = query.list();
        Assert.assertEquals((String)((AccountPB)accounts.iterator().next()).getDescription(), (String)"account1");
    }

    private AccountPB getAccountPB() {
        AccountPB accountPB = new AccountPB();
        accountPB.setId(1);
        accountPB.setDescription("account1");
        accountPB.setCreationDate(new Date());
        return accountPB;
    }

    private UserPB getUserPB() {
        UserPB userPB = new UserPB();
        userPB.setName("John");
        userPB.setSurname("Doe");
        return userPB;
    }
}

