/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter.operation;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.counter.operation.BaseCounterOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;

public class AddOperation
extends BaseCounterOperation<Long> {
    private static final Log commonsLog = (Log)LogFactory.getLog(AddOperation.class, Log.class);
    private final long delta;

    public AddOperation(Codec codec, ChannelFactory channelFactory, AtomicInteger topologyId, Configuration cfg, String counterName, long delta) {
        super(codec, channelFactory, topologyId, cfg, counterName);
        this.delta = delta;
    }

    @Override
    protected void executeOperation(Channel channel) {
        ByteBuf buf = this.getHeaderAndCounterNameBufferAndRead(channel, (short)82, 8);
        buf.writeLong(this.delta);
        channel.writeAndFlush((Object)buf);
    }

    @Override
    public Long decodePayload(ByteBuf buf, short status) {
        this.checkStatus(status);
        this.assertBoundaries(status);
        assert (status == 0);
        return buf.readLong();
    }

    private void assertBoundaries(short status) {
        if (status == 4) {
            if (this.delta > 0L) {
                throw commonsLog.counterOurOfBounds("Upper bound");
            }
            throw commonsLog.counterOurOfBounds("Lower bound");
        }
    }
}

