/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter.operation;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.counter.operation.BaseCounterOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;

public class RemoveListenerOperation
extends BaseCounterOperation<Boolean> {
    private final byte[] listenerId;
    private final SocketAddress server;

    public RemoveListenerOperation(Codec codec, ChannelFactory transportFactory, AtomicInteger topologyId, Configuration cfg, String counterName, byte[] listenerId, SocketAddress server) {
        super(codec, transportFactory, topologyId, cfg, counterName);
        this.listenerId = listenerId;
        this.server = server;
    }

    @Override
    protected void executeOperation(Channel channel) {
        ByteBuf buf = this.getHeaderAndCounterNameBufferAndRead(channel, (short)90, ByteBufUtil.estimateArraySize(this.listenerId));
        ByteBufUtil.writeArray(buf, this.listenerId);
        channel.writeAndFlush((Object)buf);
    }

    @Override
    public Boolean decodePayload(ByteBuf buf, short status) {
        this.checkStatus(status);
        return status == 0;
    }

    @Override
    protected void fetchChannelAndInvoke(int retryCount, Set<SocketAddress> failedServers) {
        if (this.server == null) {
            super.fetchChannelAndInvoke(retryCount, failedServers);
        } else {
            this.channelFactory.fetchChannelAndInvoke(this.server, this);
        }
    }
}

