/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.multimap.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.multimap.operations.AbstractMultimapKeyOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;

@Immutable
public class GetKeyMultimapOperation<V>
extends AbstractMultimapKeyOperation<Collection<V>> {
    private HeaderDecoder<Collection<V>> decoder;
    private int size;
    private Collection<V> result;

    public GetKeyMultimapOperation(Codec codec, ChannelFactory channelFactory, Object key, byte[] keyBytes, byte[] cacheName, AtomicInteger topologyId, int flags, Configuration cfg) {
        super(codec, channelFactory, key, keyBytes, cacheName, topologyId, flags, cfg);
    }

    @Override
    protected void executeOperation(Channel channel) {
        HeaderParams header = this.headerParams((short)103);
        this.decoder = this.scheduleRead(channel, header);
        this.sendArrayOperation(channel, header, this.keyBytes);
    }

    @Override
    public Collection<V> decodePayload(ByteBuf buf, short status) {
        if (HotRodConstants.isNotExist(status)) {
            this.result = Collections.emptySet();
            return this.result;
        }
        if (this.result == null) {
            this.size = ByteBufUtil.readVInt(buf);
            this.result = new HashSet<V>(this.size);
        }
        while (this.result.size() < this.size) {
            Object value = this.codec.readUnmarshallByteArray(buf, status, this.cfg.serialWhitelist(), this.channelFactory.getMarshaller());
            this.result.add(value);
            this.decoder.checkpoint();
        }
        return this.result;
    }
}

