/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.MetadataValueImpl;
import org.infinispan.client.hotrod.impl.operations.AbstractKeyOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

@Immutable
public class GetWithMetadataOperation<V>
extends AbstractKeyOperation<MetadataValue<V>> {
    private static final Log log = LogFactory.getLog(GetWithMetadataOperation.class);
    private static final boolean trace = log.isTraceEnabled();

    public GetWithMetadataOperation(Codec codec, ChannelFactory channelFactory, Object key, byte[] keyBytes, byte[] cacheName, AtomicInteger topologyId, int flags, Configuration cfg) {
        super(codec, channelFactory, key, keyBytes, cacheName, topologyId, flags, cfg);
    }

    @Override
    protected void executeOperation(Channel channel) {
        HeaderParams header = this.headerParams((short)27);
        this.scheduleRead(channel, header);
        this.sendArrayOperation(channel, header, this.keyBytes);
    }

    @Override
    public MetadataValue<V> decodePayload(ByteBuf buf, short status) {
        if (HotRodConstants.isNotExist(status) || !HotRodConstants.isSuccess(status)) {
            return null;
        }
        short flags = buf.readUnsignedByte();
        long creation = -1L;
        int lifespan = -1;
        long lastUsed = -1L;
        int maxIdle = -1;
        if ((flags & 1) != 1) {
            creation = buf.readLong();
            lifespan = ByteBufUtil.readVInt(buf);
        }
        if ((flags & 2) != 2) {
            lastUsed = buf.readLong();
            maxIdle = ByteBufUtil.readVInt(buf);
        }
        long version = buf.readLong();
        if (trace) {
            log.tracef("Received version: %d", version);
        }
        Object value = this.codec.readUnmarshallByteArray(buf, status, this.cfg.serialWhitelist(), this.channelFactory.getMarshaller());
        return new MetadataValueImpl(creation, lifespan, lastUsed, maxIdle, version, value);
    }
}

