/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.protocol;

import io.netty.buffer.ByteBuf;
import java.lang.annotation.Annotation;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.counter.impl.HotRodCounterEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryCreatedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryCustomEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryModifiedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryRemovedEvent;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.exceptions.InvalidResponseException;
import org.infinispan.client.hotrod.exceptions.RemoteIllegalLifecycleStateException;
import org.infinispan.client.hotrod.exceptions.RemoteNodeSuspectException;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.CodecUtils;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Either;
import org.infinispan.commons.util.Util;
import org.infinispan.counter.api.CounterState;

public class Codec20
implements Codec,
HotRodConstants {
    private static final Log log = LogFactory.getLog(Codec20.class, Log.class);
    static final AtomicLong MSG_ID = new AtomicLong();
    final boolean trace = this.getLog().isTraceEnabled();

    private static HotRodCounterEvent decodeCounterEvent(String counterName, ByteBuf buf) {
        short encodedCounterState = buf.readByte();
        long oldValue = buf.readLong();
        long newValue = buf.readLong();
        return new HotRodCounterEvent(counterName, oldValue, Codec20.decodeOldState(encodedCounterState), newValue, Codec20.decodeNewState(encodedCounterState));
    }

    @Override
    public <T> T readUnmarshallByteArray(ByteBuf buf, short status, List<String> whitelist, Marshaller marshaller) {
        return CodecUtils.readUnmarshallByteArray(buf, status, whitelist, marshaller);
    }

    @Override
    public void writeClientListenerInterests(ByteBuf buf, Set<Class<? extends Annotation>> classes) {
    }

    @Override
    public HeaderParams writeHeader(ByteBuf buf, HeaderParams params) {
        return this.writeHeader(buf, params, (byte)20);
    }

    @Override
    public void writeClientListenerParams(ByteBuf buf, ClientListener clientListener, byte[][] filterFactoryParams, byte[][] converterFactoryParams) {
        buf.writeByte((int)((short)(clientListener.includeCurrentState() ? 1 : 0)));
        this.writeNamedFactory(buf, clientListener.filterFactoryName(), filterFactoryParams);
        this.writeNamedFactory(buf, clientListener.converterFactoryName(), converterFactoryParams);
    }

    @Override
    public void writeExpirationParams(ByteBuf buf, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        if (!CodecUtils.isIntCompatible(lifespan)) {
            log.warn("Lifespan value greater than the max supported size (Integer.MAX_VALUE), this can cause precision loss");
        }
        if (!CodecUtils.isIntCompatible(maxIdle)) {
            log.warn("MaxIdle value greater than the max supported size (Integer.MAX_VALUE), this can cause precision loss");
        }
        int lifespanSeconds = CodecUtils.toSeconds(lifespan, lifespanTimeUnit);
        int maxIdleSeconds = CodecUtils.toSeconds(maxIdle, maxIdleTimeUnit);
        ByteBufUtil.writeVInt(buf, lifespanSeconds);
        ByteBufUtil.writeVInt(buf, maxIdleSeconds);
    }

    @Override
    public int estimateExpirationSize(long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        int lifespanSeconds = CodecUtils.toSeconds(lifespan, lifespanTimeUnit);
        int maxIdleSeconds = CodecUtils.toSeconds(maxIdle, maxIdleTimeUnit);
        return ByteBufUtil.estimateVIntSize(lifespanSeconds) + ByteBufUtil.estimateVIntSize(maxIdleSeconds);
    }

    private void writeNamedFactory(ByteBuf buf, String factoryName, byte[][] params) {
        ByteBufUtil.writeString(buf, factoryName);
        if (!factoryName.isEmpty()) {
            if (params != null) {
                buf.writeByte((int)((short)params.length));
                for (byte[] param : params) {
                    ByteBufUtil.writeArray(buf, param);
                }
            } else {
                buf.writeByte(0);
            }
        }
    }

    protected HeaderParams writeHeader(ByteBuf buf, HeaderParams params, byte version) {
        buf.writeByte(160);
        ByteBufUtil.writeVLong(buf, params.messageId((long)Codec20.MSG_ID.incrementAndGet()).messageId);
        buf.writeByte((int)version);
        buf.writeByte((int)params.opCode);
        ByteBufUtil.writeArray(buf, params.cacheName);
        int joinedFlags = params.flags;
        ByteBufUtil.writeVInt(buf, joinedFlags);
        buf.writeByte((int)params.clientIntel);
        int topologyId = params.topologyId.get();
        ByteBufUtil.writeVInt(buf, topologyId);
        if (this.trace) {
            this.getLog().tracef("[%s] Wrote header for messageId=%d to %s. Operation code: %#04x(%s). Flags: %#x. Topology id: %s", new Object[]{new String(params.cacheName), params.messageId, buf, params.opCode, HotRodConstants.Names.of(params.opCode), joinedFlags, topologyId});
        }
        return params;
    }

    @Override
    public int estimateHeaderSize(HeaderParams params) {
        return 1 + ByteBufUtil.estimateVLongSize(params.messageId) + 1 + 1 + ByteBufUtil.estimateArraySize(params.cacheName) + ByteBufUtil.estimateVIntSize(params.flags) + 1 + 1 + ByteBufUtil.estimateVIntSize(params.topologyId.get());
    }

    @Override
    public short readHeader(ByteBuf buf, HeaderParams params, ChannelFactory channelFactory, SocketAddress serverAddress) {
        short magic = this.readMagic(buf);
        long receivedMessageId = this.readMessageId(buf, params);
        short receivedOpCode = buf.readUnsignedByte();
        return this.readPartialHeader(buf, params, receivedOpCode, channelFactory, serverAddress);
    }

    private short readPartialHeader(ByteBuf buf, HeaderParams params, short receivedOpCode, ChannelFactory channelFactory, SocketAddress serverAddress) {
        short status = buf.readUnsignedByte();
        this.readNewTopologyIfPresent(buf, params, channelFactory);
        if (receivedOpCode != params.opRespCode) {
            if (receivedOpCode == 80) {
                this.checkForErrorsInResponseStatus(buf, params, status, serverAddress);
            }
            throw new InvalidResponseException(String.format("[%s] Invalid response operation. Expected %#x and received %#x", new String(params.cacheName), params.opRespCode, receivedOpCode));
        }
        if (this.trace) {
            this.getLog().tracef("[%s] Received operation code is: %#04x(%s)", new String(params.cacheName), receivedOpCode, HotRodConstants.Names.of(receivedOpCode));
        }
        return status;
    }

    @Override
    public ClientEvent readEvent(ByteBuf buf, byte[] expectedListenerId, Marshaller marshaller, List<String> whitelist, SocketAddress serverAddress) {
        this.readMagic(buf);
        this.readMessageId(buf, null);
        short eventTypeId = buf.readUnsignedByte();
        return this.readPartialEvent(buf, expectedListenerId, marshaller, eventTypeId, whitelist, serverAddress);
    }

    private static CounterState decodeOldState(short encoded) {
        switch (encoded & 3) {
            case 0: {
                return CounterState.VALID;
            }
            case 1: {
                return CounterState.LOWER_BOUND_REACHED;
            }
            case 2: {
                return CounterState.UPPER_BOUND_REACHED;
            }
        }
        throw new IllegalStateException();
    }

    private static CounterState decodeNewState(short encoded) {
        switch (encoded & 0xC) {
            case 0: {
                return CounterState.VALID;
            }
            case 4: {
                return CounterState.LOWER_BOUND_REACHED;
            }
            case 8: {
                return CounterState.UPPER_BOUND_REACHED;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public HotRodCounterEvent readCounterEvent(ByteBuf buf, byte[] listenerId) {
        this.readAndValidateHeader(buf);
        String counterName = ByteBufUtil.readString(buf);
        byte[] receivedListenerId = ByteBufUtil.readArray(buf);
        assert (Arrays.equals(receivedListenerId, listenerId));
        return Codec20.decodeCounterEvent(counterName, buf);
    }

    protected ClientEvent readPartialEvent(ByteBuf buf, byte[] expectedListenerId, Marshaller marshaller, short eventTypeId, List<String> whitelist, SocketAddress serverAddress) {
        boolean isRetried;
        ClientEvent.Type eventType;
        short status = buf.readUnsignedByte();
        buf.readUnsignedByte();
        switch (eventTypeId) {
            case 96: {
                eventType = ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED;
                break;
            }
            case 97: {
                eventType = ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED;
                break;
            }
            case 98: {
                eventType = ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED;
                break;
            }
            case 80: {
                this.checkForErrorsInResponseStatus(buf, null, status, serverAddress);
            }
            default: {
                throw log.unknownEvent(eventTypeId);
            }
        }
        byte[] listenerId = ByteBufUtil.readArray(buf);
        if (!Arrays.equals(listenerId, expectedListenerId)) {
            throw log.unexpectedListenerId(Util.printArray((byte[])listenerId), Util.printArray((byte[])expectedListenerId));
        }
        short isCustom = buf.readUnsignedByte();
        boolean bl = isRetried = buf.readUnsignedByte() == 1;
        if (isCustom == 1) {
            Object eventData = MarshallerUtil.bytes2obj(marshaller, ByteBufUtil.readArray(buf), status, whitelist);
            return this.createCustomEvent(eventData, eventType, isRetried);
        }
        switch (eventType) {
            case CLIENT_CACHE_ENTRY_CREATED: {
                Object createdKey = MarshallerUtil.bytes2obj(marshaller, ByteBufUtil.readArray(buf), status, whitelist);
                long createdDataVersion = buf.readLong();
                return this.createCreatedEvent(createdKey, createdDataVersion, isRetried);
            }
            case CLIENT_CACHE_ENTRY_MODIFIED: {
                Object modifiedKey = MarshallerUtil.bytes2obj(marshaller, ByteBufUtil.readArray(buf), status, whitelist);
                long modifiedDataVersion = buf.readLong();
                return this.createModifiedEvent(modifiedKey, modifiedDataVersion, isRetried);
            }
            case CLIENT_CACHE_ENTRY_REMOVED: {
                Object removedKey = MarshallerUtil.bytes2obj(marshaller, ByteBufUtil.readArray(buf), status, whitelist);
                return this.createRemovedEvent(removedKey, isRetried);
            }
        }
        throw log.unknownEvent(eventTypeId);
    }

    @Override
    public Either<Short, ClientEvent> readHeaderOrEvent(ByteBuf buf, HeaderParams params, byte[] expectedListenerId, Marshaller marshaller, List<String> whitelist, ChannelFactory channelFactory, SocketAddress serverAddress) {
        this.readMagic(buf);
        this.readMessageId(buf, null);
        short opCode = buf.readUnsignedByte();
        switch (opCode) {
            case 96: 
            case 97: 
            case 98: {
                ClientEvent clientEvent = this.readPartialEvent(buf, expectedListenerId, marshaller, opCode, whitelist, serverAddress);
                return Either.newRight((Object)clientEvent);
            }
        }
        return Either.newLeft((Object)this.readPartialHeader(buf, params, opCode, channelFactory, serverAddress));
    }

    @Override
    public Object returnPossiblePrevValue(ByteBuf buf, short status, int flags, List<String> whitelist, Marshaller marshaller) {
        if (HotRodConstants.hasPrevious(status)) {
            return CodecUtils.readUnmarshallByteArray(buf, status, whitelist, marshaller);
        }
        return null;
    }

    protected ClientEvent createRemovedEvent(final Object key, final boolean isRetried) {
        return new ClientCacheEntryRemovedEvent(){

            public Object getKey() {
                return key;
            }

            @Override
            public ClientEvent.Type getType() {
                return ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED;
            }

            @Override
            public boolean isCommandRetried() {
                return isRetried;
            }

            public String toString() {
                return "ClientCacheEntryRemovedEvent(key=" + key + ")";
            }
        };
    }

    protected ClientCacheEntryModifiedEvent createModifiedEvent(final Object key, final long dataVersion, final boolean isRetried) {
        return new ClientCacheEntryModifiedEvent(){

            public Object getKey() {
                return key;
            }

            @Override
            public long getVersion() {
                return dataVersion;
            }

            @Override
            public ClientEvent.Type getType() {
                return ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED;
            }

            @Override
            public boolean isCommandRetried() {
                return isRetried;
            }

            public String toString() {
                return "ClientCacheEntryModifiedEvent(key=" + key + ",dataVersion=" + dataVersion + ")";
            }
        };
    }

    protected ClientCacheEntryCreatedEvent<Object> createCreatedEvent(final Object key, final long dataVersion, final boolean isRetried) {
        return new ClientCacheEntryCreatedEvent<Object>(){

            @Override
            public Object getKey() {
                return key;
            }

            @Override
            public long getVersion() {
                return dataVersion;
            }

            @Override
            public ClientEvent.Type getType() {
                return ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED;
            }

            @Override
            public boolean isCommandRetried() {
                return isRetried;
            }

            public String toString() {
                return "ClientCacheEntryCreatedEvent(key=" + key + ",dataVersion=" + dataVersion + ")";
            }
        };
    }

    protected ClientCacheEntryCustomEvent<Object> createCustomEvent(final Object eventData, final ClientEvent.Type eventType, final boolean isRetried) {
        return new ClientCacheEntryCustomEvent<Object>(){

            @Override
            public Object getEventData() {
                return eventData;
            }

            @Override
            public ClientEvent.Type getType() {
                return eventType;
            }

            @Override
            public boolean isCommandRetried() {
                return isRetried;
            }

            public String toString() {
                return "ClientCacheEntryCustomEvent(eventData=" + eventData + ", eventType=" + (Object)((Object)eventType) + ")";
            }
        };
    }

    private long readMessageId(ByteBuf buf, HeaderParams params) {
        long receivedMessageId = ByteBufUtil.readVLong(buf);
        Log localLog = this.getLog();
        if (params != null && receivedMessageId != params.messageId && receivedMessageId != 0L) {
            String message = "Invalid message id. Expected %d and received %d";
            localLog.invalidMessageId(params.messageId, receivedMessageId);
            if (this.trace) {
                localLog.tracef("Socket dump: %s", ByteBufUtil.hexDump(buf));
            }
            throw new InvalidResponseException(String.format(message, params.messageId, receivedMessageId));
        }
        if (this.trace) {
            localLog.tracef("Received response for messageId=%d", receivedMessageId);
        }
        return receivedMessageId;
    }

    private short readMagic(ByteBuf buf) {
        short magic = buf.readUnsignedByte();
        if (magic != 161) {
            Log localLog = this.getLog();
            localLog.invalidMagicNumber((short)161, magic);
            if (this.trace) {
                localLog.tracef("Socket dump: %s", ByteBufUtil.hexDump(buf));
            }
            throw new InvalidResponseException(String.format("Invalid magic number. Expected %#x and received %#x", (short)161, magic));
        }
        return magic;
    }

    @Override
    public Log getLog() {
        return log;
    }

    protected void checkForErrorsInResponseStatus(ByteBuf buf, HeaderParams params, short status, SocketAddress serverAddress) {
        Log localLog = this.getLog();
        if (this.trace) {
            localLog.tracef("[%s] Received operation status: %#x", new String(params.cacheName), status);
        }
        try {
            switch (status) {
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: {
                    String msgFromServer = ByteBufUtil.readString(buf);
                    if (status == 134 && this.trace) {
                        localLog.tracef("Server-side timeout performing operation: %s", msgFromServer);
                    } else {
                        localLog.errorFromServer(msgFromServer);
                    }
                    throw new HotRodClientException(msgFromServer, params.messageId, status);
                }
                case 136: {
                    String msgFromServer = ByteBufUtil.readString(buf);
                    throw new RemoteIllegalLifecycleStateException(msgFromServer, params.messageId, status, serverAddress);
                }
                case 135: {
                    String msgFromServer = ByteBufUtil.readString(buf);
                    if (this.trace) {
                        localLog.tracef("[%s] A remote node was suspected while executing messageId=%d. Check if retry possible. Message from server: %s", new String(params.cacheName), params.messageId, msgFromServer);
                    }
                    throw new RemoteNodeSuspectException(msgFromServer, params.messageId, status);
                }
            }
            throw new IllegalStateException(String.format("Unknown status: %#04x", status));
        }
        catch (Throwable throwable) {
            switch (status) {
                default: 
            }
            throw throwable;
        }
    }

    protected void readNewTopologyIfPresent(ByteBuf buf, HeaderParams params, ChannelFactory channelFactory) {
        short topologyChangeByte = buf.readUnsignedByte();
        if (topologyChangeByte == 1) {
            this.readNewTopologyAndHash(buf, params, channelFactory);
        }
    }

    protected void readNewTopologyAndHash(ByteBuf buf, HeaderParams params, ChannelFactory channelFactory) {
        SocketAddress[][] segmentOwners;
        short hashFunctionVersion;
        Log localLog = this.getLog();
        int newTopologyId = ByteBufUtil.readVInt(buf);
        Object[] addresses = this.readTopology(buf);
        if (params.clientIntel == ClientIntelligence.HASH_DISTRIBUTION_AWARE.getValue()) {
            hashFunctionVersion = buf.readUnsignedByte();
            int numSegments = ByteBufUtil.readVInt(buf);
            segmentOwners = new SocketAddress[numSegments][];
            if (hashFunctionVersion > 0) {
                for (int i = 0; i < numSegments; ++i) {
                    int numOwners = buf.readUnsignedByte();
                    segmentOwners[i] = new SocketAddress[numOwners];
                    for (int j = 0; j < numOwners; ++j) {
                        int memberIndex = ByteBufUtil.readVInt(buf);
                        segmentOwners[i][j] = addresses[memberIndex];
                    }
                }
            }
        } else {
            hashFunctionVersion = -1;
            segmentOwners = null;
        }
        int currentTopology = channelFactory.getTopologyId(params.cacheName);
        int topologyAge = channelFactory.getTopologyAge();
        if (params.topologyAge == topologyAge && currentTopology != newTopologyId) {
            params.topologyId.set(newTopologyId);
            List<SocketAddress> addressList = Arrays.asList(addresses);
            if (localLog.isInfoEnabled()) {
                localLog.newTopology(newTopologyId, topologyAge, addresses.length, new HashSet<SocketAddress>(addressList));
            }
            channelFactory.updateServers(addressList, params.cacheName, false);
            if (hashFunctionVersion >= 0) {
                if (this.trace) {
                    String cacheNameString = new String(params.cacheName);
                    if (hashFunctionVersion == 0) {
                        localLog.tracef("[%s] Not using a consistent hash function (hash function version == 0).", cacheNameString);
                    } else {
                        localLog.tracef("[%s] Updating client hash function with %s number of segments", cacheNameString, segmentOwners.length);
                    }
                }
                channelFactory.updateHashFunction(segmentOwners, segmentOwners.length, hashFunctionVersion, params.cacheName, params.topologyId);
            }
        } else if (this.trace) {
            localLog.tracef("[%s] Outdated topology received (topology id = %s, topology age = %s), so ignoring it: %s", new Object[]{new String(params.cacheName), newTopologyId, topologyAge, Arrays.toString(addresses)});
        }
    }

    private SocketAddress[] readTopology(ByteBuf buf) {
        int clusterSize = ByteBufUtil.readVInt(buf);
        SocketAddress[] addresses = new SocketAddress[clusterSize];
        for (int i = 0; i < clusterSize; ++i) {
            String host = ByteBufUtil.readString(buf);
            int port = buf.readUnsignedShort();
            addresses[i] = InetSocketAddress.createUnresolved(host, port);
        }
        return addresses;
    }

    private void readAndValidateHeader(ByteBuf buf) {
        this.readMagic(buf);
        this.readMessageId(buf, null);
        short responseCode = buf.readByte();
        assert (responseCode == 102);
        short status = buf.readByte();
        assert (status == 0);
        short topology = buf.readByte();
        assert (topology == 0);
    }
}

