/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelRecord;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

@ChannelHandler.Sharable
class ActivationHandler
extends ChannelInboundHandlerAdapter {
    static final String NAME = "activation-handler";
    static final ActivationHandler INSTANCE = new ActivationHandler();
    private static final Log log = LogFactory.getLog(ActivationHandler.class);
    private static final boolean trace = log.isTraceEnabled();
    static final Object ACTIVATION_EVENT = new Object();

    ActivationHandler() {
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (trace) {
            log.tracef("Activating channel %s", ctx.channel());
        }
        ChannelRecord.of(ctx.channel()).complete(ctx.channel());
        ctx.pipeline().remove((ChannelHandler)this);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt == ACTIVATION_EVENT) {
            this.channelActive(ctx);
        } else {
            ctx.fireUserEventTriggered(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Channel channel = ctx.channel();
        if (trace) {
            log.tracef(cause, "Failed to activate channel %s", channel);
        }
        try {
            ctx.close();
        }
        finally {
            ChannelRecord channelRecord = ChannelRecord.of(channel);
            channelRecord.completeExceptionally(new TransportException(cause, channelRecord.getUnresolvedAddress()));
        }
    }
}

