/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.infinispan.client.hotrod.event.impl.ClientListenerNotifier;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelRecord;
import org.infinispan.client.hotrod.impl.transport.netty.HintedReplayingDecoder;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.util.Util;

abstract class EventDispatcher<T>
extends HintedReplayingDecoder<Void> {
    static final Log log = LogFactory.getLog(EventDispatcher.class);
    static final boolean trace = log.isTraceEnabled();
    static final AtomicReferenceFieldUpdater<EventDispatcher, DispatcherStatus> statusUpdater = AtomicReferenceFieldUpdater.newUpdater(EventDispatcher.class, DispatcherStatus.class, "status");
    public static final String NAME = "event-dispatcher";
    final ClientListenerNotifier notifier;
    final Object listener;
    final byte[] listenerId;
    final Channel channel;
    final String cacheName;
    volatile DispatcherStatus status = DispatcherStatus.STOPPED;

    EventDispatcher(ClientListenerNotifier notifier, String cacheName, Object listener, byte[] listenerId, Channel channel) {
        this.notifier = notifier;
        this.listener = listener;
        this.listenerId = listenerId;
        this.channel = channel;
        this.cacheName = cacheName;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        T event;
        try {
            event = this.readEvent(buf);
        }
        catch (Exception e) {
            log.unableToReadEventFromServer(e, this.channel.remoteAddress());
            if (statusUpdater.compareAndSet(this, DispatcherStatus.RUNNING, DispatcherStatus.STOPPED)) {
                ctx.pipeline().remove((ChannelHandler)this);
                ctx.close();
                this.notifier.failoverClientListener(new WrappedByteArray(this.listenerId));
            }
            return;
        }
        try {
            this.invokeEvent(event);
        }
        catch (Throwable t) {
            log.unexpectedErrorConsumingEvent(event, t);
        }
    }

    public abstract CompletableFuture<Short> executeFailover();

    protected abstract T readEvent(ByteBuf var1);

    protected abstract void invokeEvent(T var1);

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (statusUpdater.compareAndSet(this, DispatcherStatus.RUNNING, DispatcherStatus.STOPPED)) {
            log.debugf("Connection to %s reset by peer, so failover client listener %s", ChannelRecord.of(this.channel).getUnresolvedAddress(), Util.printArray((byte[])this.listenerId));
            this.notifier.failoverClientListener(new WrappedByteArray(this.listenerId));
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.unrecoverableErrorReadingEvent(cause, this.channel.remoteAddress(), Util.printArray((byte[])this.listenerId));
        if (statusUpdater.compareAndSet(this, DispatcherStatus.RUNNING, DispatcherStatus.STOPPED)) {
            ctx.pipeline().remove((ChannelHandler)this);
            ctx.close();
            this.notifier.channelFactory().releaseChannel(this.channel);
        }
    }

    protected void invokeFailoverEvent() {
    }

    static enum DispatcherStatus {
        STOPPED,
        RUNNING;

    }
}

