/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.marshall;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.List;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;

public final class MarshallerUtil {
    private static final Log log = LogFactory.getLog(MarshallerUtil.class, Log.class);

    private MarshallerUtil() {
    }

    public static <T> T bytes2obj(Marshaller marshaller, byte[] bytes, short status, List<String> whitelist) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try {
            T ois;
            Object ret = marshaller.objectFromByteBuffer(bytes);
            if (HotRodConstants.hasCompatibility(status) && ret instanceof byte[] && MarshallerUtil.isJavaSerialized((byte[])ret) && (ois = MarshallerUtil.tryJavaDeserialize(bytes, (byte[])ret, whitelist)) != null) {
                return ois;
            }
            return (T)ret;
        }
        catch (Exception e) {
            throw log.unableToUnmarshallBytes(Util.toHexString((byte[])bytes), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T tryJavaDeserialize(byte[] bytes, byte[] ret, List<String> whitelist) {
        try (CheckedInputStream ois = new CheckedInputStream(new ByteArrayInputStream(ret), whitelist);){
            Object object = ois.readObject();
            return (T)object;
        }
        catch (CacheException ce) {
            throw ce;
        }
        catch (Exception ee) {
            if (!log.isDebugEnabled()) return null;
            log.debugf("Standard deserialization not in use for %s", Util.printArray((byte[])bytes));
            return null;
        }
    }

    private static boolean isJavaSerialized(byte[] bytes) {
        if (bytes.length > 2) {
            short magic = (short)((bytes[1] & 0xFF) + (bytes[0] << 8));
            return magic == -21267;
        }
        return false;
    }

    public static byte[] obj2bytes(Marshaller marshaller, Object o, boolean isKey, int estimateKeySize, int estimateValueSize) {
        try {
            return marshaller.objectToByteBuffer(o, isKey ? estimateKeySize : estimateValueSize);
        }
        catch (IOException ioe) {
            throw new HotRodClientException("Unable to marshall object of type [" + o.getClass().getName() + "]", ioe);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    private static final class CheckedInputStream
    extends ObjectInputStream {
        private final List<String> whitelist;

        public CheckedInputStream(InputStream in, List<String> whitelist) throws IOException {
            super(in);
            this.whitelist = whitelist;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            boolean safeClass = MarshallUtil.isSafeClass((String)desc.getName(), this.whitelist);
            if (!safeClass) {
                throw log.classNotInWhitelist(desc.getName());
            }
            return super.resolveClass(desc);
        }
    }
}

